/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.JavaLoggerFormatter;
import org.apache.ignite3.lang.ErrorGroups;

public class TooOldTransactionException
extends IgniteInternalException {
    TooOldTransactionException(HybridTimestamp timestamp) {
        super(ErrorGroups.Transactions.TX_READ_ONLY_TOO_OLD_ERR, TooOldTransactionException.formatTimestamp(timestamp));
    }

    private static String formatTimestamp(HybridTimestamp timestamp) {
        OffsetDateTime offsetDateTime = Instant.ofEpochMilli(timestamp.getPhysical()).atOffset(ZoneOffset.UTC);
        return JavaLoggerFormatter.DATE_FORMATTER.format(offsetDateTime);
    }
}

