/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.expiration;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite3.internal.binarytuple.BinaryTuplePrefixBuilder;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.table.IndexScanCriteria;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.OperationContext;
import org.apache.ignite3.internal.table.TxContext;
import org.apache.ignite3.internal.table.distributed.expiration.ExpiredRowsScanner;
import org.apache.ignite3.internal.table.distributed.expiration.ScannedRowsCollector;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.sql.ColumnType;

class ExpiredRowsScannerImpl
implements ExpiredRowsScanner {
    ExpiredRowsScannerImpl() {
    }

    @Override
    public CompletableFuture<List<BinaryRowEx>> scan(InternalTransaction transaction, SchemaDescriptor schemaDescriptor, InternalTable internalTable, HybridTimestamp hybridTimestamp, int scannedColIndexId, ColumnType scannedColType, int batchSize, int partitionId, InternalClusterNode localMember) {
        ScannedRowsCollector handler = new ScannedRowsCollector(batchSize, schemaDescriptor);
        TxContext txContext = TxContext.readOnly(transaction.id(), localMember.id(), hybridTimestamp);
        Flow.Publisher<BinaryRow> publisher = internalTable.scan(partitionId, localMember, scannedColIndexId, IndexScanCriteria.range(null, ExpiredRowsScannerImpl.timeNowAsBinaryTuplePrefix(scannedColType), 2), OperationContext.create(txContext));
        publisher.subscribe(handler);
        return handler.result();
    }

    private static BinaryTuplePrefix timeNowAsBinaryTuplePrefix(ColumnType type) {
        BinaryTuplePrefixBuilder builder = new BinaryTuplePrefixBuilder(1, 1, 1);
        if (type == ColumnType.DATETIME) {
            builder.appendDateTime(LocalDateTime.now());
        } else if (type == ColumnType.TIMESTAMP) {
            builder.appendTimestamp(Instant.now());
        }
        ByteBuffer upperBound = builder.build();
        return BinaryTuplePrefix.fromBinaryTuple(new BinaryTuple(1, upperBound));
    }
}

