/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbTombstonesStorage;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;
import org.apache.ignite3.internal.storage.tombstones.TombstonesCursor;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;

public class RocksDbTombstonesCursor
extends TombstonesCursor {
    private final RocksDbMvPartitionStorage storage;
    private final RocksIterator it;

    RocksDbTombstonesCursor(RocksDbMvPartitionStorage storage, RocksDB db, ColumnFamilyHandle tombstonesCfHandle, @Nullable HybridTimestamp lowerBoundExcluding, @Nullable HybridTimestamp upperBoundIncluding) {
        super(lowerBoundExcluding, upperBoundIncluding);
        this.storage = storage;
        this.it = db.newIterator(tombstonesCfHandle, storage.helper().upperBoundReadOpts);
        this.it.seek(storage.helper().partitionStartPrefix());
    }

    @Override
    public boolean hasNext() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfInProgressOfRebalance();
            return super.hasNext();
        });
    }

    @Override
    public Tombstone next() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfInProgressOfRebalance();
            return super.next();
        });
    }

    @Override
    protected void advanceIfNeeded() {
        RowId rowId;
        long timestamp;
        if (this.next != null) {
            return;
        }
        while (true) {
            if (RocksDbMvPartitionStorage.invalid(this.it)) {
                return;
            }
            ByteBuffer keyBuffer = RocksDbTombstonesStorage.readTombstonesKey(this.it);
            timestamp = RocksDbTombstonesStorage.readTimestampLongDesc(keyBuffer);
            if (this.outsideBounds(timestamp)) {
                this.it.next();
                continue;
            }
            rowId = RocksDbTombstonesStorage.readRowId(keyBuffer, this.storage.helper());
            if (!this.equalsToLastRowId(rowId)) break;
            this.it.next();
        }
        this.next = new Tombstone(rowId, HybridTimestamp.hybridTimestamp(timestamp));
        this.it.next();
    }

    @Override
    public void close() {
        this.it.close();
    }
}

