/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv.tombstones;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.reuse.ReuseList;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.io.TombstonesInnerIo;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.io.TombstonesIo;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.io.TombstonesLeafIo;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.io.TombstonesMetaIo;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;
import org.jetbrains.annotations.Nullable;

public class TombstonesTree
extends BplusTree<Tombstone, Tombstone> {
    public TombstonesTree(int tableId, int partId, PageMemory pageMem, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, boolean initNew) throws IgniteInternalCheckedException {
        super("TombstonesTree_" + tableId, tableId, Integer.toString(tableId), partId, pageMem, globalRmvId, metaPageId, reuseList);
        this.setIos(TombstonesInnerIo.VERSIONS, TombstonesLeafIo.VERSIONS, TombstonesMetaIo.VERSIONS);
        this.initTree(initNew);
    }

    @Override
    protected int compare(BplusIo<Tombstone> io, long pageAddr, int idx, Tombstone row) {
        TombstonesIo tombstoneIo = (TombstonesIo)((Object)io);
        return tombstoneIo.compare(pageAddr, idx, row);
    }

    @Override
    public Tombstone getRow(BplusIo<Tombstone> io, long pageAddr, int idx, Object x) {
        TombstonesIo tombstoneIo = (TombstonesIo)((Object)io);
        return tombstoneIo.getRow(pageAddr, idx, this.partId);
    }

    public void add(RowId rowId, HybridTimestamp timestamp) {
        try {
            this.put(new Tombstone(rowId, timestamp));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error occurred while adding entry to the tombstones tree: [rowId={}, timestamp={}, {}]", (Throwable)e, rowId, timestamp);
        }
    }

    public boolean remove(RowId rowId, HybridTimestamp timestamp) {
        try {
            return this.removex(new Tombstone(rowId, timestamp));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error occurred while deleting the entry from the tombstones tree: [rowId={}, timestamp={}, {}]", (Throwable)e, rowId, timestamp);
        }
    }

    @Nullable
    public Tombstone getFirst() {
        try {
            return (Tombstone)this.findFirst();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error occurred while getting the first element from the tombstones tree", (Throwable)e);
        }
    }
}

