/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.util.GradualTask;
import org.apache.ignite3.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.storage.pagememory.VolatilePageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateLogTree;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainKey;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;
import org.apache.ignite3.internal.storage.util.LocalLocker;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class VolatilePageMemoryMvPartitionStorage
extends AbstractPageMemoryMvPartitionStorage {
    private static final Predicate<HybridTimestamp> NEVER_LOAD_VALUE = ts -> false;
    private static final AtomicLongFieldUpdater<VolatilePageMemoryMvPartitionStorage> ESTIMATED_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(VolatilePageMemoryMvPartitionStorage.class, "estimatedSize");
    private volatile long lastAppliedIndex;
    private volatile long lastAppliedTerm;
    @Nullable
    private volatile LeaseInfo leaseInfo;
    private volatile byte @Nullable [] groupConfig;
    private volatile long estimatedSize;

    public VolatilePageMemoryMvPartitionStorage(VolatilePageMemoryTableStorage tableStorage, int partitionId, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue, ExecutorService destructionExecutor, UpdateLogTree updateLogTree, FailureProcessor failureProcessor) {
        super(partitionId, tableStorage, new RenewablePartitionStorageState(tableStorage, partitionId, versionChainTree, tableStorage.dataRegion().freeList(), indexMetaTree, gcQueue, null), destructionExecutor, updateLogTree, failureProcessor);
    }

    @Override
    protected GradualTaskExecutor createGradualTaskExecutor(ExecutorService threadPool) {
        return new GradualTaskExecutor(threadPool);
    }

    @Override
    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        LocalLocker locker = (LocalLocker)THREAD_LOCAL_LOCKER.get();
        if (locker != null) {
            return closure.execute(locker);
        }
        return (V)this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            LocalLocker locker0 = new LocalLocker(this.lockByRowId);
            THREAD_LOCAL_LOCKER.set(locker0);
            try {
                Object v = closure.execute(locker0);
                return v;
            }
            finally {
                THREAD_LOCAL_LOCKER.remove();
                locker0.unlockAll();
            }
        });
    }

    @Override
    public CompletableFuture<Void> flush(boolean trigger) {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            return CompletableFutures.nullCompletedFuture();
        });
    }

    @Override
    public long lastAppliedIndex() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            return this.lastAppliedIndex;
        });
    }

    @Override
    public long lastAppliedTerm() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            return this.lastAppliedTerm;
        });
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.lastAppliedIndex = lastAppliedIndex;
            this.lastAppliedTerm = lastAppliedTerm;
            return null;
        });
    }

    @Override
    public byte @Nullable [] committedGroupConfiguration() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            byte[] currentConfig = this.groupConfig;
            return currentConfig == null ? null : Arrays.copyOf(currentConfig, currentConfig.length);
        });
    }

    @Override
    public void committedGroupConfiguration(byte[] config) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.groupConfig = Arrays.copyOf(config, config.length);
            return null;
        });
    }

    @Override
    public void updateLease(LeaseInfo leaseInfo) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            LeaseInfo thisLeaseInfo = this.leaseInfo;
            if (thisLeaseInfo != null && leaseInfo.leaseStartTime() <= thisLeaseInfo.leaseStartTime()) {
                return null;
            }
            this.leaseInfo = leaseInfo;
            return null;
        });
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            return this.leaseInfo;
        });
    }

    @Override
    public void lastAppliedOnRebalance(long lastAppliedIndex, long lastAppliedTerm) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
    }

    public CompletableFuture<Void> destroyStructures() {
        RenewablePartitionStorageState localState = this.renewableState;
        CompletableFuture<Void> destroyFuture = CompletableFuture.allOf(this.startMvDataDestruction(localState), this.startIndexMetaTreeDestruction(localState), this.startGarbageCollectionTreeDestruction(localState), this.startUpdateLogTreeDestruction(), this.indexes.destroyStructures());
        this.lastAppliedIndex = 0L;
        this.lastAppliedTerm = 0L;
        this.groupConfig = null;
        this.leaseInfo = null;
        return destroyFuture;
    }

    private CompletableFuture<Void> startMvDataDestruction(RenewablePartitionStorageState renewableState) {
        return this.destroyTree(renewableState.versionChainTree(), chainKey -> this.destroyVersionChain((VersionChain)chainKey, renewableState)).whenComplete((res, e) -> {
            if (e != null) {
                String errorMessage = String.format("Version chains destruction failed: [tableId=%s, partitionId=%s]", this.tableStorage.getTableId(), this.partitionId);
                this.failureProcessor.process(new FailureContext((Throwable)e, errorMessage));
            }
        });
    }

    private void destroyVersionChain(VersionChain chainKey, RenewablePartitionStorageState renewableState) {
        try {
            this.deleteRowVersionsFromFreeList(chainKey, renewableState);
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalException(e);
        }
    }

    @Override
    public void discard(RowId rowId) throws StorageException {
        this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            assert (VolatilePageMemoryMvPartitionStorage.rowIsLocked(rowId));
            try {
                VersionChain removed = (VersionChain)this.renewableState.versionChainTree().remove(new VersionChainKey(rowId));
                if (removed != null) {
                    this.destroyVersionChain(removed, this.renewableState);
                }
                return null;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Cannot discard version chain: [rowId={}, {}]", (Throwable)e, rowId, this.createStorageInfo());
            }
        });
    }

    private void deleteRowVersionsFromFreeList(VersionChain chain, RenewablePartitionStorageState renewableState) throws IgniteInternalCheckedException {
        long rowVersionLink = chain.headLink();
        while (rowVersionLink != 0L) {
            RowVersion rowVersion = this.readRowVersion(rowVersionLink, NEVER_LOAD_VALUE);
            renewableState.freeList().removeDataRowByLink(rowVersion.link());
            rowVersionLink = rowVersion.nextLink();
        }
    }

    private CompletableFuture<Void> startIndexMetaTreeDestruction(RenewablePartitionStorageState renewableState) {
        return this.destroyTree(renewableState.indexMetaTree(), null).whenComplete((res, e) -> {
            if (e != null) {
                String errorMessage = String.format("Index meta tree destruction failed: [tableId=%s, partitionId=%s]", this.tableStorage.getTableId(), this.partitionId);
                this.failureProcessor.process(new FailureContext((Throwable)e, errorMessage));
            }
        });
    }

    private CompletableFuture<Void> startGarbageCollectionTreeDestruction(RenewablePartitionStorageState renewableState) {
        return this.destroyTree(renewableState.gcQueue(), null).whenComplete((res, e) -> {
            if (e != null) {
                String errorMessage = String.format("Garbage collection tree destruction failed: [tableId=%s, partitionId=%s]", this.tableStorage.getTableId(), this.partitionId);
                this.failureProcessor.process(new FailureContext((Throwable)e, errorMessage));
            }
        });
    }

    private CompletableFuture<Void> startUpdateLogTreeDestruction() {
        return this.destroyTree(this.updateLogTree, null).whenComplete((res, e) -> {
            if (e != null) {
                String errorMessage = String.format("Update log tree destruction failed: [tableId={}, partitionId={}]", e, this.tableStorage.getTableId(), this.partitionId);
                this.failureProcessor.process(new FailureContext((Throwable)e, errorMessage));
            }
        });
    }

    private <T> CompletableFuture<Void> destroyTree(BplusTree<T, ?> target, @Nullable Consumer<T> consumer) {
        try {
            GradualTask task = target.startGradualDestruction(consumer, false, 1000);
            return this.destructionExecutor.execute(task);
        }
        catch (IgniteInternalCheckedException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    List<AutoCloseable> getResourcesToCloseOnCleanup() {
        RenewablePartitionStorageState localState = this.renewableState;
        return List.of(localState.versionChainTree()::close, localState.indexMetaTree()::close, localState.gcQueue()::close, this.updateLogTree::close);
    }

    public void updateDataStructures(VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue, UpdateLogTree updateLogTree) {
        StorageUtils.throwExceptionIfStorageNotInCleanupOrRebalancedState((StorageState)((Object)this.state.get()), this::createStorageInfo);
        RenewablePartitionStorageState prevState = this.renewableState;
        this.updateRenewableState(versionChainTree, prevState.freeList(), indexMetaTree, gcQueue, null);
        this.updateLogTree = updateLogTree;
        this.estimatedSize = 0L;
    }

    @Override
    public void committedGroupConfigurationOnRebalance(byte[] config) throws StorageException {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.groupConfig = config;
    }

    @Override
    public void updateLeaseOnRebalance(LeaseInfo leaseInfo) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.leaseInfo = leaseInfo;
    }

    @Override
    public long estimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public void incrementEstimatedSize() {
        ESTIMATED_SIZE_UPDATER.incrementAndGet(this);
    }

    @Override
    public void decrementEstimatedSize() {
        ESTIMATED_SIZE_UPDATER.decrementAndGet(this);
    }

    @Override
    public boolean snapshotTombstonesPreservationSupported() {
        return false;
    }

    @Override
    public Cursor<Tombstone> scanSnapshotTombstones(@Nullable HybridTimestamp fromExcluding, @Nullable HybridTimestamp toIncluding) throws StorageException {
        throw new UnsupportedOperationException("Snapshot tombstones preservation is not supported for volatile storage");
    }

    @Override
    public void clearSnapshotTombstones(HybridTimestamp upperBoundExcluding) {
    }
}

