/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.index;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.type.NativeType;

public class StorageHashIndexDescriptor
implements StorageIndexDescriptor {
    private final int id;
    @IgniteToStringInclude
    private final List<StorageHashIndexColumnDescriptor> columns;
    private final boolean mustBeBuilt;

    public StorageHashIndexDescriptor(CatalogTableDescriptor table, CatalogHashIndexDescriptor index) {
        this(index.id(), StorageHashIndexDescriptor.extractIndexColumnsConfiguration(table, index), !index.isCreatedWithTable());
    }

    public StorageHashIndexDescriptor(int indexId, List<StorageHashIndexColumnDescriptor> columns, boolean mustBeBuilt) {
        this.id = indexId;
        this.columns = columns;
        this.mustBeBuilt = mustBeBuilt;
    }

    @Override
    public int id() {
        return this.id;
    }

    public List<StorageHashIndexColumnDescriptor> columns() {
        return this.columns;
    }

    @Override
    public boolean mustBeBuilt() {
        return this.mustBeBuilt;
    }

    public String toString() {
        return S.toString(this);
    }

    private static List<StorageHashIndexColumnDescriptor> extractIndexColumnsConfiguration(CatalogTableDescriptor table, CatalogHashIndexDescriptor index) {
        assert (table.id() == index.tableId()) : "indexId=" + index.id() + ", tableId=" + table.id() + ", indexTableId=" + index.tableId();
        return index.columnIds().intStream().mapToObj(id -> {
            CatalogTableColumnDescriptor column = table.columnById(id);
            assert (column != null) : "indexId=" + index.id() + ", id=" + id;
            return new StorageHashIndexColumnDescriptor(column.name(), StorageIndexDescriptor.getNativeType(column), column.nullable());
        }).collect(Collectors.toList());
    }

    public static class StorageHashIndexColumnDescriptor
    implements StorageIndexDescriptor.StorageColumnDescriptor {
        private final String name;
        @IgniteToStringInclude
        private final NativeType type;
        private final boolean nullable;

        public StorageHashIndexColumnDescriptor(String name, NativeType type, boolean nullable) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public NativeType type() {
            return this.type;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public String toString() {
            return S.toString(this);
        }
    }
}

