/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite3.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite3.internal.schema.BinaryRowConverter;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.InternalTupleEx;
import org.apache.ignite3.internal.sql.engine.exec.VirtualColumn;
import org.apache.ignite3.internal.sql.engine.util.ProjectedTuple;

public class ExtendedProjectedTuple
extends ProjectedTuple {
    private Int2ObjectMap<VirtualColumn> extraColumns;

    public ExtendedProjectedTuple(InternalTupleEx delegate, int[] projection, Int2ObjectMap<VirtualColumn> extraColumns) {
        super(delegate, projection);
        this.extraColumns = extraColumns;
    }

    @Override
    protected void normalize() {
        int estimatedValueSize = 32;
        if (this.delegate instanceof BinaryTuple) {
            var stats = new BinaryTupleParser.Sink(){
                int estimatedValueSize = 0;

                @Override
                public void nextElement(int index, int begin, int end) {
                    this.estimatedValueSize += end - begin;
                }
            };
            for (int columnIndex : this.projection) {
                if (this.extraColumns.containsKey(columnIndex)) {
                    stats.estimatedValueSize += 8;
                    continue;
                }
                ((BinaryTuple)this.delegate).fetch(columnIndex, stats);
            }
            estimatedValueSize = stats.estimatedValueSize;
        }
        BinaryTupleBuilder builder = new BinaryTupleBuilder(this.projection.length, estimatedValueSize, false);
        int[] newProjection = new int[this.projection.length];
        assert (this.delegate instanceof InternalTupleEx);
        InternalTupleEx delegate0 = (InternalTupleEx)this.delegate;
        for (int i = 0; i < this.projection.length; ++i) {
            int col = this.projection[i];
            newProjection[i] = i;
            if (this.extraColumns.containsKey(col)) {
                VirtualColumn virtualColumn = (VirtualColumn)this.extraColumns.get(col);
                BinaryRowConverter.appendValue(builder, virtualColumn.schemaType(), virtualColumn.value());
                continue;
            }
            delegate0.copyValue(builder, col);
        }
        this.delegate = new BinaryTuple(this.projection.length, builder.build());
        this.projection = newProjection;
        this.extraColumns = Int2ObjectMaps.emptyMap();
    }

    private boolean isExtraColumn(int col) {
        return this.extraColumns.containsKey(this.projection[col]);
    }

    private VirtualColumn extraColumn(int col) {
        return (VirtualColumn)this.extraColumns.get(this.projection[col]);
    }

    @Override
    protected int normalizedSize() {
        this.normalizeIfNeeded();
        return this.delegate.size();
    }

    @Override
    public boolean hasNullValue(int col) {
        if (this.isExtraColumn(col)) {
            return this.extraColumn(col).value() == null;
        }
        return super.hasNullValue(col);
    }

    @Override
    public boolean booleanValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Boolean)this.extraColumn(col).value();
        }
        return super.booleanValue(col);
    }

    @Override
    public Boolean booleanValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Boolean)this.extraColumn(col).value();
        }
        return super.booleanValueBoxed(col);
    }

    @Override
    public byte byteValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Byte)this.extraColumn(col).value();
        }
        return super.byteValue(col);
    }

    @Override
    public Byte byteValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Byte)this.extraColumn(col).value();
        }
        return super.byteValueBoxed(col);
    }

    @Override
    public short shortValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Short)this.extraColumn(col).value();
        }
        return super.shortValue(col);
    }

    @Override
    public Short shortValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Short)this.extraColumn(col).value();
        }
        return super.shortValueBoxed(col);
    }

    @Override
    public int intValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Integer)this.extraColumn(col).value();
        }
        return super.intValue(col);
    }

    @Override
    public Integer intValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Integer)this.extraColumn(col).value();
        }
        return super.intValueBoxed(col);
    }

    @Override
    public long longValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Long)this.extraColumn(col).value();
        }
        return super.longValue(col);
    }

    @Override
    public Long longValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Long)this.extraColumn(col).value();
        }
        return super.longValueBoxed(col);
    }

    @Override
    public float floatValue(int col) {
        if (this.isExtraColumn(col)) {
            return ((Float)this.extraColumn(col).value()).floatValue();
        }
        return super.floatValue(col);
    }

    @Override
    public Float floatValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Float)this.extraColumn(col).value();
        }
        return super.floatValueBoxed(col);
    }

    @Override
    public double doubleValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Double)this.extraColumn(col).value();
        }
        return super.doubleValue(col);
    }

    @Override
    public Double doubleValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Double)this.extraColumn(col).value();
        }
        return super.doubleValueBoxed(col);
    }

    @Override
    public BigDecimal decimalValue(int col, int decimalScale) {
        if (this.isExtraColumn(col)) {
            return (BigDecimal)this.extraColumn(col).value();
        }
        return super.decimalValue(col, decimalScale);
    }

    @Override
    public String stringValue(int col) {
        if (this.isExtraColumn(col)) {
            return (String)this.extraColumn(col).value();
        }
        return super.stringValue(col);
    }

    @Override
    public byte[] bytesValue(int col) {
        if (this.isExtraColumn(col)) {
            return (byte[])this.extraColumn(col).value();
        }
        return super.bytesValue(col);
    }

    @Override
    public UUID uuidValue(int col) {
        if (this.isExtraColumn(col)) {
            return (UUID)this.extraColumn(col).value();
        }
        return super.uuidValue(col);
    }

    @Override
    public LocalDate dateValue(int col) {
        if (this.isExtraColumn(col)) {
            return (LocalDate)this.extraColumn(col).value();
        }
        return super.dateValue(col);
    }

    @Override
    public LocalTime timeValue(int col) {
        if (this.isExtraColumn(col)) {
            return (LocalTime)this.extraColumn(col).value();
        }
        return super.timeValue(col);
    }

    @Override
    public LocalDateTime dateTimeValue(int col) {
        if (this.isExtraColumn(col)) {
            return (LocalDateTime)this.extraColumn(col).value();
        }
        return super.dateTimeValue(col);
    }

    @Override
    public Instant timestampValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Instant)this.extraColumn(col).value();
        }
        return super.timestampValue(col);
    }
}

