/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures;

import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchemaTypes;
import org.apache.ignite3.internal.sql.engine.exec.row.TypeSpec;
import org.apache.ignite3.internal.type.NativeType;
import org.jetbrains.annotations.Nullable;

public interface KeyValueCodec<K, V> {
    public BinaryTuple encodeKey(K var1);

    public K decodeKey(BinaryTuple var1);

    @Nullable
    public ByteBuffer encodeValue(V var1, ByteBuffer var2);

    public V decodeValue(ByteBuffer var1);

    public int initialValueSizeInBytes();

    public static Supplier<BinaryTupleBuilder> createBinaryTupleBuilder(RowSchema rowSchema, IntList fields) {
        boolean exact = true;
        int estimatedSizeInBytes = 0;
        for (int i = 0; i < fields.size(); ++i) {
            TypeSpec typeSpec = rowSchema.fields().get(fields.getInt(i));
            NativeType nativeType = RowSchemaTypes.toNativeType(typeSpec);
            if (nativeType == null) continue;
            if (nativeType.fixedLength()) {
                estimatedSizeInBytes += nativeType.sizeInBytes();
                continue;
            }
            exact = false;
        }
        int finalSizeInBytes = estimatedSizeInBytes;
        boolean finalExactFlag = exact;
        return () -> new BinaryTupleBuilder(fields.size(), finalSizeInBytes, finalExactFlag);
    }
}

