/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory;

import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryTracker;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class MemoryTrackerImpl
implements MemoryTracker {
    @IgniteToStringExclude
    private final MemoryTracker parent;
    private final long quota;
    private final long blockSize;
    private final String quotaName;
    private final int errorCode;
    private final String errorMessage;
    private long reservedFromParent;
    private volatile long reserved;
    private volatile long maxReserved;
    private volatile boolean closed;

    public MemoryTrackerImpl(@Nullable MemoryTracker parent, long quota, String quotaName, int errorCode, String errorMessage, long blockSize) {
        if (quota < 0L) {
            throw new IllegalArgumentException("Quota must be non-negative but got " + quota);
        }
        if (blockSize < 0L) {
            throw new IllegalArgumentException("Block size must be non-negative but got " + blockSize);
        }
        this.quotaName = quotaName;
        this.parent = parent;
        this.quota = quota;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.blockSize = quota != 0L ? Math.min(quota, blockSize) : blockSize;
    }

    @Override
    public synchronized void acquire(long size) {
        boolean result = this.executeAcquire(size, false);
        assert (result) : "acquire was not unsuccessful but no error was thrown";
    }

    @Override
    public synchronized boolean tryAcquire(long size) {
        return this.executeAcquire(size, true);
    }

    private boolean executeAcquire(long size, boolean attempt) {
        boolean acquired;
        assert (size >= 0L);
        this.checkClosed();
        long newReserved = Math.addExact(this.reserved, size);
        if (this.quota > 0L && newReserved >= this.quota) {
            if (attempt) {
                return false;
            }
            this.onQuotaExceeded();
        }
        if (!(acquired = this.parent != null && newReserved > this.reservedFromParent ? this.reserveFromParent(newReserved, attempt) : true)) {
            return false;
        }
        this.reserved = newReserved;
        this.maxReserved = Math.max(this.reserved, this.maxReserved);
        return acquired;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Memory tracker is closed.");
        }
    }

    private boolean reserveFromParent(long newReserved, boolean attempt) {
        long blockSize = Math.max(newReserved - this.reservedFromParent, this.blockSize);
        if (this.quota > 0L) {
            blockSize = Math.min(blockSize, this.quota - this.reservedFromParent);
        }
        if (attempt) {
            boolean acquired = this.parent.tryAcquire(blockSize);
            if (acquired) {
                this.reservedFromParent += blockSize;
            }
            return acquired;
        }
        this.parent.acquire(blockSize);
        this.reservedFromParent += blockSize;
        return true;
    }

    private void onQuotaExceeded() {
        throw new SqlException(this.errorCode, this.errorMessage);
    }

    @Override
    public void release(long size) {
        this.releaseInternal(size, false);
    }

    @Override
    public void releaseNow(long size) {
        this.releaseInternal(size, true);
    }

    private synchronized void releaseInternal(long size, boolean enforceReleaseFromParent) {
        assert (size >= 0L) : "Memory release size should be non negative. Passed size is " + size;
        this.checkClosed();
        if (size == 0L) {
            return;
        }
        long reservedPrev = this.reserved;
        long newReserved = this.reserved - size;
        assert (newReserved >= 0L) : IgniteStringFormatter.format("Attempted to free more memory than was reserved. [{}, reserved: {}, toFree: {}]", this.quotaName, reservedPrev, size);
        if (this.parent != null && (enforceReleaseFromParent || this.reservedFromParent - newReserved > this.blockSize)) {
            this.releaseFromParent(enforceReleaseFromParent, newReserved);
        }
        this.reserved = newReserved;
    }

    private void releaseFromParent(boolean enforceReleaseFromParent, long reserved) {
        long toReleaseFromParent = this.reservedFromParent - reserved;
        if (enforceReleaseFromParent) {
            this.parent.releaseNow(toReleaseFromParent);
        } else {
            this.parent.release(toReleaseFromParent);
        }
        this.reservedFromParent -= toReleaseFromParent;
        assert (this.reservedFromParent >= 0L) : this.reservedFromParent;
    }

    @Override
    public long reserved() {
        return this.reserved;
    }

    @Override
    public long maxReserved() {
        return Math.max(this.reserved, this.maxReserved);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.reserved = 0L;
        if (this.parent != null) {
            this.parent.releaseNow(this.reservedFromParent);
        }
    }

    public String toString() {
        return S.toString(MemoryTrackerImpl.class, this);
    }
}

