/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.fsm;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.eventlog.api.EventLog;
import org.apache.ignite3.internal.eventlog.api.IgniteEventType;
import org.apache.ignite3.internal.eventlog.event.EventUser;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.Debuggable;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.schema.SchemaSyncService;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursorImpl;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.QueryCancelledException;
import org.apache.ignite3.internal.sql.engine.QueryEventsFactory;
import org.apache.ignite3.internal.sql.engine.SqlOperationContext;
import org.apache.ignite3.internal.sql.engine.SqlProperties;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionService;
import org.apache.ignite3.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite3.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite3.internal.sql.engine.exec.fsm.MultiStatementHandler;
import org.apache.ignite3.internal.sql.engine.exec.fsm.Programs;
import org.apache.ignite3.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryIdGenerator;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryInfo;
import org.apache.ignite3.internal.sql.engine.prepare.DdlPlan;
import org.apache.ignite3.internal.sql.engine.prepare.KeyValueGetPlan;
import org.apache.ignite3.internal.sql.engine.prepare.KeyValueModifyPlan;
import org.apache.ignite3.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite3.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite3.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite3.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite3.internal.sql.engine.sql.ParserService;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite3.internal.sql.metrics.SqlQueryMetricSource;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.CancelHandleHelper;
import org.apache.ignite3.lang.CancellationToken;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class QueryExecutor
implements LifecycleAware,
Debuggable {
    private final Cache<String, ParsedResult> queryToParsedResultCache;
    private final ParserService parserService;
    private final Executor executor;
    private final ScheduledExecutorService scheduler;
    private final ClockService clockService;
    private final SchemaSyncService schemaSyncService;
    private final PrepareService prepareService;
    private final CatalogService catalogService;
    private final ExecutionService executionService;
    private final TransactionalOperationTracker transactionalOperationTracker;
    private final QueryIdGenerator idGenerator;
    private final LicenseFeatureChecker licenseFeatureChecker;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ConcurrentMap<UUID, Query> runningQueries = new ConcurrentHashMap<UUID, Query>();
    private final EventLog eventLog;
    private final QueryEventsFactory eventsFactory;
    private final SqlQueryMetricSource queryMetricSource;

    public QueryExecutor(String nodeId, CacheFactory cacheFactory, int parsedResultsCacheSize, ParserService parserService, Executor executor, ScheduledExecutorService scheduler, ClockService clockService, SchemaSyncService schemaSyncService, PrepareService prepareService, CatalogService catalogService, ExecutionService executionService, TransactionalOperationTracker transactionalOperationTracker, QueryIdGenerator idGenerator, EventLog eventLog, SqlQueryMetricSource queryMetricSource, LicenseFeatureChecker licenseFeatureChecker) {
        this.queryToParsedResultCache = cacheFactory.create(parsedResultsCacheSize);
        this.parserService = parserService;
        this.executor = executor;
        this.scheduler = scheduler;
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.prepareService = prepareService;
        this.catalogService = catalogService;
        this.executionService = executionService;
        this.transactionalOperationTracker = transactionalOperationTracker;
        this.licenseFeatureChecker = licenseFeatureChecker;
        this.idGenerator = idGenerator;
        this.eventLog = eventLog;
        this.queryMetricSource = queryMetricSource;
        this.eventsFactory = new QueryEventsFactory(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<AsyncSqlCursor<InternalSqlRow>> executeQuery(SqlProperties properties, QueryTransactionContext txContext, String sql, @Nullable CancellationToken cancellationToken, SecurityContext securityContext, Object ... params) {
        Query query = new Query(securityContext, Instant.ofEpochMilli(this.clockService.now().getPhysical()), this, this.idGenerator.next(), sql, properties, txContext, params);
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            this.trackQuery(query, cancellationToken);
        }
        finally {
            this.busyLock.leaveBusy();
        }
        long queryTimeout = properties.queryTimeout();
        if (queryTimeout > 0L) {
            query.cancel.setTimeout(this.scheduler, queryTimeout);
        }
        return query.runProgram(Programs.QUERY_EXECUTION).whenComplete((cursor, ex) -> {
            if (cursor != null && query.parsedScript == null) {
                cursor.onClose().thenRun(query::terminate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<AsyncSqlCursor<InternalSqlRow>> executeChildQuery(Query parent, QueryTransactionContext scriptTxContext, int statementNum, ParsedResult parsedQuery, Object[] params, @Nullable CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCursorFuture) {
        Query query = new Query(Instant.ofEpochMilli(this.clockService.now().getPhysical()), parent, parsedQuery, statementNum, this.idGenerator.next(), scriptTxContext, params, nextCursorFuture);
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            this.trackQuery(query, null);
        }
        finally {
            this.busyLock.leaveBusy();
        }
        try {
            parent.cancel.attach(query.cancel);
        }
        catch (QueryCancelledException ex2) {
            query.terminate();
            return CompletableFuture.failedFuture(ex2);
        }
        return query.runProgram(Programs.SCRIPT_ITEM_EXECUTION).whenComplete((cursor, ex) -> {
            if (cursor != null) {
                cursor.onClose().thenRun(query::terminate);
            } else if (ex != null) {
                query.terminate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<AsyncSqlCursor<InternalSqlRow>> executeChildBatch(Query parent, QueryTransactionContext scriptTxContext, int batchOffset, List<ParsedResultWithNextCursorFuture> batch) {
        if (IgniteUtils.assertionsEnabled()) {
            int offsetInBatch = 0;
            for (ParsedResultWithNextCursorFuture item : batch) {
                assert (item.parsedQuery.queryType() == SqlQueryType.DDL) : item.parsedQuery.queryType() + " at statement #" + (batchOffset + offsetInBatch);
                ++offsetInBatch;
            }
        }
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        ArrayList<Query> queries = new ArrayList<Query>(batch.size());
        try {
            int offsetInBatch = 0;
            for (ParsedResultWithNextCursorFuture item : batch) {
                Query query2 = new Query(Instant.ofEpochMilli(this.clockService.now().getPhysical()), parent, item.parsedQuery, batchOffset + offsetInBatch, this.idGenerator.next(), scriptTxContext, ArrayUtils.OBJECT_EMPTY_ARRAY, item.nextCursorFuture);
                ++offsetInBatch;
                this.trackQuery(query2, null);
                queries.add(query2);
                parent.cancel.attach(query2.cancel);
            }
        }
        catch (QueryCancelledException ex) {
            queries.forEach(query -> query.terminateExceptionally(ex));
            Iterator iterator = CompletableFuture.failedFuture(ex);
            return iterator;
        }
        finally {
            this.busyLock.leaveBusy();
        }
        ArrayList<CompletableFuture<QueryPlan>> preparedQueryFutures = new ArrayList<CompletableFuture<QueryPlan>>(batch.size());
        for (Query query3 : queries) {
            preparedQueryFutures.add(query3.runProgram(Programs.SCRIPT_ITEM_PREPARATION));
        }
        return ((CompletableFuture)CompletableFutures.allOf(preparedQueryFutures).handle((none, ignored) -> {
            ArrayList<DdlPlan> ddlPlans = new ArrayList<DdlPlan>();
            for (Query query : queries) {
                QueryPlan plan = query.plan;
                if (plan == null) {
                    assert (query.error.get() != null);
                    break;
                }
                ddlPlans.add((DdlPlan)plan);
            }
            return ddlPlans;
        })).thenCompose(ddlPlans -> {
            parent.cancel.throwIfCancelled();
            if (ddlPlans.isEmpty()) {
                Iterator it = queries.iterator();
                Throwable th = ((Query)it.next()).error.get();
                assert (th != null);
                while (it.hasNext()) {
                    ((Query)it.next()).terminateExceptionally(th);
                }
                return CompletableFuture.failedFuture(th);
            }
            return ((CompletableFuture)this.executionService.executeDdlBatch((List<DdlPlan>)ddlPlans, parent.securityContext, scriptTxContext::updateObservableTime).handle((dataCursors, error) -> {
                if (error != null) {
                    return this.executeSequentially(queries);
                }
                AsyncSqlCursor<InternalSqlRow> firstCursor = null;
                CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorRef = null;
                Iterator dataCursorIterator = dataCursors.iterator();
                Throwable th = null;
                for (Query query : queries) {
                    if (th != null) {
                        query.terminateExceptionally(th);
                        continue;
                    }
                    QueryPlan plan = query.plan;
                    if (plan == null) {
                        th = query.error.get();
                        assert (th != null);
                        assert (cursorRef != null);
                        cursorRef.completeExceptionally(th);
                        continue;
                    }
                    query.moveTo(ExecutionPhase.EXECUTING);
                    AsyncDataCursor dataCursor = (AsyncDataCursor)dataCursorIterator.next();
                    AsyncSqlCursor<InternalSqlRow> currentCursor = this.createAndSaveSqlCursor(query, dataCursor);
                    if (cursorRef != null) {
                        cursorRef.complete(currentCursor);
                    }
                    cursorRef = query.nextCursorFuture;
                    if (firstCursor == null) {
                        firstCursor = currentCursor;
                    }
                    currentCursor.onClose().thenRun(query::terminate);
                }
                return CompletableFuture.completedFuture(firstCursor);
            })).thenCompose(Function.identity());
        });
    }

    private CompletableFuture<AsyncSqlCursor<InternalSqlRow>> executeSequentially(List<Query> queries) {
        assert (!queries.isEmpty());
        CompletionStage firstCursor = null;
        CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorRef = null;
        CompletionStage lastStep = CompletableFutures.nullCompletedFuture();
        for (Query query : queries) {
            query.reset();
            CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorRef0 = cursorRef;
            CompletionStage cursorFuture = ((CompletableFuture)lastStep.whenComplete((none, ex) -> {
                if (ex != null) {
                    query.terminateExceptionally((Throwable)ex);
                }
            })).thenCompose(none -> query.runProgram(Programs.SCRIPT_ITEM_EXECUTION).whenComplete((cursor, ex) -> {
                if (cursorRef0 != null) {
                    if (cursor != null) {
                        cursorRef0.complete((AsyncSqlCursor<InternalSqlRow>)cursor);
                    } else {
                        cursorRef0.completeExceptionally((Throwable)ex);
                    }
                }
                if (cursor != null) {
                    cursor.onClose().thenRun(query::terminate);
                } else if (ex != null) {
                    query.terminate();
                }
            }));
            lastStep = ((CompletableFuture)cursorFuture).thenCompose(AsyncDataCursor::onFirstPageReady);
            cursorRef = query.nextCursorFuture;
            if (firstCursor != null) continue;
            firstCursor = cursorFuture;
        }
        return firstCursor;
    }

    AsyncSqlCursor<InternalSqlRow> createAndSaveSqlCursor(Query query, AsyncDataCursor<InternalSqlRow> dataCursor) {
        QueryPlan plan = query.plan;
        assert (plan != null);
        AsyncSqlCursorImpl<InternalSqlRow> cursor = new AsyncSqlCursorImpl<InternalSqlRow>(plan.type(), plan.metadata(), plan.partitionAwarenessMetadata(), dataCursor, query.nextCursorFuture);
        query.cursor = cursor;
        query.cancel.add(timeout -> dataCursor.cancelAsync(timeout ? AsyncDataCursor.CancellationReason.TIMEOUT : AsyncDataCursor.CancellationReason.CANCEL));
        return cursor;
    }

    @Nullable
    public ParsedResult lookupParsedResultInCache(String sql) {
        return this.queryToParsedResultCache.get(sql);
    }

    public void updateParsedResultCache(String sql, ParsedResult result) {
        this.queryToParsedResultCache.put(sql, result);
    }

    public ParsedResult parse(String sql) {
        return this.parserService.parse(sql);
    }

    List<ParsedResult> parseScript(String sql) {
        return this.parserService.parseScript(sql);
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    HybridTimestamp deriveOperationTime(QueryTransactionContext txContext) {
        QueryTransactionWrapper txWrapper = txContext.explicitTx();
        if (txWrapper == null) {
            return this.clockService.now();
        }
        return txWrapper.unwrap().schemaTimestamp();
    }

    CompletableFuture<Void> waitForMetadata(HybridTimestamp timestamp) {
        return this.schemaSyncService.waitForMetadataCompleteness(timestamp);
    }

    CompletableFuture<QueryPlan> prepare(ParsedResult result, SqlOperationContext operationContext) {
        return this.prepareService.prepareAsync(result, operationContext);
    }

    HybridTimestamp deriveMinimalRequiredTime(QueryPlan plan) {
        Integer catalogVersion = null;
        if (plan instanceof MultiStepPlan) {
            catalogVersion = ((MultiStepPlan)plan).catalogVersion();
        } else if (plan instanceof KeyValueModifyPlan) {
            catalogVersion = ((KeyValueModifyPlan)plan).catalogVersion();
        } else if (plan instanceof KeyValueGetPlan) {
            catalogVersion = ((KeyValueGetPlan)plan).catalogVersion();
        }
        if (catalogVersion != null) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            assert (catalog != null);
            return HybridTimestamp.hybridTimestamp(catalog.time());
        }
        return this.clockService.now();
    }

    CompletableFuture<AsyncDataCursor<InternalSqlRow>> executePlan(SqlOperationContext ctx, QueryPlan plan) {
        return this.executionService.executePlan(plan, ctx);
    }

    MultiStatementHandler createScriptHandler(Query query) {
        List<ParsedResult> parsedResults = query.parsedScript;
        assert (parsedResults != null);
        return new MultiStatementHandler(this.transactionalOperationTracker, query, query.txContext, parsedResults, query.params);
    }

    private void trackQuery(Query query, @Nullable CancellationToken cancellationToken) {
        Query old = this.runningQueries.put(query.id, query);
        this.eventLog.log(IgniteEventType.QUERY_STARTED.name(), () -> {
            QueryInfo info = new QueryInfo(query);
            return this.eventsFactory.makeStartEvent(info, EventUser.of(info.username(), "basic"));
        });
        assert (old == null) : "Query with the same id already registered";
        CompletableFuture<Void> queryTerminationFut = query.terminationFuture;
        queryTerminationFut.whenComplete((none, ignoredEx) -> {
            this.runningQueries.remove(query.id);
            long finishTime = this.clockService.current().getPhysical();
            this.updateMetrics(query);
            this.eventLog.log(IgniteEventType.QUERY_FINISHED.name(), () -> {
                QueryInfo info = new QueryInfo(query);
                return this.eventsFactory.makeFinishEvent(info, EventUser.of(info.username(), "basic"), finishTime);
            });
        });
        if (cancellationToken != null) {
            CancelHandleHelper.addCancelAction(cancellationToken, query::cancel, queryTerminationFut);
        }
    }

    public List<QueryInfo> runningQueries() {
        return this.runningQueries.values().stream().map(QueryInfo::new).collect(Collectors.toList());
    }

    public CompletableFuture<Boolean> cancelQuery(UUID queryId) {
        Query query = (Query)this.runningQueries.get(queryId);
        if (query == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        return query.cancel().thenApply(none -> Boolean.TRUE);
    }

    LicenseFeatureChecker licenseChecker() {
        return this.licenseFeatureChecker;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() throws Exception {
        this.busyLock.block();
        NodeStoppingException ex = new NodeStoppingException();
        this.runningQueries.values().forEach(query -> query.terminateExceptionally(ex));
    }

    @Override
    @TestOnly
    public void dumpState(IgniteStringBuilder writer, String indent) {
        writer.app(indent).app("Running queries:").nl();
        String childIndent = Debuggable.childIndentation(indent);
        for (Query query : this.runningQueries.values()) {
            writer.app(childIndent).app("queryId=").app(query.id).app(", phase=").app((Object)query.currentPhase());
            if (query.parentId != null) {
                writer.app(", parentId=").app(query.parentId);
                writer.app(", statement=").app(query.statementNum);
            }
            writer.app(", createdAt=").app(query.createdAt).app(", cancelled=").app(query.cancel.isCancelled()).app(", failed=").app(query.error.get() != null).app(", sql=").app(query.sql).nl();
        }
        if (this.executionService instanceof Debuggable) {
            ((Debuggable)((Object)this.executionService)).dumpState(writer, indent);
        }
    }

    private void updateMetrics(Query query) {
        boolean individualStatement;
        boolean bl = individualStatement = query.parsedScript == null;
        if (!individualStatement) {
            return;
        }
        Throwable err = query.error.get();
        if (query.parsedResult == null || query.plan == null) {
            this.updateFailureMetrics(err);
        } else if (err == null) {
            this.queryMetricSource.success();
        } else {
            this.updateFailureMetrics(err);
        }
    }

    private void updateFailureMetrics(Throwable t) {
        SqlException e;
        this.queryMetricSource.failure();
        if (t instanceof QueryCancelledException) {
            if (t.getMessage().contains("Query timeout")) {
                this.queryMetricSource.timedOut();
            } else {
                this.queryMetricSource.cancel();
            }
        } else if (t instanceof SqlException && ((e = (SqlException)t).code() == GridgainErrorGroups.MemoryQuota.STATEMENT_MEMORY_QUOTA_EXCEEDED_ERR || e.code() == GridgainErrorGroups.MemoryQuota.SQL_OUT_OF_MEMORY_ERR)) {
            this.queryMetricSource.memoryQuotaExceeded();
        }
    }

    static class ParsedResultWithNextCursorFuture {
        private final ParsedResult parsedQuery;
        @Nullable
        private final CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCursorFuture;

        ParsedResultWithNextCursorFuture(ParsedResult parsedQuery, @Nullable CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCursorFuture) {
            this.parsedQuery = parsedQuery;
            this.nextCursorFuture = nextCursorFuture;
        }
    }
}

