/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.snapshot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

@Schema(description="Snapshot restoration configuration.")
public class RestoreCommand {
    @Schema(description="ID of the snapshot to restore")
    private final UUID snapshotId;
    @Schema(description="Set of fully-qualified table names to restore. If both this and structureNames are empty, restores all tables from the snapshot.")
    private final Set<String> tableNames;
    @Schema(description="Set of fully-qualified structure names to restore. If both this and tableNames are empty, restores all structures from the snapshot.")
    private final Set<String> structureNames;
    @Schema(description="The name of the snapshot path to restore the snapshot from; null to use the default path.")
    private final String source;
    @Schema(description="The decription provider name.")
    private final String decryptionProvider;
    @Schema(description="If set to false, operation will fail if there are existing structures that would be overwritten by the restore.")
    private final boolean force;

    @JsonCreator
    public RestoreCommand(@JsonProperty(value="snapshotId") UUID snapshotId, @JsonProperty(value="tableNames") @Nullable Collection<String> tableNames, @JsonProperty(value="structureNames") @Nullable Collection<String> structureNames, @JsonProperty(value="source") @Nullable String source, @JsonProperty(value="decryptionProvider") @Nullable String decryptionProvider, @JsonProperty(value="force") boolean force) {
        Set<Object> set = this.tableNames = tableNames == null ? Collections.emptySet() : Set.copyOf(tableNames);
        if (RestoreCommand.containsBlanks(this.tableNames)) {
            throw new IllegalArgumentException("Table names must not contain blank strings: " + tableNames);
        }
        Set<Object> set2 = this.structureNames = structureNames == null ? Collections.emptySet() : Set.copyOf(structureNames);
        if (RestoreCommand.containsBlanks(this.structureNames)) {
            throw new IllegalArgumentException("Structure names must not contain blank strings: " + structureNames);
        }
        this.snapshotId = snapshotId;
        this.source = source;
        this.decryptionProvider = decryptionProvider;
        this.force = force;
    }

    private static boolean containsBlanks(Set<String> structureNames) {
        return structureNames.stream().anyMatch(StringUtils::nullOrBlank);
    }

    @JsonGetter(value="snapshotId")
    public UUID snapshotId() {
        return this.snapshotId;
    }

    @JsonGetter(value="tableNames")
    public Set<String> tableNames() {
        return this.tableNames;
    }

    @JsonGetter(value="structureNames")
    public Set<String> structureNames() {
        return this.structureNames;
    }

    @JsonGetter(value="source")
    @Nullable
    public String source() {
        return this.source;
    }

    @JsonGetter(value="decryptionProvider")
    @Nullable
    public String decryptionProvider() {
        return this.decryptionProvider;
    }

    @JsonGetter(value="force")
    public boolean force() {
        return this.force;
    }

    public String toString() {
        return S.toString(this);
    }
}

