/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver.message;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.placementdriver.message.LeaseGrantedMessageResponse;
import org.apache.ignite3.internal.placementdriver.message.LeaseGrantedMessageResponseImpl;
import org.apache.ignite3.internal.placementdriver.message.PlacementDriverMessagesTypeInfos;

class LeaseGrantedMessageResponseSerializer
implements MessageSerializer<LeaseGrantedMessageResponse> {
    public static final LeaseGrantedMessageResponseSerializer INSTANCE = new LeaseGrantedMessageResponseSerializer();

    private LeaseGrantedMessageResponseSerializer() {
    }

    @Override
    public boolean writeMessage(LeaseGrantedMessageResponse msg, MessageWriter writer) throws MessageMappingException {
        LeaseGrantedMessageResponseImpl message = (LeaseGrantedMessageResponseImpl)msg;
        writer.setMessageTypeInfo(PlacementDriverMessagesTypeInfos.leaseGrantedMessageResponse());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("accepted", message.accepted());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("redirectProposal", message.redirectProposal());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

