/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.metastorage.command.GetRangeCommand;
import org.apache.ignite3.internal.metastorage.command.GetRangeCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class GetRangeCommandDeserializer
implements MessageDeserializer<GetRangeCommand> {
    private final GetRangeCommandBuilder msg;

    GetRangeCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.getRangeCommand();
    }

    @Override
    public Class<GetRangeCommand> klass() {
        return GetRangeCommand.class;
    }

    @Override
    public GetRangeCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.getRangeCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int n = reader.readInt("batchSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.batchSize(n);
                reader.incrementState();
            }
            case 1: {
                boolean bl = reader.readBoolean("includeTombstones");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.includeTombstones(bl);
                reader.incrementState();
            }
            case 2: {
                ByteBuffer byteBuffer = reader.readByteBuffer("keyFrom");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (byteBuffer != null) {
                    this.msg.keyFrom(byteBuffer);
                }
                reader.incrementState();
            }
            case 3: {
                ByteBuffer byteBuffer = reader.readByteBuffer("keyTo");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (byteBuffer != null) {
                    this.msg.keyTo(byteBuffer);
                }
                reader.incrementState();
            }
            case 4: {
                byte[] byArray = reader.readByteArray("previousKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (byArray != null) {
                    this.msg.previousKey(byArray);
                }
                reader.incrementState();
            }
            case 5: {
                long l = reader.readLong("revUpperBound");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.revUpperBound(l);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GetRangeCommand.class);
    }
}

