/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor.wasm;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.ignite3.internal.compute.configuration.WasmModuleCacheConfiguration;
import org.apache.ignite3.internal.compute.configuration.WasmModuleCacheView;
import org.apache.ignite3.internal.compute.executor.wasm.WasmModuleCacheKey;
import org.jetbrains.annotations.Nullable;

class WasmModuleCache<V> {
    @Nullable
    private volatile Cache<WasmModuleCacheKey, Entry<V>> wasmModuleCache;

    WasmModuleCache(WasmModuleCacheConfiguration configuration) {
        configuration.listen(ctx -> {
            this.initCache((WasmModuleCacheView)ctx.newValue());
            return CompletableFuture.completedFuture(null);
        });
        this.initCache((WasmModuleCacheView)configuration.value());
    }

    Entry<V> getOrCreate(WasmModuleCacheKey key, Function<WasmModuleCacheKey, ? extends V> mappingFunction) {
        Cache<WasmModuleCacheKey, Entry<V>> cache = this.wasmModuleCache;
        if (cache == null) {
            return new Entry<V>(mappingFunction.apply(key), true);
        }
        while (true) {
            Entry entry = (Entry)cache.get((Object)key, k -> new Entry(mappingFunction.apply((WasmModuleCacheKey)k), false));
            assert (entry != null);
            if (entry.acquire()) {
                if (entry.removed) {
                    cache.invalidate((Object)key);
                    continue;
                }
                return entry;
            }
            key = key.nextIndex();
        }
    }

    private void initCache(@Nullable WasmModuleCacheView cfg) {
        if (cfg == null || !cfg.enabled()) {
            this.wasmModuleCache = null;
            return;
        }
        this.wasmModuleCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofSeconds(cfg.expireAfterAccessSeconds())).expireAfterWrite(Duration.ofSeconds(cfg.expireAfterWriteSeconds())).maximumSize((long)cfg.maxSize()).build();
    }

    static class Entry<V>
    implements AutoCloseable {
        @Nullable
        private final AtomicBoolean lock;
        private final V value;
        private volatile boolean removed;

        private Entry(V value, boolean noLock) {
            this.value = value;
            this.lock = noLock ? null : new AtomicBoolean();
        }

        private boolean acquire() {
            assert (this.lock != null) : "Lock is not initialized for this entry";
            return this.lock.compareAndSet(false, true);
        }

        public V value() {
            return this.value;
        }

        @Override
        public void close() throws Exception {
            if (this.lock == null) {
                return;
            }
            boolean res = this.lock.compareAndSet(true, false);
            assert (res) : "Entry was not locked";
        }

        public void remove() {
            this.removed = true;
        }
    }
}

