/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor.wasm;

import java.io.File;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.compute.ComputeException;
import org.apache.ignite3.compute.JobExecutionContext;
import org.apache.ignite3.compute.wasm.WasmType;
import org.apache.ignite3.deployment.DeploymentUnitInfo;
import org.apache.ignite3.internal.compute.executor.wasm.WasmCallConv;
import org.apache.ignite3.internal.compute.executor.wasm.WasmFunctionDef;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

class WasmCommon {
    private static final String INVALID_WASM_JOB_NAME = "Invalid Wasm job name, use 'file:function:ret_type:call_conv' notation: ";

    WasmCommon() {
    }

    static WasmFunctionDef getFileAndFunction(JobExecutionContext context, String jobClassName) {
        IgniteBiTuple<File, DeploymentUnitInfo> wasmFile;
        String[] parts = jobClassName.split(":");
        if (parts.length < 3) {
            throw WasmCommon.wasmError(INVALID_WASM_JOB_NAME + jobClassName);
        }
        String wasmFilePath = parts[0];
        String functionName = parts[1];
        WasmType retType = WasmCommon.parseEnum(WasmType.class, parts[2]);
        WasmCallConv callConv = WasmCallConv.GENERIC;
        if (parts.length > 3) {
            callConv = WasmCommon.parseEnum(WasmCallConv.class, parts[3].toUpperCase());
        }
        if ((wasmFile = WasmCommon.findFirstFile(context, wasmFilePath)) == null) {
            throw WasmCommon.wasmError("Wasm file not found in deployment units: " + wasmFilePath);
        }
        return new WasmFunctionDef(wasmFile.get1(), functionName, retType, callConv, wasmFile.get2());
    }

    static ComputeException wasmError(String msg) {
        return WasmCommon.wasmError(msg, null);
    }

    static ComputeException wasmError(String msg, @Nullable Throwable cause) {
        return new ComputeException(ErrorGroups.Compute.COMPUTE_PLATFORM_EXECUTOR_ERR, msg, cause);
    }

    @Nullable
    private static IgniteBiTuple<File, DeploymentUnitInfo> findFirstFile(JobExecutionContext context, String wasmFilePath) {
        if (wasmFilePath.contains("/") || wasmFilePath.contains("\\")) {
            throw WasmCommon.wasmError("Invalid characters in Wasm module name: " + wasmFilePath);
        }
        for (DeploymentUnitInfo deploymentUnit : context.deploymentUnits()) {
            Path resolved = deploymentUnit.path().resolve(wasmFilePath);
            File candidateFile = resolved.toFile();
            if (!candidateFile.exists()) continue;
            return new IgniteBiTuple<File, DeploymentUnitInfo>(candidateFile, deploymentUnit);
        }
        return null;
    }

    private static <T extends Enum<T>> T parseEnum(Class<T> cls, String val) {
        try {
            return Enum.valueOf(cls, val.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            String allowedVals = Stream.of((Enum[])cls.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "));
            throw WasmCommon.wasmError("Invalid " + cls.getSimpleName() + " value: '" + val + "'. Allowed values: " + allowedVals, ex);
        }
    }
}

