/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.compute.BroadcastExecution;
import org.apache.ignite3.compute.BroadcastJobTarget;
import org.apache.ignite3.compute.JobDescriptor;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.compute.JobExecutionOptions;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.compute.JobTarget;
import org.apache.ignite3.compute.TaskDescriptor;
import org.apache.ignite3.compute.task.TaskExecution;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.ExecutionContext;
import org.apache.ignite3.internal.compute.IgniteComputeInternal;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite3.internal.compute.task.FailedTaskExecution;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.lang.CancellationToken;
import org.apache.ignite3.table.Tuple;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

public class LicensedIgniteCompute
implements IgniteComputeInternal,
Wrapper {
    private final IgniteComputeInternal compute;
    private final LicenseFeatureChecker licenseChecker;

    public LicensedIgniteCompute(IgniteComputeInternal compute, LicenseFeatureChecker licenseChecker) {
        this.compute = compute;
        this.licenseChecker = licenseChecker;
    }

    @Override
    public <T, R> CompletableFuture<JobExecution<R>> submitAsync(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.submitAsync(target, descriptor, arg, cancellationToken));
    }

    @Override
    public <T, R> CompletableFuture<BroadcastExecution<R>> submitAsync(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.submitAsync(target, descriptor, arg, cancellationToken));
    }

    @Override
    public <T, R> R execute(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        return this.compute.execute(target, descriptor, arg, cancellationToken);
    }

    @Override
    public <T, R> Collection<R> execute(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        return this.compute.execute(target, descriptor, arg, cancellationToken);
    }

    @Override
    public <T, R> TaskExecution<R> submitMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        try {
            this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        }
        catch (Exception e) {
            return new FailedTaskExecution(e);
        }
        return this.compute.submitMapReduce(taskDescriptor, arg, cancellationToken);
    }

    @Override
    public <T, R> R executeMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        return this.compute.executeMapReduce(taskDescriptor, arg, cancellationToken);
    }

    @Override
    public CompletableFuture<JobExecution<ComputeJobDataHolder>> executeAsyncWithFailover(Set<InternalClusterNode> nodes, ExecutionContext executionContext, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.executeAsyncWithFailover(nodes, executionContext, cancellationToken));
    }

    @Override
    public CompletableFuture<JobExecution<ComputeJobDataHolder>> submitColocatedInternal(TableViewInternal table, Tuple key, ExecutionContext executionContext, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.submitColocatedInternal(table, key, executionContext, cancellationToken));
    }

    @Override
    public CompletableFuture<JobExecution<ComputeJobDataHolder>> submitPartitionedInternal(TableViewInternal table, int partitionId, List<DeploymentUnit> units, String jobClassName, JobExecutionOptions options, ComputeEventMetadataBuilder metadataBuilder, SecurityContext securityContext, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.submitPartitionedInternal(table, partitionId, units, jobClassName, options, metadataBuilder, securityContext, arg, cancellationToken));
    }

    @Override
    public <T, R> TaskExecution<R> submitMapReduceInternal(TaskDescriptor<T, R> taskDescriptor, ComputeEventMetadataBuilder metadataBuilder, SecurityContext securityContext, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        try {
            this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        }
        catch (Exception e) {
            return new FailedTaskExecution(e);
        }
        return this.compute.submitMapReduceInternal(taskDescriptor, metadataBuilder, securityContext, arg, cancellationToken);
    }

    @Override
    public CompletableFuture<Collection<JobState>> statesAsync() {
        return this.checkLicense(() -> this.compute.statesAsync());
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync(UUID jobId) {
        return this.checkLicense(() -> this.compute.stateAsync(jobId));
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync(UUID jobId) {
        return this.checkLicense(() -> this.compute.cancelAsync(jobId));
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(UUID jobId, int newPriority) {
        return this.checkLicense(() -> this.compute.changePriorityAsync(jobId, newPriority));
    }

    private <T> CompletableFuture<T> checkLicense(Supplier<CompletableFuture<T>> futureSupplier) {
        try {
            this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
            return futureSupplier.get();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.compute, classToUnwrap);
    }
}

