/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.raft.commands;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinReadyCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinReadyCommandBuilder;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinReadyCommandSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class JoinReadyCommandImpl
implements JoinReadyCommand,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 44;
    @IgniteToStringInclude
    private final ClusterNodeMessage node;

    private JoinReadyCommandImpl(ClusterNodeMessage node) {
        this.node = node;
    }

    @Override
    public ClusterNodeMessage node() {
        return this.node;
    }

    public MessageSerializer serializer() {
        return JoinReadyCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(JoinReadyCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 44;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JoinReadyCommandImpl otherMessage = (JoinReadyCommandImpl)other;
        return Objects.equals(this.node, otherMessage.node);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.node);
        return result;
    }

    @Override
    public JoinReadyCommandImpl clone() {
        try {
            return (JoinReadyCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JoinReadyCommandBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.node != null) {
            this.node.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.node != null) {
            this.node.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements JoinReadyCommandBuilder {
        private ClusterNodeMessage node;

        private Builder() {
        }

        @Override
        public JoinReadyCommandBuilder node(ClusterNodeMessage node) {
            Objects.requireNonNull(node, "node is not marked @Nullable");
            this.node = node;
            return this;
        }

        @Override
        public ClusterNodeMessage node() {
            return this.node;
        }

        @Override
        public JoinReadyCommand build() {
            return new JoinReadyCommandImpl(Objects.requireNonNull(this.node, "node is not marked @Nullable"));
        }

        @Override
        public JoinReadyCommand buildDeserialized() {
            return new JoinReadyCommandImpl(this.node);
        }
    }
}

