/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client;

import org.apache.ignite3.client.ClientOperationType;
import org.apache.ignite3.client.IgniteClientConfiguration;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.lang.LoggerFactory;
import org.jetbrains.annotations.Nullable;

public class ClientUtils {
    @Nullable
    public static ClientOperationType opCodeToClientOperationType(int opCode) {
        if (opCode < 0) {
            return null;
        }
        switch (opCode) {
            case 1: {
                return null;
            }
            case 3: 
            case 71: {
                return ClientOperationType.TABLES_GET;
            }
            case 4: 
            case 72: {
                return ClientOperationType.TABLE_GET;
            }
            case 1002: 
            case 1005: {
                return ClientOperationType.CACHES_GET;
            }
            case 1003: 
            case 1006: {
                return ClientOperationType.CACHE_GET;
            }
            case 1007: {
                return ClientOperationType.MAP_GET_OR_CREATE;
            }
            case 5: {
                return null;
            }
            case 10: {
                return ClientOperationType.TUPLE_UPSERT;
            }
            case 12: {
                return ClientOperationType.TUPLE_GET;
            }
            case 13: {
                return ClientOperationType.TUPLE_UPSERT_ALL;
            }
            case 15: {
                return ClientOperationType.TUPLE_GET_ALL;
            }
            case 16: {
                return ClientOperationType.TUPLE_GET_AND_UPSERT;
            }
            case 18: {
                return ClientOperationType.TUPLE_INSERT;
            }
            case 20: {
                return ClientOperationType.TUPLE_INSERT_ALL;
            }
            case 22: {
                return ClientOperationType.TUPLE_REPLACE;
            }
            case 24: {
                return ClientOperationType.TUPLE_REPLACE_EXACT;
            }
            case 26: {
                return ClientOperationType.TUPLE_GET_AND_REPLACE;
            }
            case 28: {
                return ClientOperationType.TUPLE_DELETE;
            }
            case 29: {
                return ClientOperationType.TUPLE_DELETE_ALL;
            }
            case 30: {
                return ClientOperationType.TUPLE_DELETE_EXACT;
            }
            case 31: {
                return ClientOperationType.TUPLE_DELETE_ALL_EXACT;
            }
            case 32: {
                return ClientOperationType.TUPLE_GET_AND_DELETE;
            }
            case 33: {
                return ClientOperationType.TUPLE_CONTAINS_KEY;
            }
            case 67: {
                return ClientOperationType.TUPLE_CONTAINS_ALL_KEYS;
            }
            case 54: {
                return null;
            }
            case 34: {
                return null;
            }
            case 68: {
                return null;
            }
            case 35: {
                return null;
            }
            case 58: {
                return null;
            }
            case 36: {
                return null;
            }
            case 37: {
                return null;
            }
            case 38: {
                return null;
            }
            case 39: {
                return null;
            }
            case 40: {
                return null;
            }
            case 41: {
                return null;
            }
            case 43: 
            case 44: 
            case 45: {
                return null;
            }
            case 46: {
                return null;
            }
            case 47: 
            case 49: 
            case 69: {
                return ClientOperationType.COMPUTE_EXECUTE;
            }
            case 64: {
                return ClientOperationType.COMPUTE_EXECUTE_MAPREDUCE;
            }
            case 59: {
                return ClientOperationType.COMPUTE_GET_STATE;
            }
            case 60: {
                return ClientOperationType.COMPUTE_CANCEL;
            }
            case 61: {
                return ClientOperationType.COMPUTE_CHANGE_PRIORITY;
            }
            case 48: {
                return null;
            }
            case 50: {
                return ClientOperationType.SQL_EXECUTE;
            }
            case 56: {
                return ClientOperationType.SQL_EXECUTE_SCRIPT;
            }
            case 51: {
                return ClientOperationType.SQL_CURSOR_NEXT_PAGE;
            }
            case 52: {
                return null;
            }
            case 53: {
                return null;
            }
            case 55: {
                return null;
            }
            case 57: {
                return null;
            }
            case 62: {
                return ClientOperationType.STREAMER_BATCH_SEND;
            }
            case 66: {
                return ClientOperationType.STREAMER_WITH_RECEIVER_BATCH_SEND;
            }
            case 63: {
                return ClientOperationType.SQL_EXECUTE_BATCH;
            }
            case 65: {
                return ClientOperationType.PRIMARY_REPLICAS_GET;
            }
            case 70: {
                return null;
            }
            case 1001: {
                return ClientOperationType.CONTINUOUS_QUERY_SCAN_PARTITION;
            }
            case 1004: {
                return null;
            }
            case 73: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Invalid op code: " + opCode);
    }

    public static <T> IgniteLogger logger(IgniteClientConfiguration cfg, Class<T> cls) {
        LoggerFactory loggerFactory = cfg.loggerFactory() == null ? System::getLogger : cfg.loggerFactory();
        return loggerFactory == null ? Loggers.voidLogger() : Loggers.forClass(cls, loggerFactory);
    }
}

