/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.util.Arrays;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public class DropSequenceEntry
implements UpdateEntry,
Fireable {
    private final int sequenceId;

    public DropSequenceEntry(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    int sequenceId() {
        return this.sequenceId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_SEQUENCE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.SEQUENCE_DROP;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new DropTableEventParameters(causalityToken, catalogVersion, this.sequenceId);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogSequenceDescriptor sequence = CatalogUtils.sequenceOrThrow(catalog, this.sequenceId);
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, sequence.schemaId());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), schema.indexes(), schema.systemViews(), (CatalogSequenceDescriptor[])Arrays.stream(schema.sequences()).filter(t -> t.id() != this.sequenceId).toArray(CatalogSequenceDescriptor[]::new), schema.policies(), schema.maps(), timestamp), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }
}

