/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractZoneCommand;
import org.apache.ignite3.internal.catalog.commands.AlterZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite3.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogStorageProfilesDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.storage.AlterZoneEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.jetbrains.annotations.Nullable;

public class AlterZoneCommand
extends AbstractZoneCommand {
    private static final IgniteLogger LOG = Loggers.forClass(AlterZoneCommand.class);
    private final boolean ifExists;
    @Nullable
    private final Integer partitions;
    @Nullable
    private final Integer replicas;
    @Nullable
    private final Integer quorumSize;
    @Nullable
    private final Integer dataNodesAutoAdjustScaleUp;
    @Nullable
    private final Integer dataNodesAutoAdjustScaleDown;
    @Nullable
    private final String filter;
    @Nullable
    private final List<StorageProfileParams> storageProfileParams;

    public static AlterZoneCommandBuilder builder() {
        return new Builder();
    }

    private AlterZoneCommand(String zoneName, boolean ifExists, @Nullable Integer partitions, @Nullable Integer replicas, @Nullable Integer quorumSize, @Nullable Integer dataNodesAutoAdjustScaleUp, @Nullable Integer dataNodesAutoAdjustScaleDown, @Nullable String filter, @Nullable List<StorageProfileParams> storageProfileParams) throws CatalogValidationException {
        super(zoneName);
        this.ifExists = ifExists;
        this.partitions = partitions;
        this.replicas = replicas;
        this.quorumSize = quorumSize;
        this.dataNodesAutoAdjustScaleUp = dataNodesAutoAdjustScaleUp;
        this.dataNodesAutoAdjustScaleDown = dataNodesAutoAdjustScaleDown;
        this.filter = filter;
        this.storageProfileParams = storageProfileParams;
        this.validate();
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogZoneDescriptor zone = CatalogUtils.zone(catalog, this.zoneName, !this.ifExists);
        if (zone == null) {
            return List.of();
        }
        this.ensureZoneParametersNotChangedForSecondaryZone(catalog, zone);
        CatalogZoneDescriptor descriptor = this.fromParamsAndPreviousValue(zone);
        return List.of(new AlterZoneEntry(descriptor));
    }

    private void ensureZoneParametersNotChangedForSecondaryZone(Catalog catalog, CatalogZoneDescriptor zone) {
        boolean hasTablesWithSecondaryStorage = catalog.tables().stream().anyMatch(table -> {
            Integer secondaryZoneId = table.secondaryZoneId();
            return secondaryZoneId != null && secondaryZoneId.intValue() == zone.id();
        });
        if (hasTablesWithSecondaryStorage) {
            Set alterZoneProfiles;
            Set actualZoneProfiles;
            if (this.dataNodesAutoAdjustScaleUp != null && !Objects.equals(this.dataNodesAutoAdjustScaleUp, zone.dataNodesAutoAdjustScaleUp())) {
                throw new CatalogValidationException("Auto adjust parameters couldn't be changed for zone utilized as a secondary zone.");
            }
            if (this.dataNodesAutoAdjustScaleDown != null && !Objects.equals(this.dataNodesAutoAdjustScaleDown, zone.dataNodesAutoAdjustScaleDown())) {
                throw new CatalogValidationException("Auto adjust parameters couldn't be changed for zone utilized as a secondary zone.");
            }
            if (this.replicas != null && !Objects.equals(this.replicas, zone.replicas())) {
                throw new CatalogValidationException("Replicas number couldn't be changed for zone utilized as a secondary zone.");
            }
            if (this.filter != null && !Objects.equals(this.filter, zone.filter())) {
                throw new CatalogValidationException("Filter parameter couldn't be changed for zone utilized as a secondary zone.");
            }
            if (this.partitions != null && !Objects.equals(this.partitions, zone.partitions())) {
                throw new CatalogValidationException("Partitions parameter couldn't be changed for zone utilized as a secondary zone.");
            }
            if (this.storageProfileParams != null && !(actualZoneProfiles = zone.storageProfiles().profiles().stream().map(CatalogStorageProfileDescriptor::storageProfile).collect(Collectors.toSet())).equals(alterZoneProfiles = this.storageProfileParams.stream().map(StorageProfileParams::storageProfile).collect(Collectors.toSet()))) {
                throw new CatalogValidationException("Storage profiles couldn't be changed for zone utilized as a secondary zone.");
            }
        }
    }

    private CatalogZoneDescriptor fromParamsAndPreviousValue(CatalogZoneDescriptor previous) {
        @Nullable Integer scaleUp = null;
        @Nullable Integer scaleDown = null;
        if (this.dataNodesAutoAdjustScaleUp != null || this.dataNodesAutoAdjustScaleDown != null) {
            scaleUp = this.dataNodesAutoAdjustScaleUp;
            scaleDown = this.dataNodesAutoAdjustScaleDown;
        }
        CatalogStorageProfilesDescriptor storageProfiles = this.storageProfileParams != null ? CatalogUtils.fromParams(this.storageProfileParams) : previous.storageProfiles();
        int replicas = Objects.requireNonNullElse(this.replicas, previous.replicas());
        int quorumSize = this.adjustQuorumSize(replicas, previous.quorumSize());
        return new CatalogZoneDescriptor(previous.id(), previous.name(), Objects.requireNonNullElse(this.partitions, previous.partitions()), replicas, quorumSize, Objects.requireNonNullElse(scaleUp, previous.dataNodesAutoAdjustScaleUp()), Objects.requireNonNullElse(scaleDown, previous.dataNodesAutoAdjustScaleDown()), Objects.requireNonNullElse(this.filter, previous.filter()), storageProfiles, previous.consistencyMode());
    }

    private int adjustQuorumSize(int replicas, int previousQuorumSize) {
        int minQuorum;
        int maxQuorum;
        int quorumSize = Objects.requireNonNullElse(this.quorumSize, previousQuorumSize);
        if (quorumSize > (maxQuorum = Math.max(minQuorum = Math.min(replicas, 2), (int)Math.round((double)replicas / 2.0)))) {
            if (this.quorumSize != null) {
                throw new CatalogValidationException("Quorum size exceeds the maximum quorum value: [quorum size={}, min={}, max={}, replicas count={}].", quorumSize, minQuorum, maxQuorum, replicas);
            }
            LOG.info("Quorum size adjusted from {} to {} because is exceeds the maximum quorum value.", quorumSize, maxQuorum);
            return maxQuorum;
        }
        if (quorumSize < minQuorum) {
            if (this.quorumSize != null) {
                throw new CatalogValidationException("Quorum size is less than the minimum quorum value: [quorum size={}, min={}, max={}, replicas count={}].", quorumSize, minQuorum, maxQuorum, replicas);
            }
            LOG.info("Quorum size adjusted from {} to {} because it is less than the minimum quorum value.", quorumSize, minQuorum);
            return minQuorum;
        }
        return quorumSize;
    }

    private void validate() {
        CatalogParamsValidationUtils.validatePartition(this.partitions);
        CatalogParamsValidationUtils.validateField(this.replicas, 1, null, "Invalid number of replicas");
        CatalogParamsValidationUtils.validateField(this.quorumSize, 1, null, "Invalid quorum size");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjustScaleUp, 0, null, "Invalid data nodes auto adjust scale up");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjustScaleDown, 0, null, "Invalid data nodes auto adjust scale down");
        CatalogParamsValidationUtils.validateZoneFilter(this.filter);
    }

    private static class Builder
    implements AlterZoneCommandBuilder {
        private String zoneName;
        private boolean ifExists;
        @Nullable
        private Integer partitions;
        @Nullable
        private Integer replicas;
        @Nullable
        private Integer quorumSize;
        @Nullable
        private Integer dataNodesAutoAdjustScaleUp;
        @Nullable
        private Integer dataNodesAutoAdjustScaleDown;
        @Nullable
        private String filter;
        @Nullable
        private List<StorageProfileParams> storageProfileParams;

        private Builder() {
        }

        @Override
        public AlterZoneCommandBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder partitions(Integer partitions) {
            this.partitions = partitions;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder quorumSize(Integer quorumSize) {
            this.quorumSize = quorumSize;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder dataNodesAutoAdjustScaleUp(Integer adjust) {
            this.dataNodesAutoAdjustScaleUp = adjust;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder dataNodesAutoAdjustScaleDown(Integer adjust) {
            this.dataNodesAutoAdjustScaleDown = adjust;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public AlterZoneCommandBuilder storageProfilesParams(@Nullable List<StorageProfileParams> params) {
            this.storageProfileParams = params;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterZoneCommand(this.zoneName, this.ifExists, this.partitions, this.replicas, this.quorumSize, this.dataNodesAutoAdjustScaleUp, this.dataNodesAutoAdjustScaleDown, this.filter, this.storageProfileParams);
        }
    }
}

