/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.type.DecimalNativeType;
import org.apache.ignite3.sql.ColumnType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetGroupSchemaUtils {
    private static final Map<ColumnType, PrimitiveType.PrimitiveTypeName> primitiveTypeMap = new HashMap<ColumnType, PrimitiveType.PrimitiveTypeName>(){
        {
            this.put(ColumnType.INT8, PrimitiveType.PrimitiveTypeName.INT32);
            this.put(ColumnType.INT16, PrimitiveType.PrimitiveTypeName.INT32);
            this.put(ColumnType.INT32, PrimitiveType.PrimitiveTypeName.INT32);
            this.put(ColumnType.INT64, PrimitiveType.PrimitiveTypeName.INT64);
            this.put(ColumnType.FLOAT, PrimitiveType.PrimitiveTypeName.FLOAT);
            this.put(ColumnType.DOUBLE, PrimitiveType.PrimitiveTypeName.DOUBLE);
            this.put(ColumnType.STRING, PrimitiveType.PrimitiveTypeName.BINARY);
            this.put(ColumnType.BOOLEAN, PrimitiveType.PrimitiveTypeName.BOOLEAN);
            this.put(ColumnType.DATE, PrimitiveType.PrimitiveTypeName.INT32);
            this.put(ColumnType.TIME, PrimitiveType.PrimitiveTypeName.INT32);
            this.put(ColumnType.DATETIME, PrimitiveType.PrimitiveTypeName.INT64);
            this.put(ColumnType.TIMESTAMP, PrimitiveType.PrimitiveTypeName.INT96);
            this.put(ColumnType.BYTE_ARRAY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
            this.put(ColumnType.UUID, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        }
    };
    private static final Map<ColumnType, LogicalTypeAnnotation> logicalTypeMap = new HashMap<ColumnType, LogicalTypeAnnotation>(){
        {
            this.put(ColumnType.DATE, LogicalTypeAnnotation.dateType());
            this.put(ColumnType.TIME, LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
            this.put(ColumnType.DATETIME, LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
            this.put(ColumnType.TIMESTAMP, LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
            this.put(ColumnType.STRING, LogicalTypeAnnotation.stringType());
            this.put(ColumnType.UUID, LogicalTypeAnnotation.uuidType());
        }
    };

    public static Type getParquetType(Column column) {
        LogicalTypeAnnotation logicalTypeAnnotation;
        Type.Repetition repetition;
        if (ColumnType.BYTE_ARRAY == column.type().spec() || ColumnType.UUID == column.type().spec()) {
            return ParquetGroupSchemaUtils.handleBinaryType(column);
        }
        Type.Repetition repetition2 = repetition = column.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        if (ColumnType.DECIMAL == column.type().spec()) {
            int precision = Math.min(38, ((DecimalNativeType)column.type()).precision());
            int scale = Math.min(20, ((DecimalNativeType)column.type()).scale());
            logicalTypeAnnotation = LogicalTypeAnnotation.decimalType((int)scale, (int)precision);
        } else {
            logicalTypeAnnotation = logicalTypeMap.get((Object)column.type().spec());
        }
        PrimitiveType.PrimitiveTypeName primitiveTypeName = primitiveTypeMap.getOrDefault((Object)column.type().spec(), PrimitiveType.PrimitiveTypeName.BINARY);
        return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)primitiveTypeName, (Type.Repetition)repetition).as(logicalTypeAnnotation)).named(column.name());
    }

    private static Type handleBinaryType(Column column) {
        Type.Repetition repetition = column.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        boolean isUuid = column.type().spec() == ColumnType.UUID;
        LogicalTypeAnnotation.UUIDLogicalTypeAnnotation logicalTypeAnnotation = isUuid ? LogicalTypeAnnotation.uuidType() : null;
        PrimitiveType.PrimitiveTypeName primitiveTypeName = isUuid ? PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY : PrimitiveType.PrimitiveTypeName.BINARY;
        int typeLength = isUuid ? 16 : 0;
        return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)primitiveTypeName, (Type.Repetition)repetition).length(typeLength)).as((LogicalTypeAnnotation)logicalTypeAnnotation)).named(column.name());
    }
}

