/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.metastorage;

import java.io.IOException;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;

public class LocalSnapshotStateSerializer
extends VersionedSerializer<LocalSnapshotState> {
    public static final LocalSnapshotStateSerializer INSTANCE = new LocalSnapshotStateSerializer();

    @Override
    protected void writeExternalData(LocalSnapshotState state, IgniteDataOutput out) throws IOException {
        out.writeVarInt(state.status().code());
        out.writeVarInt(state.numRows());
        LocalSnapshotStateSerializer.writeNullableString(state.errorMessage(), out);
    }

    @Override
    protected LocalSnapshotState readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        SnapshotStatus status = SnapshotStatus.fromCode(in.readVarIntAsInt());
        long numRows = in.readVarInt();
        String errorMessage = LocalSnapshotStateSerializer.readNullableString(in);
        return new LocalSnapshotState(status, numRows, errorMessage);
    }

    public static byte[] serialize(LocalSnapshotState state) {
        return VersionedSerialization.toBytes(state, INSTANCE);
    }

    public static LocalSnapshotState deserialize(byte[] bytes) {
        return VersionedSerialization.fromBytes(bytes, INSTANCE);
    }
}

