/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.jwt.store;

import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.EntryEvent;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.WatchListener;
import org.apache.ignite3.internal.security.jwt.configuration.JwtConfiguration;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.security.codec.MetastoreKeyCodec;
import org.gridgain.internal.security.jwt.store.serde.InstantSerDe;
import org.jetbrains.annotations.Nullable;

public class BlockListStore {
    static final String TOKEN_PREFIX = "gg9.security.jwt.blocklist.token";
    static final String USERNAME_PREFIX = "gg9.security.jwt.blocklist.username";
    private final MetaStorageManager metaStorage;
    private final long cleanerInterval;
    private final TimeUnit cleanerIntervalUnit;
    private final JwtConfiguration jwtConfiguration;
    private final ScheduledExecutorService cleaner;
    private final Map<String, Instant> blockedTokensCache = new ConcurrentHashMap<String, Instant>();
    private final Map<String, Instant> timestampCache = new ConcurrentHashMap<String, Instant>();
    private final MetastoreKeyCodec keyTokenCodec = MetastoreKeyCodec.forPrefix("gg9.security.jwt.blocklist.token");
    private final MetastoreKeyCodec keyUsernameCodec = MetastoreKeyCodec.forPrefix("gg9.security.jwt.blocklist.username");

    public BlockListStore(MetaStorageManager metaStorage, long cleanerInterval, TimeUnit cleanerIntervalUnit, JwtConfiguration jwtConfiguration) {
        this.metaStorage = metaStorage;
        this.cleanerInterval = cleanerInterval;
        this.cleanerIntervalUnit = cleanerIntervalUnit;
        this.jwtConfiguration = jwtConfiguration;
        this.cleaner = Executors.newScheduledThreadPool(1);
    }

    public void start() {
        this.metaStorage.registerPrefixWatch(this.keyTokenCodec.prefix(), new BlockedTokensWatcher());
        this.metaStorage.registerPrefixWatch(this.keyUsernameCodec.prefix(), new BlockedUsernamesWatcher());
        try (Cursor<Entry> cursor = this.metaStorage.prefixLocally(this.keyTokenCodec.prefix(), Long.MAX_VALUE);){
            cursor.forEach(entry -> this.blockedTokensCache.put(this.keyTokenCodec.deserialize(entry.key()), InstantSerDe.deserialize(entry.value())));
        }
        cursor = this.metaStorage.prefixLocally(this.keyUsernameCodec.prefix(), Long.MAX_VALUE);
        try {
            cursor.forEach(entry -> {
                String key = this.keyUsernameCodec.deserialize(entry.key());
                this.timestampCache.put(key, InstantSerDe.deserialize(entry.value()));
            });
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.cleaner.scheduleAtFixedRate(this::clean, 0L, this.cleanerInterval, this.cleanerIntervalUnit);
    }

    public void stop() {
        IgniteUtils.shutdownAndAwaitTermination(this.cleaner, 10L, this.cleanerIntervalUnit);
    }

    private void clean() {
        Instant now = Instant.now();
        HashSet<String> tokensToRemove = new HashSet<String>();
        this.blockedTokensCache.forEach((token, expirationTime) -> {
            if (expirationTime.isBefore(now)) {
                tokensToRemove.add((String)token);
            }
        });
        long timestampTtl = (Long)this.jwtConfiguration.keyTtl().value() * 2L;
        HashSet usernamesToRemove = new HashSet();
        this.timestampCache.forEach((username, timestamp) -> {
            if (timestamp.plusMillis(timestampTtl).isBefore(now)) {
                usernamesToRemove.add(username);
            }
        });
        this.removeTokens(tokensToRemove).thenCompose(ignored -> this.removeTimestampsForUsers(usernamesToRemove));
    }

    public CompletableFuture<Void> saveToken(String token, Instant expirationTime) {
        return this.metaStorage.put(this.keyTokenCodec.serialize(token), InstantSerDe.serialize(expirationTime)).whenComplete((res, err) -> {
            if (err == null) {
                this.blockedTokensCache.put(token, expirationTime);
            }
        });
    }

    private CompletableFuture<Void> removeTokens(Set<String> tokens) {
        Set<ByteArray> keysToRemove = tokens.stream().map(this.keyTokenCodec::serialize).collect(Collectors.toSet());
        return this.metaStorage.removeAll(keysToRemove).whenComplete((res, err) -> {
            if (err == null) {
                this.blockedTokensCache.keySet().removeAll(tokens);
            }
        });
    }

    public boolean isTokenBlocked(String token) {
        return this.blockedTokensCache.containsKey(token);
    }

    public CompletableFuture<Void> saveUsernameAndTimestamp(String username, Instant timestampRecord) {
        return this.metaStorage.put(this.keyUsernameCodec.serialize(username), InstantSerDe.serialize(timestampRecord)).whenComplete((res, err) -> {
            if (err == null) {
                this.timestampCache.put(username, timestampRecord);
            }
        });
    }

    private CompletableFuture<Void> removeTimestampsForUsers(Set<String> usernames) {
        Set<ByteArray> usernamesToRemove = usernames.stream().map(this.keyUsernameCodec::serialize).collect(Collectors.toSet());
        return this.metaStorage.removeAll(usernamesToRemove).whenComplete((res, err) -> {
            if (err == null) {
                this.timestampCache.keySet().removeAll(usernames);
            }
        });
    }

    @Nullable
    public Instant getTimestamp(String username) {
        return this.timestampCache.get(username);
    }

    private class BlockedTokensWatcher
    implements WatchListener {
        private BlockedTokensWatcher() {
        }

        @Override
        public CompletableFuture<Void> onUpdate(WatchEvent event) {
            event.entryEvents().stream().map(EntryEvent::newEntry).forEach(newEntry -> {
                String key = BlockListStore.this.keyTokenCodec.deserialize(newEntry.key());
                if (newEntry.empty() || newEntry.tombstone()) {
                    BlockListStore.this.blockedTokensCache.remove(key);
                } else {
                    BlockListStore.this.blockedTokensCache.put(key, InstantSerDe.deserialize(newEntry.value()));
                }
            });
            return CompletableFuture.completedFuture(null);
        }
    }

    private class BlockedUsernamesWatcher
    implements WatchListener {
        private BlockedUsernamesWatcher() {
        }

        @Override
        public CompletableFuture<Void> onUpdate(WatchEvent event) {
            event.entryEvents().stream().map(EntryEvent::newEntry).forEach(newEntry -> {
                String key = BlockListStore.this.keyUsernameCodec.deserialize(newEntry.key());
                if (newEntry.empty() || newEntry.tombstone()) {
                    BlockListStore.this.timestampCache.remove(key);
                } else {
                    BlockListStore.this.timestampCache.put(key, InstantSerDe.deserialize(newEntry.value()));
                }
            });
            return CompletableFuture.completedFuture(null);
        }
    }
}

