/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.gridgain.internal.rbac.store.LowerCaseString;
import org.gridgain.internal.rbac.store.OperationResult;
import org.jetbrains.annotations.Nullable;

public interface Store<T> {
    public CompletableFuture<OperationResult> putIfNotExists(LowerCaseString var1, T var2);

    default public CompletableFuture<OperationResult> putIfNotExists(String key, T entry) {
        return this.putIfNotExists(LowerCaseString.from(key), entry);
    }

    public CompletableFuture<OperationResult> updateIfExists(LowerCaseString var1, Function<T, T> var2);

    default public CompletableFuture<OperationResult> updateIfExists(String key, Function<T, T> update) {
        return this.updateIfExists(LowerCaseString.from(key), update);
    }

    public CompletableFuture<OperationResult> removeIfExists(LowerCaseString var1);

    default public CompletableFuture<OperationResult> removeIfExists(String key) {
        return this.removeIfExists(LowerCaseString.from(key));
    }

    public Collection<T> getAll();

    public Map<LowerCaseString, T> getAllWithKeys();

    @Nullable
    public T get(LowerCaseString var1);

    @Nullable
    default public T get(String key) {
        return this.get(LowerCaseString.from(key));
    }

    public List<T> get(LowerCaseString ... var1);

    default public List<T> get(String ... keys) {
        return this.get((LowerCaseString[])Arrays.stream(keys).map(LowerCaseString::from).toArray(LowerCaseString[]::new));
    }
}

