/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.validator;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.gridgain.internal.encryption.validator.FileExists;

public class FileExistsValidatorImpl
implements Validator<FileExists, String> {
    public static final FileExistsValidatorImpl INSTANCE = new FileExistsValidatorImpl();

    @Override
    public void validate(FileExists annotation, ValidationContext<String> ctx) {
        Path path;
        String msgStem = "'" + ctx.currentKey() + "' ";
        try {
            path = Path.of(ctx.getNewValue(), new String[0]);
        }
        catch (InvalidPathException ex) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), msgStem + "is not a valid path."));
            return;
        }
        if (Files.notExists(path, new LinkOption[0])) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), msgStem + "does not exist."));
        } else if (!Files.isRegularFile(path, new LinkOption[0])) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), msgStem + "is not a regular file."));
        } else if (!Files.isReadable(path)) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), msgStem + "is not readable."));
        }
    }
}

