/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.metastorage;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.gridgain.internal.dcr.ReplicationStatus;
import org.gridgain.internal.dcr.metastorage.MetaStoreEncoder;
import org.jetbrains.annotations.Nullable;

class MetaStoreByteArrayBuilder {
    public static final String LIST_DELIMITER = ":";
    public static final String ENTRY_DELIMITER = "@";
    public static final String DELIMITER = ";";
    private MetaStoreEncoder encoder = new MetaStoreEncoder();
    private StringBuilder resultBuilder = new StringBuilder();
    private boolean firstAppendDone = false;

    MetaStoreByteArrayBuilder() {
    }

    public MetaStoreByteArrayBuilder appendCollection(Collection<String> collection) {
        this.appendDelimiterIfNecessary();
        this.resultBuilder.append(collection.stream().map(node -> this.encoder.encodeString((String)node)).collect(Collectors.joining(LIST_DELIMITER)));
        this.firstAppendDone = true;
        return this;
    }

    public MetaStoreByteArrayBuilder appendNullableCollection(@Nullable Collection<String> collection) {
        if (collection != null) {
            return this.appendCollection(collection);
        }
        this.appendDelimiterIfNecessary();
        this.firstAppendDone = true;
        return this;
    }

    public MetaStoreByteArrayBuilder appendNullableMap(@Nullable Map<String, ReplicationStatus> map) {
        this.appendDelimiterIfNecessary();
        if (map != null) {
            this.resultBuilder.append(map.entrySet().stream().map(entry -> this.encoder.encodeString((String)entry.getKey()) + ENTRY_DELIMITER + ((ReplicationStatus)((Object)((Object)entry.getValue()))).ordinal()).collect(Collectors.joining(LIST_DELIMITER)));
        }
        this.firstAppendDone = true;
        return this;
    }

    public MetaStoreByteArrayBuilder appendString(String string) {
        this.appendDelimiterIfNecessary();
        this.resultBuilder.append(this.encoder.encodeString(string));
        this.firstAppendDone = true;
        return this;
    }

    public MetaStoreByteArrayBuilder appendNullableString(@Nullable String string) {
        this.appendDelimiterIfNecessary();
        this.resultBuilder.append(this.encoder.encodeNullableString(string));
        this.firstAppendDone = true;
        return this;
    }

    public MetaStoreByteArrayBuilder appendByteArray(byte[] byteArray) {
        this.appendDelimiterIfNecessary();
        this.resultBuilder.append(this.encoder.encodeByteArray(byteArray));
        this.firstAppendDone = true;
        return this;
    }

    public MetaStoreByteArrayBuilder appendInt(int integer) {
        this.appendDelimiterIfNecessary();
        this.resultBuilder.append(integer);
        this.firstAppendDone = true;
        return this;
    }

    public MetaStoreByteArrayBuilder appendLong(long longInt) {
        this.appendDelimiterIfNecessary();
        this.resultBuilder.append(longInt);
        this.firstAppendDone = true;
        return this;
    }

    public byte[] build() {
        return this.resultBuilder.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void appendDelimiterIfNecessary() {
        if (this.firstAppendDone) {
            this.resultBuilder.append(DELIMITER);
        }
    }
}

