/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.decorators;

import com.jakewharton.fliptables.FlipTableConverters;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite3.internal.cli.util.PlainTableRenderer;
import org.gridgain.internal.cli.call.rbac.role.Role;

public class RoleListDecorator
implements Decorator<List<Role>, TerminalOutput> {
    private static final String[] HEADERS = new String[]{"role"};
    private final boolean plain;

    public RoleListDecorator(boolean plain) {
        this.plain = plain;
    }

    private static String[][] rolesContent(List<Role> data) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Role role : data) {
            result.add(new String[]{role.roleName()});
        }
        return (String[][])result.toArray((T[])new String[0][]);
    }

    @Override
    public TerminalOutput decorate(List<Role> data) {
        if (data == null || data.isEmpty()) {
            return () -> "";
        }
        if (this.plain) {
            return () -> PlainTableRenderer.render(HEADERS, RoleListDecorator.rolesContent(data));
        }
        return () -> FlipTableConverters.fromObjects((String[])HEADERS, (Object[][])RoleListDecorator.rolesContent(data));
    }
}

