/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.user.DeleteUserCallInput;
import org.gridgain.internal.cli.call.rbac.user.DeleteUserReplCall;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete user if exists"})
public class UserDeleteReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(description={"Username"})
    private String username;
    @Inject
    private DeleteUserReplCall deleteUserCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.deleteUserCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot delete user")).print());
    }

    private DeleteUserCallInput input(String clusterUrl) {
        return DeleteUserCallInput.builder().clusterUrl(clusterUrl).username(this.username).build();
    }
}

