/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.user;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.RoleAssignmentsApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.Role;
import org.apache.ignite3.rest.client.model.UserRoles;
import org.gridgain.internal.cli.call.rbac.user.ListUsersCallInput;
import org.gridgain.internal.cli.call.rbac.user.User;

@Singleton
public class ListUsersCall
implements Call<ListUsersCallInput, List<User>> {
    private final ApiClientFactory apiClientFactory;

    public ListUsersCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<List<User>> execute(ListUsersCallInput input) {
        try {
            List<User> users = this.fetchUsersRolesRest(input);
            return DefaultCallOutput.success(users);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.url()));
        }
    }

    private List<User> fetchUsersRolesRest(ListUsersCallInput input) throws ApiException {
        RoleAssignmentsApi roleAssignmentsApi = new RoleAssignmentsApi(this.apiClientFactory.getClient(input.url()));
        boolean noFilter = input.filterByRoleName() == null;
        return roleAssignmentsApi.getUsersWithRoles().stream().filter(dto -> noFilter || ListUsersCall.roleAssigned(input.filterByRoleName(), dto)).map(usersRolesDto -> User.builder().username(usersRolesDto.getUsername()).assignedRoles(ListUsersCall.assignedRoles(usersRolesDto)).build()).collect(Collectors.toList());
    }

    private static boolean roleAssigned(String role, UserRoles dto) {
        if (dto.getRoles() == null) {
            return false;
        }
        return dto.getRoles().stream().anyMatch(r -> role.equals(r.getRoleName()));
    }

    private static List<String> assignedRoles(UserRoles usersRolesDto) {
        if (usersRolesDto.getRoles() == null) {
            return List.of();
        }
        return usersRolesDto.getRoles().stream().map(Role::getRoleName).collect(Collectors.toList());
    }
}

