/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.core;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.gridgain.internal.cdc.api.CdcManager;
import org.gridgain.internal.cdc.api.replication.CdcReplicationDefinition;
import org.gridgain.internal.cdc.api.replication.CdcReplicationInstance;
import org.gridgain.internal.cdc.api.replication.CdcReplicationStatus;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.SinkStatus;
import org.gridgain.internal.cdc.api.source.SourceDefinition;
import org.gridgain.internal.cdc.api.source.SourceStatus;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;

public class SecuredCdcManager
implements CdcManager {
    private final Authorizer authorizer;
    private final CdcManager delegate;

    public SecuredCdcManager(Authorizer authorizer, CdcManager delegate) {
        this.authorizer = authorizer;
        this.delegate = delegate;
    }

    @Override
    public CompletableFuture<Void> createSource(SourceDefinition sourceDefinition) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.createSource(sourceDefinition));
    }

    @Override
    public CompletableFuture<Void> deleteSource(String sourceName) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.deleteSource(sourceName));
    }

    @Override
    public CompletableFuture<SourceDefinition> getSource(String sourceName) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.getSource(sourceName));
    }

    @Override
    public CompletableFuture<Collection<SourceDefinition>> listSources() {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, this.delegate::listSources);
    }

    @Override
    public CompletableFuture<Void> updateSource(SourceDefinition source) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.updateSource(source));
    }

    @Override
    public CompletableFuture<SourceStatus> getSourceStatus(String name) {
        return this.authorizer.authorize(Action.MANAGE_CDC, () -> this.delegate.getSourceStatus(name));
    }

    @Override
    public CompletableFuture<Void> createSink(SinkDefinition sinkDefinition) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.createSink(sinkDefinition));
    }

    @Override
    public CompletableFuture<Void> deleteSink(String sinkName) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.deleteSink(sinkName));
    }

    @Override
    public CompletableFuture<SinkDefinition> getSink(String sinkName) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.getSink(sinkName));
    }

    @Override
    public CompletableFuture<Collection<SinkDefinition>> listSinks() {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, this.delegate::listSinks);
    }

    @Override
    public CompletableFuture<Void> updateSink(SinkDefinition sink) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.updateSink(sink));
    }

    @Override
    public CompletableFuture<SinkStatus> getSinkStatus(String name) {
        return this.authorizer.authorize(Action.MANAGE_CDC, () -> this.delegate.getSinkStatus(name));
    }

    @Override
    public CompletableFuture<CdcReplicationInstance> createReplication(CdcReplicationDefinition replicationDefinition) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.createReplication(replicationDefinition));
    }

    @Override
    public CompletableFuture<Void> deleteReplication(String replicationName) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.deleteReplication(replicationName));
    }

    @Override
    public CompletableFuture<CdcReplicationInstance> getReplication(String replicationName) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.getReplication(replicationName));
    }

    @Override
    public CompletableFuture<Collection<CdcReplicationInstance>> listReplications() {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, this.delegate::listReplications);
    }

    @Override
    public CompletableFuture<Collection<CdcReplicationInstance>> listReplicationsByStatus(CdcReplicationStatus status) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.listReplicationsByStatus(status));
    }

    @Override
    public CompletableFuture<CdcReplicationInstance> startReplication(String replicationName) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.startReplication(replicationName));
    }

    @Override
    public CompletableFuture<CdcReplicationInstance> stopReplication(String replicationName) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.stopReplication(replicationName));
    }

    @Override
    public CompletableFuture<Void> updateReplication(CdcReplicationInstance replicationInstance) {
        return this.authorizer.authorizeThenCompose(Action.MANAGE_CDC, () -> this.delegate.updateReplication(replicationInstance));
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return this.delegate.startAsync(componentContext);
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return this.delegate.stopAsync(componentContext);
    }
}

