/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Violation {
    private final String name;
    @Nullable
    private final String errorDetails;
    @Nullable
    private final String hint;

    private Violation(String name, @Nullable String errorDetails, @Nullable String hint) {
        this.name = name;
        this.errorDetails = errorDetails;
        this.hint = hint;
    }

    public String name() {
        return this.name;
    }

    public String hint() {
        return this.hint;
    }

    @Nullable
    public String errorDetails() {
        return this.errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Violation check = (Violation)o;
        return Objects.equals(this.name, check.name) && Objects.equals(this.errorDetails, check.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.errorDetails);
    }

    public String toString() {
        return "Check{name='" + this.name + "', errorDetails='" + this.errorDetails + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Violation create(String name, String errorDetails) {
        return Violation.builder().name(name).errorDetails(errorDetails).build();
    }

    public static class Builder {
        private String name;
        private String errorDetails;
        private String hint;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder errorDetails(@Nullable String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public Builder hint(@Nullable String hint) {
            this.hint = hint;
            return this;
        }

        public Builder hint(String s, String ... args) {
            this.hint = String.format(s, args);
            return this;
        }

        public Violation build() {
            Objects.requireNonNull(this.name, "Violation name must be provided.");
            return new Violation(this.name, this.errorDetails, this.hint);
        }
    }
}

