/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.raft.WriteCommand;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.WriteActionRequest;
import org.apache.ignite3.raft.jraft.rpc.WriteActionRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.WriteActionRequestSerializer;

public class WriteActionRequestImpl
implements WriteActionRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 4001;
    @IgniteToStringInclude
    private final byte[] command;
    @IgniteToStringInclude
    private final WriteCommand deserializedCommand;
    @IgniteToStringInclude
    private final String groupId;

    private WriteActionRequestImpl(byte[] command, WriteCommand deserializedCommand, String groupId) {
        this.command = command;
        this.deserializedCommand = deserializedCommand;
        this.groupId = groupId;
    }

    @Override
    public byte[] command() {
        return this.command;
    }

    @Override
    public WriteCommand deserializedCommand() {
        return this.deserializedCommand;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    public MessageSerializer serializer() {
        return WriteActionRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(WriteActionRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 4001;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WriteActionRequestImpl otherMessage = (WriteActionRequestImpl)other;
        return Objects.equals(this.deserializedCommand, otherMessage.deserializedCommand) && Objects.equals(this.groupId, otherMessage.groupId) && Arrays.equals(this.command, otherMessage.command);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.deserializedCommand, this.groupId);
        result = 31 * result + Arrays.hashCode(this.command);
        return result;
    }

    @Override
    public WriteActionRequestImpl clone() {
        try {
            return (WriteActionRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static WriteActionRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.deserializedCommand != null) {
            this.deserializedCommand.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.deserializedCommand != null) {
            this.deserializedCommand.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements WriteActionRequestBuilder {
        private byte[] command;
        private WriteCommand deserializedCommand;
        private String groupId;

        private Builder() {
        }

        @Override
        public WriteActionRequestBuilder command(byte[] command) {
            Objects.requireNonNull(command, "command is not marked @Nullable");
            this.command = command;
            return this;
        }

        @Override
        public WriteActionRequestBuilder deserializedCommand(WriteCommand deserializedCommand) {
            this.deserializedCommand = deserializedCommand;
            return this;
        }

        @Override
        public WriteActionRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public byte[] command() {
            return this.command;
        }

        @Override
        public WriteCommand deserializedCommand() {
            return this.deserializedCommand;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public WriteActionRequest build() {
            return new WriteActionRequestImpl(Objects.requireNonNull(this.command, "command is not marked @Nullable"), this.deserializedCommand, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"));
        }

        @Override
        public WriteActionRequest buildDeserialized() {
            return new WriteActionRequestImpl(this.command, this.deserializedCommand, this.groupId);
        }
    }
}

