/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.GetFileResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.GetFileResponseSerializer;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

public class GetFileResponseImpl
implements RpcRequests.GetFileResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3011;
    @IgniteToStringInclude
    private final ByteBuffer data;
    @IgniteToStringInclude
    private final boolean eof;
    @IgniteToStringInclude
    private final long readSize;

    private GetFileResponseImpl(ByteBuffer data, boolean eof, long readSize) {
        this.data = data;
        this.eof = eof;
        this.readSize = readSize;
    }

    @Override
    public ByteBuffer data() {
        return this.data;
    }

    @Override
    public boolean eof() {
        return this.eof;
    }

    @Override
    public long readSize() {
        return this.readSize;
    }

    public MessageSerializer serializer() {
        return GetFileResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(GetFileResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3011;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetFileResponseImpl otherMessage = (GetFileResponseImpl)other;
        return Objects.equals(this.data, otherMessage.data) && this.eof == otherMessage.eof && this.readSize == otherMessage.readSize;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.eof, this.readSize, this.data);
        return result;
    }

    @Override
    public GetFileResponseImpl clone() {
        try {
            return (GetFileResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetFileResponseBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetFileResponseBuilder {
        private ByteBuffer data;
        private boolean eof;
        private long readSize;

        private Builder() {
        }

        @Override
        public GetFileResponseBuilder data(ByteBuffer data) {
            Objects.requireNonNull(data, "data is not marked @Nullable");
            this.data = data;
            return this;
        }

        @Override
        public GetFileResponseBuilder eof(boolean eof) {
            this.eof = eof;
            return this;
        }

        @Override
        public GetFileResponseBuilder readSize(long readSize) {
            this.readSize = readSize;
            return this;
        }

        @Override
        public ByteBuffer data() {
            return this.data;
        }

        @Override
        public boolean eof() {
            return this.eof;
        }

        @Override
        public long readSize() {
            return this.readSize;
        }

        @Override
        public RpcRequests.GetFileResponse build() {
            return new GetFileResponseImpl(Objects.requireNonNull(this.data, "data is not marked @Nullable"), this.eof, this.readSize);
        }

        @Override
        public RpcRequests.GetFileResponse buildDeserialized() {
            return new GetFileResponseImpl(this.data, this.eof, this.readSize);
        }
    }
}

