/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.replicator;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite3.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite3.internal.continuousquery.RowUpdateInfo;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.jetbrains.annotations.Nullable;

class BinaryRowColumnExtractor {
    BinaryRowColumnExtractor() {
    }

    static void extractColumns(List<RowUpdateInfo<BinaryRow>> rowInfos, String @Nullable [] columnNames, SchemaRegistry schemaRegistry) {
        if (columnNames == null) {
            return;
        }
        Function<Integer, BitSet> columnIndexesFunc = BinaryRowColumnExtractor.columnIndexesFunc(columnNames, schemaRegistry);
        for (int i = 0; i < rowInfos.size(); ++i) {
            RowUpdateInfo<BinaryRow> rowInfo = rowInfos.get(i);
            BinaryRow row = BinaryRowColumnExtractor.extractColumns(rowInfo.row(), columnIndexesFunc);
            BinaryRow oldRow = BinaryRowColumnExtractor.extractColumns(rowInfo.oldRow(), columnIndexesFunc);
            RowUpdateInfo<BinaryRow> newRowInfo = new RowUpdateInfo<BinaryRow>(rowInfo.rowUuid(), rowInfo.timestamp(), row, oldRow, rowInfo.commitTs(), rowInfo.oldCommitTs(), rowInfo.eventType());
            rowInfos.set(i, newRowInfo);
        }
    }

    @Nullable
    private static BinaryRow extractColumns(@Nullable BinaryRow row, Function<Integer, BitSet> columnIndexesFunc) {
        if (row == null) {
            return null;
        }
        BitSet columnIndexes = columnIndexesFunc.apply(row.schemaVersion());
        ByteBuffer tupleBuffer = row.tupleSlice();
        int schemaSize = columnIndexes.length() - 1;
        BinaryTupleParser parser = new BinaryTupleParser(schemaSize, tupleBuffer);
        BinaryTupleBuilder builder = new BinaryTupleBuilder(schemaSize);
        for (int i = 0; i < schemaSize; ++i) {
            if (!columnIndexes.get(i)) {
                builder.appendNull();
                continue;
            }
            parser.fetch(i, (index, begin, end) -> {
                if (begin == end) {
                    builder.appendNull();
                } else {
                    builder.appendElementBytes(tupleBuffer, begin, end - begin);
                }
            });
        }
        return new BinaryRowImpl(row.schemaVersion(), builder.build());
    }

    private static Function<Integer, BitSet> columnIndexesFunc(final String[] columnNames, final SchemaRegistry schemaRegistry) {
        return new Function<Integer, BitSet>(){
            int lastSchemaVer = -1;
            @Nullable
            BitSet columnIndexes = null;

            @Override
            public BitSet apply(Integer schemaVer) {
                if (this.lastSchemaVer == schemaVer && this.columnIndexes != null) {
                    return this.columnIndexes;
                }
                this.lastSchemaVer = schemaVer;
                SchemaDescriptor schema = schemaRegistry.schema(schemaVer);
                this.columnIndexes = new BitSet(schema.length());
                this.columnIndexes.set(schema.length());
                for (String includedColumnName : columnNames) {
                    Column col = schema.column(includedColumnName);
                    if (col == null) continue;
                    this.columnIndexes.set(col.positionInRow());
                }
                return this.columnIndexes;
            }
        };
    }
}

