/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.raft.snapshot;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.continuousquery.RowUpdateInfo;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.ZonePartitionKey;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.outgoing.OutgoingSnapshot;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.outgoing.PartitionSnapshots;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.outgoing.PartitionsSnapshots;
import org.apache.ignite3.internal.raft.RaftGroupConfiguration;
import org.apache.ignite3.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AbortResult;
import org.apache.ignite3.internal.storage.AddWriteCommittedResult;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.CommitResult;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.PartitionTimestampCursor;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.gc.GcEntry;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.table.TableRowEventType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SnapshotAwarePartitionDataStorage
implements PartitionDataStorage {
    private final int tableId;
    private final MvPartitionStorage partitionStorage;
    private final PartitionsSnapshots partitionsSnapshots;
    private final PartitionKey partitionKey;
    private final RaftGroupConfigurationConverter raftGroupConfigurationConverter = new RaftGroupConfigurationConverter();

    public SnapshotAwarePartitionDataStorage(int tableId, MvPartitionStorage partitionStorage, PartitionsSnapshots partitionsSnapshots, PartitionKey partitionKey) {
        this.tableId = tableId;
        this.partitionStorage = partitionStorage;
        this.partitionsSnapshots = partitionsSnapshots;
        this.partitionKey = partitionKey;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public int partitionId() {
        return this.partitionKey.partitionId();
    }

    @Override
    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        return this.partitionStorage.runConsistently(closure);
    }

    @Override
    public void acquirePartitionSnapshotsReadLock() {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        partitionSnapshots.acquireReadLock();
    }

    @Override
    public void releasePartitionSnapshotsReadLock() {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        partitionSnapshots.releaseReadLock();
    }

    private PartitionSnapshots getPartitionSnapshots() {
        return this.partitionsSnapshots.partitionSnapshots(this.partitionKey);
    }

    @Override
    public CompletableFuture<Void> flush(boolean trigger) {
        return this.partitionStorage.flush(trigger);
    }

    @Override
    public long lastAppliedIndex() {
        return this.partitionStorage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.partitionStorage.lastAppliedTerm();
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.partitionStorage.lastApplied(lastAppliedIndex, lastAppliedTerm);
    }

    @Override
    public void committedGroupConfiguration(RaftGroupConfiguration config) {
        this.partitionStorage.committedGroupConfiguration(this.raftGroupConfigurationConverter.toBytes(config));
    }

    @Override
    @Nullable
    public RaftGroupConfiguration committedGroupConfiguration() {
        return this.raftGroupConfigurationConverter.fromBytes(this.partitionStorage.committedGroupConfiguration());
    }

    @Override
    public AddWriteResult addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableOrZoneId, int commitPartitionId, boolean isArchivation) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.addWrite(rowId, row, txId, commitTableOrZoneId, commitPartitionId, isArchivation);
    }

    @Override
    public AddWriteCommittedResult addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.addWriteCommitted(rowId, row, commitTimestamp);
    }

    @Override
    public AbortResult abortWrite(RowId rowId, UUID txId) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.abortWrite(rowId, txId);
    }

    @Override
    public CommitResult commitWrite(RowId rowId, HybridTimestamp timestamp, UUID txId) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.commitWrite(rowId, timestamp, txId);
    }

    @Override
    public void discard(RowId rowId) {
        this.partitionStorage.discard(rowId);
    }

    @Override
    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        return this.partitionStorage.scanVersions(rowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSnapshotInterference(RowId rowId) {
        ArrayList<OutgoingSnapshot> outgoingSnapshots = new ArrayList<OutgoingSnapshot>();
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        partitionSnapshots.acquireReadLock();
        try {
            outgoingSnapshots.addAll(partitionSnapshots.ongoingSnapshots());
        }
        finally {
            partitionSnapshots.releaseReadLock();
        }
        for (OutgoingSnapshot snapshot : outgoingSnapshots) {
            snapshot.acquireMvLock();
            try {
                if (snapshot.alreadyPassedOrIrrelevant(this.tableId, rowId) || !snapshot.addRowIdToSkip(rowId)) continue;
                snapshot.enqueueForSending(this.tableId, rowId);
            }
            finally {
                snapshot.releaseMvLock();
            }
        }
    }

    @Override
    public void close() {
        if (this.partitionKey instanceof ZonePartitionKey) {
            return;
        }
        this.partitionsSnapshots.cleanupOutgoingSnapshots(this.partitionKey);
    }

    @Override
    @TestOnly
    public MvPartitionStorage getStorage() {
        return this.partitionStorage;
    }

    @Override
    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        return this.partitionStorage.scan(timestamp);
    }

    @Override
    public List<RowUpdateInfo<BinaryRow>> scanUpdateLog(HybridTimestamp lowerBoundTs, RowId lowerBoundRowId, HybridTimestamp upperBoundTs, int maxItems, EnumSet<TableRowEventType> eventTypes, boolean skipOldEntries) throws StorageException {
        return this.partitionStorage.scanUpdateLog(lowerBoundTs, lowerBoundRowId, upperBoundTs, maxItems, eventTypes, skipOldEntries);
    }

    @Override
    @Nullable
    public GcEntry peek(HybridTimestamp lowWatermark) {
        return this.partitionStorage.peek(lowWatermark);
    }

    @Override
    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        return this.partitionStorage.vacuum(entry);
    }

    @Override
    public void trimUpdateLog(HybridTimestamp lowWatermark, int maxItems) {
        this.partitionStorage.trimUpdateLog(lowWatermark, maxItems);
    }

    @Override
    public void updateLease(LeaseInfo leaseInfo) {
        this.partitionStorage.updateLease(leaseInfo);
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.partitionStorage.leaseInfo();
    }
}

