/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.expiration.metrics;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.metrics.AbstractMetric;
import org.apache.ignite3.internal.metrics.CompositeMetric;
import org.apache.ignite3.internal.metrics.Metric;
import org.apache.ignite3.internal.table.distributed.expiration.metrics.ExpirationTableMetric;
import org.jetbrains.annotations.Nullable;

public class DetailedExpirationMetric
extends AbstractMetric
implements CompositeMetric {
    static final int MAX_PRINTED_TABLES = 3;
    private final Map<Integer, ExpirationTableMetric> tableMetrics = new ConcurrentHashMap<Integer, ExpirationTableMetric>();

    DetailedExpirationMetric(String name, @Nullable String desc) {
        super(name, desc);
    }

    void add(String tableName, int tableId, int partitionId, long delta) {
        this.tableMetrics.computeIfAbsent(tableId, k -> new ExpirationTableMetric(tableName, "Metrics for expired rows in table " + tableName)).add(partitionId, delta);
    }

    void remove(int tableId, int partitionId) {
        this.tableMetrics.computeIfPresent(tableId, (k, v) -> {
            v.remove(partitionId);
            return v.isEmpty() ? null : v;
        });
    }

    void remove(int tableId) {
        this.tableMetrics.remove(tableId);
    }

    @Override
    public List<Metric> asScalarMetrics() {
        return List.copyOf(this.tableMetrics.values());
    }

    @Override
    @Nullable
    public String getValueAsString() {
        StringBuilder sb = new StringBuilder("[");
        int cnt = 0;
        for (ExpirationTableMetric metric : this.tableMetrics.values()) {
            if (cnt < 3) {
                sb.append(metric.name()).append(": ").append(metric.getValueAsString()).append(", ");
                ++cnt;
                continue;
            }
            sb.append("...").append(", ");
            break;
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }
}

