/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.systemview.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.systemview.api.SystemViewColumn;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.util.StringUtils;

public abstract class SystemView<T> {
    private static final Pattern LETTER_AND_UNDERSCORE = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*");
    private final String name;
    private final List<SystemViewColumn<T, ?>> columns;
    private final Flow.Publisher<T> dataProvider;

    SystemView(String name, List<SystemViewColumn<T, ?>> columns, Flow.Publisher<T> dataProvider) {
        if (StringUtils.nullOrBlank(name)) {
            throw new IllegalArgumentException("Name can not be null or blank");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Columns can not be empty");
        }
        List duplicates = columns.stream().map(SystemViewColumn::name).filter(Predicate.not(new HashSet()::add)).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Column names must be unique. Duplicates: " + String.valueOf(duplicates));
        }
        if (dataProvider == null) {
            throw new IllegalArgumentException("DataProvider can not be null");
        }
        this.name = name;
        this.columns = List.copyOf(columns);
        this.dataProvider = dataProvider;
    }

    public String name() {
        return this.name;
    }

    public List<SystemViewColumn<T, ?>> columns() {
        return this.columns;
    }

    public Flow.Publisher<T> dataProvider() {
        return this.dataProvider;
    }

    static String normalizeIdentifier(String identifier) {
        if (StringUtils.nullOrBlank(identifier)) {
            throw new IllegalArgumentException("Identifier must not be null or blank");
        }
        if (!LETTER_AND_UNDERSCORE.matcher(identifier).matches()) {
            throw new IllegalArgumentException("Identifier must be alphanumeric with underscore and start with letter. Was: " + identifier);
        }
        return identifier.toUpperCase(Locale.ROOT);
    }

    public static abstract class SystemViewBuilder<ViewT extends SystemView<T>, T, BuilderT> {
        protected final List<SystemViewColumn<T, ?>> columns = new ArrayList();
        protected String name;
        protected Flow.Publisher<T> dataProvider;

        SystemViewBuilder() {
        }

        public BuilderT name(String name) {
            this.name = SystemView.normalizeIdentifier(name);
            return (BuilderT)this;
        }

        public <C> BuilderT addColumn(String name, NativeType type, Function<T, C> value) {
            this.columns.add(new SystemViewColumn<T, C>(SystemView.normalizeIdentifier(name), type, value));
            return (BuilderT)this;
        }

        public BuilderT dataProvider(Flow.Publisher<T> dataProvider) {
            this.dataProvider = dataProvider;
            return (BuilderT)this;
        }

        public abstract ViewT build();
    }
}

