/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite3.internal.pagememory.io.DataPagePayload;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite3.internal.storage.pagememory.mv.ReadRowVersionValue;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.jetbrains.annotations.Nullable;

class FindRowVersion
implements PageMemoryTraversal<RowVersionFilter> {
    private final int partitionId;
    private final boolean loadValueBytes;
    private boolean rowVersionFound;
    private final ReadRowVersionValue readRowVersionValue = new ReadRowVersionValue();
    private long rowLink = 0L;
    @Nullable
    private HybridTimestamp rowTimestamp;
    private long rowNextLink = 0L;
    private int rowValueSize;
    private int schemaVersion;
    private boolean isArchived;
    @Nullable
    private RowVersion result;

    FindRowVersion(int partitionId, boolean loadValueBytes) {
        this.partitionId = partitionId;
        this.loadValueBytes = loadValueBytes;
    }

    @Override
    public long consumePagePayload(long link, long pageAddr, DataPagePayload payload, RowVersionFilter filter) {
        boolean hasArchivedField;
        if (this.rowVersionFound) {
            return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
        }
        long nextLink = PartitionlessLinks.readPartitionless(this.partitionId, pageAddr, payload.offset() + 9);
        if (!filter.apply(link, pageAddr + (long)payload.offset())) {
            return nextLink;
        }
        this.rowVersionFound = true;
        this.rowLink = link;
        this.rowTimestamp = HybridTimestamps.readTimestamp(pageAddr, payload.offset() + 1);
        this.rowNextLink = nextLink;
        this.schemaVersion = Short.toUnsignedInt(PageUtils.getShort(pageAddr, payload.offset() + 19));
        if (this.loadValueBytes) {
            return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
        }
        this.rowValueSize = PageUtils.getInt(pageAddr, payload.offset() + 15);
        boolean bl = hasArchivedField = this.schemaVersion == 0 && payload.payloadSize() == 22;
        if (hasArchivedField) {
            this.isArchived = PageUtils.getShort(pageAddr, payload.offset() + 21) == 1;
        }
        return 0L;
    }

    @Override
    public void finish() {
        if (!this.rowVersionFound) {
            return;
        }
        if (this.loadValueBytes) {
            this.readRowVersionValue.finish();
            byte[] valueBytes = this.readRowVersionValue.result();
            BinaryRowImpl row = valueBytes.length == 0 ? null : new BinaryRowImpl(this.schemaVersion, ByteBuffer.wrap(valueBytes).order(BinaryTuple.ORDER));
            this.result = new RowVersion(this.partitionId, this.rowLink, this.rowTimestamp, this.rowNextLink, row, this.isArchived);
        } else {
            this.result = new RowVersion(this.partitionId, this.rowLink, this.rowTimestamp, this.rowNextLink, this.rowValueSize, this.isArchived);
        }
    }

    @Nullable
    RowVersion getResult() {
        return this.result;
    }

    @FunctionalInterface
    static interface RowVersionFilter {
        public boolean apply(long var1, long var3);

        public static RowVersionFilter equalsByTimestamp(@Nullable HybridTimestamp timestamp) {
            return (rowVersionLink, rowVersionAddr) -> {
                HybridTimestamp readTimestamp = HybridTimestamps.readTimestamp(rowVersionAddr, 1);
                return Objects.equals(timestamp, readTimestamp);
            };
        }

        public static RowVersionFilter equalsByNextLink(long nextLink) {
            return (rowVersionLink, rowVersionAddr) -> {
                long readNextLink = PartitionlessLinks.readPartitionless(PageIdUtils.partitionIdFromLink(rowVersionLink), rowVersionAddr, 9);
                return readNextLink == nextLink;
            };
        }
    }
}

