/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import com.google.auto.service.AutoService;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.ignite3.internal.components.LogSyncer;
import org.apache.ignite3.internal.components.LongJvmPauseDetector;
import org.apache.ignite3.internal.configuration.ConfigurationRegistry;
import org.apache.ignite3.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite3.internal.configuration.SystemLocalExtensionConfiguration;
import org.apache.ignite3.internal.failure.FailureManager;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.storage.DataStorageModule;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite3.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite3.internal.storage.engine.StorageEngine;
import org.apache.ignite3.internal.storage.pagememory.EncryptionSupportingPageMemoryStorageEngine;
import org.apache.ignite3.internal.vault.VaultManager;
import org.gridgain.internal.encryption.EncryptionManager;
import org.jetbrains.annotations.Nullable;

@AutoService(value={DataStorageModule.class})
public class PersistentPageMemoryDataStorageModule
implements DataStorageModule {
    @Override
    public String name() {
        return "aipersist";
    }

    @Override
    public StorageEngine createEngine(String igniteInstanceName, MetricManager metricManager, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, VaultManager vaultManager, EncryptionManager encryptionManager, LogSyncer logSyncer, HybridClock clock, ScheduledExecutorService commonScheduler) throws StorageException {
        StorageConfiguration storageConfig = configRegistry.getConfiguration(StorageExtensionConfiguration.KEY).storage();
        SystemLocalConfiguration systemLocalConfig = configRegistry.getConfiguration(SystemLocalExtensionConfiguration.KEY).system();
        PageIoRegistry ioRegistry = new PageIoRegistry();
        ioRegistry.loadFromServiceLoader();
        return new EncryptionSupportingPageMemoryStorageEngine(igniteInstanceName, metricManager, storageConfig, systemLocalConfig, ioRegistry, storagePath, longJvmPauseDetector, failureManager, vaultManager, encryptionManager, logSyncer, commonScheduler, clock);
    }
}

