/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.rbac;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Litmus;
import org.gridgain.internal.rbac.privileges.ActionAlias;

public class GridgainSqlPrivileges
extends SqlCall {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("Privilege", SqlKind.OTHER);
    private final ActionAlias alias;
    private final SqlNodeList actions;
    private final SqlIdentifier object;

    public GridgainSqlPrivileges(SqlParserPos pos, ActionAlias alias, SqlNodeList actions, SqlIdentifier object) {
        super(pos);
        this.alias = alias;
        this.actions = actions;
        this.object = object;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.actions, (Object)this.object);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new GridgainSqlPrivileges(pos, this.alias, this.actions, this.object);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.alias != null) {
            writer.keyword(this.alias.name());
        } else {
            this.actions.unparse(writer, leftPrec, rightPrec);
        }
        if (this.object != null) {
            writer.keyword("ON");
            this.object.unparse(writer, leftPrec, rightPrec);
        }
    }

    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof GridgainSqlPrivileges)) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        GridgainSqlPrivileges that = (GridgainSqlPrivileges)node;
        if (!Objects.equals((Object)this.alias, (Object)that.alias)) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        if (!Objects.equals(this.actions, that.actions)) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        if (!Objects.equals(this.object, that.object)) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        return litmus.succeed();
    }

    public ActionAlias alias() {
        return this.alias;
    }

    public SqlNodeList actions() {
        return this.actions;
    }

    public SqlIdentifier object() {
        return this.object;
    }
}

