/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.AggAddContext;
import org.apache.calcite.adapter.enumerable.AggContext;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.AggResetContext;
import org.apache.calcite.adapter.enumerable.AggResultContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.StrictAggImplementor;
import org.apache.calcite.adapter.enumerable.StrictWinAggImplementor;
import org.apache.calcite.adapter.enumerable.TableFunctionCallImplementor;
import org.apache.calcite.adapter.enumerable.WinAggAddContext;
import org.apache.calcite.adapter.enumerable.WinAggContext;
import org.apache.calcite.adapter.enumerable.WinAggImplementor;
import org.apache.calcite.adapter.enumerable.WinAggResultContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.OptimizeShuttle;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowExclusion;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionContext;
import org.apache.calcite.schema.ImplementableAggFunction;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTypeConstructorFunction;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlItemOperator;
import org.apache.calcite.sql.fun.SqlJsonArrayAggAggFunction;
import org.apache.calcite.sql.fun.SqlJsonObjectAggAggFunction;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.Util;
import org.apache.ignite3.internal.sql.engine.exec.exp.CallImplementor;
import org.apache.ignite3.internal.sql.engine.exec.exp.ConverterUtils;
import org.apache.ignite3.internal.sql.engine.exec.exp.IgniteExpressions;
import org.apache.ignite3.internal.sql.engine.exec.exp.ImplementableFunction;
import org.apache.ignite3.internal.sql.engine.exec.exp.MatchImplementor;
import org.apache.ignite3.internal.sql.engine.exec.exp.NotNullImplementor;
import org.apache.ignite3.internal.sql.engine.exec.exp.ReflectiveCallNotNullImplementor;
import org.apache.ignite3.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite3.internal.sql.engine.sql.fun.GridgainSqlOperatorTable;
import org.apache.ignite3.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite3.internal.sql.engine.util.GridgainMethod;
import org.apache.ignite3.internal.sql.engine.util.IgniteMethod;
import org.jetbrains.annotations.Nullable;

public class RexImpTable {
    public static final RexImpTable INSTANCE;
    public static final ConstantExpression NULL_EXPR;
    public static final ConstantExpression FALSE_EXPR;
    public static final ConstantExpression TRUE_EXPR;
    public static final ConstantExpression COMMA_EXPR;
    public static final ConstantExpression COLON_EXPR;
    public static final MemberExpression BOXED_FALSE_EXPR;
    public static final MemberExpression BOXED_TRUE_EXPR;
    private final ImmutableMap<SqlOperator, PairList<SqlOperator, RexCallImplementor>> map;
    private final ImmutableMap<SqlAggFunction, Supplier<? extends AggImplementor>> aggMap;
    private final ImmutableMap<SqlAggFunction, Supplier<? extends WinAggImplementor>> winAggMap;
    private final ImmutableMap<SqlMatchFunction, Supplier<? extends MatchImplementor>> matchMap;
    private final ImmutableMap<SqlOperator, Supplier<? extends TableFunctionCallImplementor>> tvfImplementorMap;

    private RexImpTable(Builder builder) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        builder.map.forEach((k, v) -> mapBuilder.put(k, (Object)v.immutable()));
        this.map = ImmutableMap.copyOf((Map)mapBuilder.build());
        this.aggMap = ImmutableMap.copyOf(builder.aggMap);
        this.winAggMap = ImmutableMap.copyOf(builder.winAggMap);
        this.matchMap = ImmutableMap.copyOf(builder.matchMap);
        this.tvfImplementorMap = ImmutableMap.copyOf(builder.tvfImplementorMap);
    }

    public static CallImplementor createImplementor(NotNullImplementor implementor, NullPolicy nullPolicy, boolean harmonize) {
        return (translator, call, nullAs) -> {
            RexCallImplementor rexCallImplementor = RexImpTable.createRexCallImplementor(implementor, nullPolicy, harmonize);
            List<RexToLixTranslator.Result> arguments = translator.getCallOperandResult(call);
            RexToLixTranslator.Result result = rexCallImplementor.implement(translator, call, arguments);
            return nullAs.handle((Expression)result.valueVariable);
        };
    }

    private static RexCallImplementor createRexCallImplementor(final NotNullImplementor implementor, NullPolicy nullPolicy, boolean harmonize) {
        return new AbstractRexCallImplementor("not_null_udf", nullPolicy, harmonize){

            @Override
            Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
                return implementor.implement(translator, call, argValueList);
            }
        };
    }

    private static RexCallImplementor wrapAsRexCallImplementor(final CallImplementor implementor) {
        return new AbstractRexCallImplementor("udf", NullPolicy.NONE, false){

            @Override
            Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
                return implementor.implement(translator, call, NullAs.NULL);
            }
        };
    }

    @Nullable
    public RexCallImplementor get(SqlOperator operator) {
        if (operator instanceof SqlUserDefinedFunction) {
            Function udf = ((SqlUserDefinedFunction)operator).getFunction();
            if (!(udf instanceof ImplementableFunction)) {
                throw new IllegalStateException("User defined function " + operator + " must implement ImplementableFunction");
            }
            CallImplementor implementor = ((ImplementableFunction)udf).getImplementor();
            return RexImpTable.wrapAsRexCallImplementor(implementor);
        }
        if (operator instanceof SqlTypeConstructorFunction) {
            PairList implementors = (PairList)this.map.get((Object)SqlStdOperatorTable.ROW);
            if (implementors != null && implementors.size() == 1) {
                return (RexCallImplementor)((Map.Entry)implementors.get(0)).getValue();
            }
        } else {
            PairList implementors = (PairList)this.map.get((Object)operator);
            if (implementors != null) {
                if (implementors.size() == 1) {
                    return (RexCallImplementor)((Map.Entry)implementors.get(0)).getValue();
                }
                for (Map.Entry entry : implementors) {
                    if (operator != entry.getKey()) continue;
                    return (RexCallImplementor)entry.getValue();
                }
            }
        }
        return null;
    }

    @Nullable
    public AggImplementor get(SqlAggFunction aggregation, boolean forWindowAggregate) {
        Supplier winAgg;
        if (aggregation instanceof SqlUserDefinedAggFunction) {
            SqlUserDefinedAggFunction udaf = (SqlUserDefinedAggFunction)aggregation;
            if (!(udaf.function instanceof ImplementableAggFunction)) {
                throw new IllegalStateException("User defined aggregation " + aggregation + " must implement ImplementableAggFunction");
            }
            return ((ImplementableAggFunction)udaf.function).getImplementor(forWindowAggregate);
        }
        if (forWindowAggregate && (winAgg = (Supplier)this.winAggMap.get((Object)aggregation)) != null) {
            return (AggImplementor)winAgg.get();
        }
        Supplier aggSupplier = (Supplier)this.aggMap.get((Object)aggregation);
        if (aggSupplier == null) {
            return null;
        }
        return (AggImplementor)aggSupplier.get();
    }

    public MatchImplementor get(SqlMatchFunction function) {
        Supplier supplier = (Supplier)this.matchMap.get((Object)function);
        if (supplier != null) {
            return (MatchImplementor)supplier.get();
        }
        throw new IllegalStateException("Supplier should not be null");
    }

    public TableFunctionCallImplementor get(SqlWindowTableFunction operator) {
        Supplier supplier = (Supplier)this.tvfImplementorMap.get((Object)operator);
        if (supplier != null) {
            return (TableFunctionCallImplementor)supplier.get();
        }
        throw new IllegalStateException("Supplier should not be null");
    }

    static Expression optimize(Expression expression) {
        return expression.accept((Shuttle)new OptimizeShuttle());
    }

    static Expression optimize2(Expression operand, Expression expression) {
        if (Primitive.is((Type)operand.getType())) {
            return RexImpTable.optimize(expression);
        }
        return RexImpTable.optimize(Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)NULL_EXPR), (Expression)NULL_EXPR, (Expression)expression));
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        SqlTypeName typeName;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (typeName = type.getSqlTypeName()) != SqlTypeName.OTHER) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), type.isNullable());
        }
        return type;
    }

    private static <E> boolean allSame(List<E> list) {
        Object prev = null;
        for (E e : list) {
            if (prev != null && !prev.equals(e)) {
                return false;
            }
            prev = e;
        }
        return true;
    }

    static Expression getDefaultValue(Type type) {
        Primitive p = Primitive.of((Type)type);
        if (p != null) {
            return Expressions.constant((Object)p.defaultValue, (Type)type);
        }
        return Expressions.constant(null, (Type)type);
    }

    public static Expression multiplyDivide(Expression e, BigDecimal multiplier, BigDecimal divider) {
        if (multiplier.equals(BigDecimal.ONE)) {
            if (divider.equals(BigDecimal.ONE)) {
                return e;
            }
            return Expressions.divide((Expression)e, (Expression)Expressions.constant((Object)divider.intValueExact()));
        }
        BigDecimal x = multiplier.divide(divider, RoundingMode.UNNECESSARY);
        switch (x.compareTo(BigDecimal.ONE)) {
            case 0: {
                return e;
            }
            case 1: {
                return Expressions.multiply((Expression)e, (Expression)Expressions.constant((Object)x.intValueExact()));
            }
            case -1: {
                return RexImpTable.multiplyDivide(e, BigDecimal.ONE, x);
            }
        }
        throw new AssertionError();
    }

    private static Expression mod(Expression operand, long factor, boolean floorMod) {
        if (factor == 1L) {
            return operand;
        }
        if (floorMod) {
            return Expressions.call((Method)BuiltInMethod.FLOOR_MOD.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)factor)});
        }
        return Expressions.modulo((Expression)operand, (Expression)Expressions.constant((Object)factor));
    }

    private static long getFactor(TimeUnit unit) {
        switch (unit) {
            case DAY: {
                return 1L;
            }
            case HOUR: {
                return TimeUnit.DAY.multiplier.longValue();
            }
            case MINUTE: {
                return TimeUnit.HOUR.multiplier.longValue();
            }
            case SECOND: {
                return TimeUnit.MINUTE.multiplier.longValue();
            }
            case MILLISECOND: {
                return TimeUnit.SECOND.multiplier.longValue();
            }
            case MONTH: {
                return TimeUnit.YEAR.multiplier.longValue();
            }
            case QUARTER: {
                return TimeUnit.YEAR.multiplier.longValue();
            }
            case MILLENNIUM: 
            case CENTURY: 
            case YEAR: 
            case DECADE: {
                return 1L;
            }
        }
        throw Util.unexpected((Enum)unit);
    }

    static {
        Builder builder = new Builder();
        builder.populate1();
        builder.populate2();
        builder.populate3();
        builder.populateIgnite();
        INSTANCE = new RexImpTable(builder);
        NULL_EXPR = Expressions.constant(null);
        FALSE_EXPR = Expressions.constant((Object)false);
        TRUE_EXPR = Expressions.constant((Object)true);
        COMMA_EXPR = Expressions.constant((Object)",");
        COLON_EXPR = Expressions.constant((Object)":");
        BOXED_FALSE_EXPR = Expressions.field(null, Boolean.class, (String)"FALSE");
        BOXED_TRUE_EXPR = Expressions.field(null, Boolean.class, (String)"TRUE");
    }

    private static class Builder
    extends AbstractBuilder {
        private final Map<SqlOperator, PairList<SqlOperator, RexCallImplementor>> map = new HashMap<SqlOperator, PairList<SqlOperator, RexCallImplementor>>();
        private final Map<SqlAggFunction, Supplier<? extends AggImplementor>> aggMap = new HashMap<SqlAggFunction, Supplier<? extends AggImplementor>>();
        private final Map<SqlAggFunction, Supplier<? extends WinAggImplementor>> winAggMap = new HashMap<SqlAggFunction, Supplier<? extends WinAggImplementor>>();
        private final Map<SqlMatchFunction, Supplier<? extends MatchImplementor>> matchMap = new HashMap<SqlMatchFunction, Supplier<? extends MatchImplementor>>();
        private final Map<SqlOperator, Supplier<? extends TableFunctionCallImplementor>> tvfImplementorMap = new HashMap<SqlOperator, Supplier<? extends TableFunctionCallImplementor>>();

        private Builder() {
        }

        @Override
        protected RexCallImplementor get(SqlOperator operator) {
            PairList<SqlOperator, RexCallImplementor> implementors = Objects.requireNonNull(this.map.get(operator));
            if (implementors.size() == 1) {
                return (RexCallImplementor)((Map.Entry)implementors.get(0)).getValue();
            }
            for (Map.Entry entry : implementors) {
                if (operator != entry.getKey()) continue;
                return (RexCallImplementor)entry.getValue();
            }
            throw new NullPointerException();
        }

        <T extends RexCallImplementor> T define(SqlOperator operator, T implementor) {
            if (this.map.containsKey(operator)) {
                this.map.get(operator).add((Object)operator, implementor);
            } else {
                this.map.put(operator, (PairList<SqlOperator, RexCallImplementor>)PairList.of((Object)operator, implementor));
            }
            return implementor;
        }

        @Override
        void defineAgg(SqlAggFunction operator, Supplier<? extends AggImplementor> implementorSupplier) {
            this.aggMap.put(operator, implementorSupplier);
        }

        @Override
        protected void defineWinAgg(SqlAggFunction operator, Supplier<? extends WinAggImplementor> implementorSupplier) {
            this.winAggMap.put(operator, implementorSupplier);
        }

        @Override
        protected void defineMatch(SqlMatchFunction operator, Supplier<? extends MatchImplementor> implementorSupplier) {
            this.matchMap.put(operator, implementorSupplier);
        }

        @Override
        protected void defineTvf(SqlFunction operator, Supplier<? extends TableFunctionCallImplementor> implementorSupplier) {
            this.tvfImplementorMap.put((SqlOperator)operator, implementorSupplier);
        }
    }

    public static interface RexCallImplementor {
        public RexToLixTranslator.Result implement(RexToLixTranslator var1, RexCall var2, List<RexToLixTranslator.Result> var3);
    }

    public static enum NullAs {
        NULL,
        FALSE,
        TRUE,
        NOT_POSSIBLE,
        IS_NULL,
        IS_NOT_NULL;


        public static NullAs of(boolean nullable) {
            return nullable ? NULL : NOT_POSSIBLE;
        }

        public Expression handle(Expression x) {
            switch (Primitive.flavor((Type)x.getType())) {
                case PRIMITIVE: {
                    switch (this) {
                        case NULL: 
                        case NOT_POSSIBLE: 
                        case FALSE: 
                        case TRUE: {
                            return x;
                        }
                        case IS_NULL: {
                            return FALSE_EXPR;
                        }
                        case IS_NOT_NULL: {
                            return TRUE_EXPR;
                        }
                    }
                    throw new AssertionError();
                }
                case BOX: {
                    switch (this) {
                        case NOT_POSSIBLE: {
                            return EnumUtils.convert((Expression)x, (Type)Primitive.unbox((Type)x.getType()));
                        }
                    }
                    break;
                }
            }
            switch (this) {
                case NULL: 
                case NOT_POSSIBLE: {
                    return x;
                }
                case FALSE: {
                    return Expressions.call((Method)BuiltInMethod.IS_TRUE.method, (Expression[])new Expression[]{x});
                }
                case TRUE: {
                    return Expressions.call((Method)BuiltInMethod.IS_NOT_FALSE.method, (Expression[])new Expression[]{x});
                }
                case IS_NULL: {
                    return Expressions.equal((Expression)x, (Expression)NULL_EXPR);
                }
                case IS_NOT_NULL: {
                    return Expressions.notEqual((Expression)x, (Expression)NULL_EXPR);
                }
            }
            throw new AssertionError();
        }
    }

    private static class ReplaceImplementor
    extends AbstractRexCallImplementor {
        ReplaceImplementor() {
            super("replace", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            boolean isCaseSensitive = translator.conformance != SqlConformanceEnum.SQL_SERVER_2008;
            Expression operand0 = argValueList.get(0);
            Expression operand1 = argValueList.get(1);
            Expression operand2 = argValueList.get(2);
            return Expressions.call((Method)BuiltInMethod.REPLACE.method, (Expression[])new Expression[]{operand0, operand1, operand2, Expressions.constant((Object)isCaseSensitive)});
        }
    }

    private static class DefaultImplementor
    extends AbstractRexCallImplementor {
        DefaultImplementor() {
            super("default", NullPolicy.NONE, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.constant(null);
        }
    }

    private static class IsTrueImplementor
    extends AbstractRexCallImplementor {
        IsTrueImplementor() {
            super("is_true", NullPolicy.STRICT, false);
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)false, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal((Expression)argValueList.get(0), (Expression)TRUE_EXPR);
        }
    }

    private static class IsNullImplementor
    extends AbstractRexCallImplementor {
        IsNullImplementor() {
            super("is_null", NullPolicy.STRICT, false);
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)true, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal((Expression)argValueList.get(0), (Expression)NULL_EXPR);
        }
    }

    private static class IsNotTrueImplementor
    extends AbstractRexCallImplementor {
        IsNotTrueImplementor() {
            super("is_not_true", NullPolicy.STRICT, false);
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)true, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual((Expression)argValueList.get(0), (Expression)TRUE_EXPR);
        }
    }

    private static class IsNotNullImplementor
    extends AbstractRexCallImplementor {
        IsNotNullImplementor() {
            super("is_not_null", NullPolicy.STRICT, false);
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)false, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual((Expression)argValueList.get(0), (Expression)NULL_EXPR);
        }
    }

    private static class IsNotFalseImplementor
    extends AbstractRexCallImplementor {
        IsNotFalseImplementor() {
            super("is_not_false", NullPolicy.STRICT, false);
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)true, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual((Expression)argValueList.get(0), (Expression)FALSE_EXPR);
        }
    }

    private static class IsFalseImplementor
    extends AbstractRexCallImplementor {
        IsFalseImplementor() {
            super("is_false", NullPolicy.STRICT, false);
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)false, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal((Expression)argValueList.get(0), (Expression)FALSE_EXPR);
        }
    }

    private static class PiImplementor
    extends AbstractRexCallImplementor {
        PiImplementor() {
            super("pi", NullPolicy.NONE, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.constant((Object)Math.PI);
        }
    }

    private static class ReflectiveImplementor
    extends AbstractRexCallImplementor {
        protected final ImmutableList<? extends Method> methods;

        ReflectiveImplementor(List<? extends Method> methods) {
            super("reflective_" + methods.get(0).getName(), NullPolicy.STRICT, false);
            this.methods = ImmutableList.copyOf(methods);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            for (Method method : this.methods) {
                if (method.getParameterCount() != argValueList.size()) continue;
                return this.implementSafe(method, argValueList);
            }
            throw new IllegalArgumentException("no matching method");
        }

        protected MethodCallExpression implementSafe(Method method, List<Expression> argValueList) {
            List<Expression> argValueList0 = ConverterUtils.fromInternal(method.getParameterTypes(), argValueList);
            if (ReflectUtil.isStatic((Member)method)) {
                return Expressions.call((Method)method, argValueList0);
            }
            NewExpression target = Expressions.new_(method.getDeclaringClass());
            return Expressions.call((Expression)target, (Method)method, argValueList0);
        }
    }

    private static class TranslateImplementor
    extends AbstractRexCallImplementor {
        TranslateImplementor() {
            super("translate", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            RexNode arg0 = (RexNode)call.getOperands().get(0);
            if (SqlTypeUtil.isNull((RelDataType)arg0.getType())) {
                return argValueList.get(0);
            }
            return Expressions.call((Method)BuiltInMethod.TRANSLATE_WITH_CHARSET.method, argValueList);
        }
    }

    private static class ConvertImplementor
    extends AbstractRexCallImplementor {
        ConvertImplementor() {
            super("convert", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            RexNode arg0 = (RexNode)call.getOperands().get(0);
            if (SqlTypeUtil.isNull((RelDataType)arg0.getType())) {
                return argValueList.get(0);
            }
            return Expressions.call((Method)BuiltInMethod.CONVERT.method, argValueList);
        }
    }

    private static class LogImplementor
    extends AbstractRexCallImplementor {
        private final SqlLibrary library;

        LogImplementor(@Nullable SqlLibrary library) {
            super("log", NullPolicy.STRICT, true);
            this.library = library;
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            if ("LOG10".equals(call.getOperator().getName())) {
                return Expressions.call((Method)IgniteMethod.LOG10.method(), argValueList);
            }
            return Expressions.call((Method)IgniteMethod.LOG.method(), LogImplementor.args(call, argValueList));
        }

        private static List<Expression> args(RexCall call, List<Expression> argValueList) {
            Expression operand0 = argValueList.get(0);
            Expressions.FluentList list = Expressions.list((Object[])new Expression[]{operand0});
            switch (call.getOperator().getName()) {
                case "LOG": {
                    if (argValueList.size() == 2) {
                        return list.append((Object)argValueList.get(1));
                    }
                }
                case "LN": {
                    return list.append((Object)Expressions.constant((Object)Math.exp(1.0)));
                }
            }
            throw new AssertionError((Object)("Operator not found: " + call.getOperator()));
        }
    }

    private static class LogicalNotImplementor
    extends AbstractRexCallImplementor {
        LogicalNotImplementor() {
            super("logical_not", NullPolicy.NONE, true);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.call((Method)BuiltInMethod.NOT.method, argValueList);
        }
    }

    private static class LogicalOrImplementor
    extends AbstractRexCallImplementor {
        LogicalOrImplementor() {
            super("logical_or", NullPolicy.NONE, true);
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<ParameterExpression> argIsNullList = new ArrayList<ParameterExpression>();
            for (RexToLixTranslator.Result result2 : arguments) {
                argIsNullList.add(result2.isNullVariable);
            }
            List nullAsFalse = arguments.stream().map(result -> Expressions.condition((Expression)result.isNullVariable, (Expression)FALSE_EXPR, (Expression)result.valueVariable)).collect(Collectors.toList());
            Expression hasTrue = Expressions.foldOr(nullAsFalse);
            Expression hasNull = Expressions.foldOr(argIsNullList);
            Expression callExpression = Expressions.condition((Expression)hasTrue, (Expression)BOXED_TRUE_EXPR, (Expression)Expressions.condition((Expression)hasNull, (Expression)NULL_EXPR, (Expression)BOXED_FALSE_EXPR));
            NullAs nullAs = translator.isNullable((RexNode)call) ? NullAs.NULL : NullAs.NOT_POSSIBLE;
            Expression valueExpression = nullAs.handle(callExpression);
            ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)translator.getBlockBuilder().newName(this.variableName + "_value"));
            Expression isNullExpression = translator.checkNull(valueExpression);
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)translator.getBlockBuilder().newName(this.variableName + "_isNull"));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            throw new IllegalStateException("This implementSafe should not be called, please call implement(...)");
        }
    }

    private static class LogicalAndImplementor
    extends AbstractRexCallImplementor {
        LogicalAndImplementor() {
            super("logical_and", NullPolicy.NONE, true);
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<ParameterExpression> argIsNullList = new ArrayList<ParameterExpression>();
            for (RexToLixTranslator.Result result2 : arguments) {
                argIsNullList.add(result2.isNullVariable);
            }
            List nullAsTrue = arguments.stream().map(result -> Expressions.condition((Expression)result.isNullVariable, (Expression)TRUE_EXPR, (Expression)result.valueVariable)).collect(Collectors.toList());
            UnaryExpression hasFalse = Expressions.not((Expression)Expressions.foldAnd(nullAsTrue));
            Expression hasNull = Expressions.foldOr(argIsNullList);
            Expression callExpression = Expressions.condition((Expression)hasFalse, (Expression)BOXED_FALSE_EXPR, (Expression)Expressions.condition((Expression)hasNull, (Expression)NULL_EXPR, (Expression)BOXED_TRUE_EXPR));
            NullAs nullAs = translator.isNullable((RexNode)call) ? NullAs.NULL : NullAs.NOT_POSSIBLE;
            Expression valueExpression = nullAs.handle(callExpression);
            ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)translator.getBlockBuilder().newName(this.variableName + "_value"));
            Expression isNullExpression = translator.checkNull((Expression)valueVariable);
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)translator.getBlockBuilder().newName(this.variableName + "_isNull"));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            throw new IllegalStateException("This implementSafe should not be called, please call implement(...)");
        }
    }

    private static abstract class AbstractRexCallImplementor
    implements RexCallImplementor {
        final String variableName;
        final NullPolicy nullPolicy;
        final boolean harmonize;

        AbstractRexCallImplementor(String variableName, NullPolicy nullPolicy, boolean harmonize) {
            this.variableName = Objects.requireNonNull(variableName, "variableName");
            this.nullPolicy = Objects.requireNonNull(nullPolicy, "nullPolicy");
            this.harmonize = harmonize;
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<Expression> argIsNullList = new ArrayList<Expression>();
            ArrayList<Expression> argValueList = new ArrayList<Expression>();
            for (RexToLixTranslator.Result result : arguments) {
                argIsNullList.add((Expression)result.isNullVariable);
                argValueList.add((Expression)result.valueVariable);
            }
            Expression condition = this.getCondition(argIsNullList);
            ParameterExpression valueVariable = this.genValueStatement(translator, call, argValueList, condition);
            ParameterExpression isNullVariable = this.genIsNullStatement(translator, valueVariable);
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        Expression getCondition(List<Expression> argIsNullList) {
            if (argIsNullList.isEmpty() || this.nullPolicy == NullPolicy.NONE) {
                return FALSE_EXPR;
            }
            if (this.nullPolicy == NullPolicy.ARG0) {
                return argIsNullList.get(0);
            }
            if (this.nullPolicy == NullPolicy.ALL) {
                return Expressions.foldAnd(argIsNullList);
            }
            return Expressions.foldOr(argIsNullList);
        }

        private ParameterExpression genValueStatement(RexToLixTranslator translator, RexCall call, List<Expression> argValueList, Expression condition) {
            boolean noConvert;
            List<Expression> optimizedArgValueList = argValueList;
            if (this.harmonize) {
                optimizedArgValueList = AbstractRexCallImplementor.harmonize(optimizedArgValueList, translator, call);
            }
            optimizedArgValueList = this.unboxIfNecessary(optimizedArgValueList);
            Expression callValue = this.implementSafe(translator, call, optimizedArgValueList);
            SqlOperator op = call.getOperator();
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            Objects.requireNonNull(returnType, "returnType");
            boolean bl = noConvert = returnType == callValue.getType() || op instanceof SqlUserDefinedTableMacro || op instanceof SqlUserDefinedTableFunction;
            Object convertedCallValue = returnType == Void.class ? NULL_EXPR : (noConvert ? callValue : ConverterUtils.convert(callValue, call.getType()));
            Expression valueExpression = Expressions.condition((Expression)condition, (Expression)this.getIfTrue(convertedCallValue.getType(), argValueList), (Expression)convertedCallValue);
            ParameterExpression value = Expressions.parameter((Type)convertedCallValue.getType(), (String)translator.getBlockBuilder().newName(this.variableName + "_value"));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)value, (Expression)valueExpression));
            return value;
        }

        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return RexImpTable.getDefaultValue(type);
        }

        protected final ParameterExpression genIsNullStatement(RexToLixTranslator translator, ParameterExpression value) {
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)translator.getBlockBuilder().newName(this.variableName + "_isNull"));
            Expression isNullExpression = translator.checkNull((Expression)value);
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
            return isNullVariable;
        }

        private static List<Expression> harmonize(List<Expression> argValueList, RexToLixTranslator translator, RexCall call) {
            int nullCount = 0;
            ArrayList<RelDataType> types = new ArrayList<RelDataType>();
            RelDataTypeFactory typeFactory = translator.builder.getTypeFactory();
            for (RexNode operand : call.getOperands()) {
                RelDataType type = operand.getType();
                type = RexImpTable.toSql(typeFactory, type);
                if (translator.isNullable(operand)) {
                    ++nullCount;
                } else {
                    type = typeFactory.createTypeWithNullability(type, false);
                }
                types.add(type);
            }
            if (RexImpTable.allSame(types)) {
                return argValueList;
            }
            RelDataType type = typeFactory.leastRestrictive(types);
            if (type == null) {
                return argValueList;
            }
            assert (nullCount > 0 == type.isNullable());
            Type javaClass = translator.typeFactory.getJavaClass(type);
            ArrayList<Expression> harmonizedArgValues = new ArrayList<Expression>();
            for (Expression argValue : argValueList) {
                harmonizedArgValues.add(EnumUtils.convert((Expression)argValue, (Type)javaClass));
            }
            return harmonizedArgValues;
        }

        private List<Expression> unboxIfNecessary(List<Expression> argValueList) {
            switch (this.nullPolicy) {
                case STRICT: 
                case ANY: 
                case SEMI_STRICT: {
                    return Util.transform(argValueList, AbstractRexCallImplementor::unboxExpression);
                }
                case ARG0: {
                    if (argValueList.isEmpty()) break;
                    Expression unboxArg0 = AbstractRexCallImplementor.unboxExpression(argValueList.get(0));
                    argValueList.set(0, unboxArg0);
                }
            }
            return argValueList;
        }

        private static Expression unboxExpression(Expression argValue) {
            Primitive fromBox = Primitive.ofBox((Type)argValue.getType());
            if (fromBox == null || fromBox == Primitive.VOID) {
                return argValue;
            }
            if (argValue instanceof MethodCallExpression) {
                MethodCallExpression mce = (MethodCallExpression)argValue;
                if (mce.method.getName().equals("valueOf") && mce.expressions.size() == 1) {
                    Expression originArg = (Expression)mce.expressions.get(0);
                    if (Primitive.of((Type)originArg.type) == fromBox) {
                        return originArg;
                    }
                }
            }
            return NullAs.NOT_POSSIBLE.handle(argValue);
        }

        abstract Expression implementSafe(RexToLixTranslator var1, RexCall var2, List<Expression> var3);
    }

    private static class ClassifierImplementor
    implements MatchImplementor {
        private ClassifierImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, ParameterExpression row, ParameterExpression rows, ParameterExpression symbols, ParameterExpression i) {
            return EnumUtils.convert((Expression)Expressions.call((Expression)symbols, (Method)BuiltInMethod.LIST_GET.method, (Expression[])new Expression[]{i}), String.class);
        }
    }

    private static class DatetimeArithmeticImplementor
    extends AbstractRexCallImplementor {
        DatetimeArithmeticImplementor() {
            super("dateTime_arithmetic", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            RexNode operand0 = (RexNode)call.getOperands().get(0);
            Expression trop0 = argValueList.get(0);
            SqlTypeName typeName1 = ((RexNode)call.getOperands().get(1)).getType().getSqlTypeName();
            Expression trop1 = argValueList.get(1);
            SqlTypeName typeName = call.getType().getSqlTypeName();
            block0 : switch (operand0.getType().getSqlTypeName()) {
                case DATE: {
                    switch (typeName) {
                        case TIMESTAMP: 
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            trop0 = Expressions.convert_((Expression)IgniteExpressions.multiplyExact(trop0, (Expression)Expressions.constant((Object)86400000L)), Long.TYPE);
                            break block0;
                        }
                    }
                    switch (typeName1) {
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            trop1 = Expressions.convert_((Expression)IgniteExpressions.divideExact(trop1, (Expression)Expressions.constant((Object)86400000L)), Integer.TYPE);
                            break block0;
                        }
                    }
                    break;
                }
                case TIME: {
                    trop1 = DatetimeArithmeticImplementor.normalize(typeName, trop1);
                    trop1 = Expressions.convert_((Expression)trop1, Integer.TYPE);
                    break;
                }
            }
            switch (typeName1) {
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    switch (call.getKind()) {
                        case MINUS: {
                            trop1 = IgniteExpressions.makeUnary(ExpressionType.Negate, trop1);
                            break;
                        }
                    }
                    switch (typeName) {
                        case TIME: {
                            return Expressions.convert_((Expression)trop0, Long.TYPE);
                        }
                    }
                    BuiltInMethod method = operand0.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP || operand0.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE ? BuiltInMethod.ADD_MONTHS : BuiltInMethod.ADD_MONTHS_INT;
                    return IgniteExpressions.addBoundsCheckIfNeeded(typeName, (Expression)Expressions.call((Method)method.method, (Expression[])new Expression[]{trop0, trop1}));
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    switch (call.getKind()) {
                        case MINUS: {
                            return DatetimeArithmeticImplementor.normalize(typeName, IgniteExpressions.addBoundsCheckIfNeeded(typeName, IgniteExpressions.subtractExact(trop0, trop1)));
                        }
                    }
                    return DatetimeArithmeticImplementor.normalize(typeName, IgniteExpressions.addBoundsCheckIfNeeded(typeName, IgniteExpressions.addExact(trop0, trop1)));
                }
            }
            switch (call.getKind()) {
                case MINUS: {
                    switch (typeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: {
                            return Expressions.call((Method)BuiltInMethod.SUBTRACT_MONTHS.method, (Expression[])new Expression[]{trop0, trop1});
                        }
                    }
                    TimeUnit fromUnit = typeName1 == SqlTypeName.DATE ? TimeUnit.DAY : TimeUnit.MILLISECOND;
                    TimeUnit toUnit = TimeUnit.MILLISECOND;
                    return RexImpTable.multiplyDivide((Expression)Expressions.convert_((Expression)IgniteExpressions.subtractExact(trop0, trop1), Long.TYPE), fromUnit.multiplier, toUnit.multiplier);
                }
            }
            throw new AssertionError(call);
        }

        private static Expression normalize(SqlTypeName typeName, Expression e) {
            switch (typeName) {
                case TIME: {
                    return Expressions.call((Method)BuiltInMethod.FLOOR_MOD.method, (Expression[])new Expression[]{e, Expressions.constant((Object)86400000L)});
                }
            }
            return e;
        }
    }

    private static class NotJsonImplementor
    extends AbstractRexCallImplementor {
        private final AbstractRexCallImplementor implementor;

        private NotJsonImplementor(AbstractRexCallImplementor implementor) {
            super("not_json", implementor.nullPolicy, false);
            this.implementor = implementor;
        }

        static AbstractRexCallImplementor of(AbstractRexCallImplementor implementor) {
            return new NotJsonImplementor(implementor);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression expression = this.implementor.implementSafe(translator, call, argValueList);
            ParameterExpression callValue = Expressions.parameter((Type)expression.getType());
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)callValue, (Expression)expression));
            Expression valueExpression = Expressions.condition((Expression)Expressions.equal((Expression)callValue, (Expression)NULL_EXPR), (Expression)NULL_EXPR, (Expression)Expressions.not((Expression)callValue));
            ParameterExpression resultValue = Expressions.parameter((Type)expression.getType());
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)resultValue, (Expression)valueExpression));
            return resultValue;
        }
    }

    private static class NotImplementor
    extends AbstractRexCallImplementor {
        private final AbstractRexCallImplementor implementor;

        private NotImplementor(AbstractRexCallImplementor implementor) {
            super("not", implementor.nullPolicy, false);
            this.implementor = implementor;
        }

        static AbstractRexCallImplementor of(AbstractRexCallImplementor implementor) {
            return new NotImplementor(implementor);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression expression = this.implementor.implementSafe(translator, call, argValueList);
            return Expressions.not((Expression)expression);
        }
    }

    private static class SystemFunctionImplementor
    extends AbstractRexCallImplementor {
        SystemFunctionImplementor() {
            super("system_func", NullPolicy.NONE, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            SqlOperator op = call.getOperator();
            Expression root = translator.getRoot();
            if (op == SqlStdOperatorTable.CURRENT_USER || op == SqlStdOperatorTable.SESSION_USER || op == SqlStdOperatorTable.USER) {
                return Expressions.call((Method)BuiltInMethod.USER.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.SYSTEM_USER) {
                return Expressions.call((Method)BuiltInMethod.SYSTEM_USER.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.CURRENT_PATH || op == SqlStdOperatorTable.CURRENT_ROLE || op == SqlStdOperatorTable.CURRENT_CATALOG) {
                return Expressions.constant((Object)"");
            }
            if (op == IgniteSqlOperatorTable.CURRENT_TIMESTAMP) {
                return Expressions.call((Method)BuiltInMethod.CURRENT_TIMESTAMP.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.CURRENT_TIME) {
                return Expressions.call((Method)BuiltInMethod.CURRENT_TIME.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlLibraryOperators.CURRENT_DATETIME) {
                if (call.getOperands().isEmpty()) {
                    return Expressions.call((Method)BuiltInMethod.CURRENT_DATETIME.method, (Expression[])new Expression[]{root});
                }
                return Expressions.call((Method)BuiltInMethod.CURRENT_DATETIME2.method, (Expression[])new Expression[]{root, argValueList.get(0)});
            }
            if (op == SqlStdOperatorTable.LOCALTIMESTAMP) {
                return Expressions.call((Method)BuiltInMethod.LOCAL_TIMESTAMP.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.LOCALTIME) {
                return Expressions.call((Method)BuiltInMethod.LOCAL_TIME.method, (Expression[])new Expression[]{root});
            }
            throw new AssertionError((Object)("unknown function " + op));
        }
    }

    private static class ItemImplementor
    extends AbstractRexCallImplementor {
        ItemImplementor() {
            super("item", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            AbstractRexCallImplementor implementor = this.getImplementor(((RexNode)call.getOperands().get(0)).getType().getSqlTypeName());
            return implementor.implementSafe(translator, call, argValueList);
        }

        private AbstractRexCallImplementor getImplementor(SqlTypeName sqlTypeName) {
            switch (sqlTypeName) {
                case VARIANT: {
                    return new MethodImplementor(BuiltInMethod.VARIANT_ITEM.method, this.nullPolicy, false);
                }
                case ARRAY: {
                    return new ArrayItemImplementor();
                }
                case MAP: {
                    return new MethodImplementor(BuiltInMethod.MAP_ITEM.method, this.nullPolicy, false);
                }
            }
            return new MethodImplementor(BuiltInMethod.ANY_ITEM.method, this.nullPolicy, false);
        }
    }

    private static class ArrayItemImplementor
    extends AbstractRexCallImplementor {
        ArrayItemImplementor() {
            super("array_item", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            SqlItemOperator itemOperator = (SqlItemOperator)call.getOperator();
            return Expressions.call((Method)BuiltInMethod.ARRAY_ITEM.method, (Iterable)Expressions.list(argValueList).append((Object)Expressions.constant((Object)itemOperator.offset)).append((Object)Expressions.constant((Object)itemOperator.safe)));
        }
    }

    private static class ValueConstructorImplementor
    extends AbstractRexCallImplementor {
        ValueConstructorImplementor() {
            super("value_constructor", NullPolicy.NONE, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            SqlKind kind = call.getOperator().getKind();
            BlockBuilder blockBuilder = translator.getBlockBuilder();
            switch (kind) {
                case MAP_VALUE_CONSTRUCTOR: {
                    Expression map = blockBuilder.append("map", (Expression)Expressions.new_(LinkedHashMap.class), false);
                    for (int i = 0; i < argValueList.size(); ++i) {
                        Expression key = argValueList.get(i++);
                        Expression value = argValueList.get(i);
                        blockBuilder.add(Expressions.statement((Expression)Expressions.call((Expression)map, (Method)BuiltInMethod.MAP_PUT.method, (Expression[])new Expression[]{Expressions.box((Expression)key), Expressions.box((Expression)value)})));
                    }
                    return map;
                }
                case ARRAY_VALUE_CONSTRUCTOR: {
                    Expression lyst = blockBuilder.append("list", (Expression)Expressions.new_(ArrayList.class), false);
                    for (Expression value : argValueList) {
                        blockBuilder.add(Expressions.statement((Expression)Expressions.call((Expression)lyst, (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{Expressions.box((Expression)value)})));
                    }
                    return lyst;
                }
            }
            throw new AssertionError((Object)("unexpected: " + kind));
        }
    }

    private static class ConcatImplementor
    extends AbstractRexCallImplementor {
        final ArrayConcatImplementor arrayConcatImplementor = new ArrayConcatImplementor();
        final MethodImplementor stringConcatImplementor;

        ConcatImplementor() {
            super("concat", NullPolicy.STRICT, false);
            this.stringConcatImplementor = new MethodImplementor(BuiltInMethod.STRING_CONCAT.method, NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            if (call.type.getSqlTypeName() == SqlTypeName.ARRAY) {
                return this.arrayConcatImplementor.implementSafe(translator, call, argValueList);
            }
            return this.stringConcatImplementor.implementSafe(translator, call, argValueList);
        }
    }

    private static class StringToMapImplementor
    extends AbstractRexCallImplementor {
        StringToMapImplementor() {
            super("str_to_map", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            switch (call.getOperands().size()) {
                case 1: {
                    return Expressions.call((Method)BuiltInMethod.STR_TO_MAP.method, (Expression[])new Expression[]{argValueList.get(0), COMMA_EXPR, COLON_EXPR});
                }
                case 2: {
                    return Expressions.call((Method)BuiltInMethod.STR_TO_MAP.method, (Expression[])new Expression[]{argValueList.get(0), argValueList.get(1), COLON_EXPR});
                }
                case 3: {
                    return Expressions.call((Method)BuiltInMethod.STR_TO_MAP.method, argValueList);
                }
            }
            throw new AssertionError();
        }
    }

    private static class ArrayConcatImplementor
    extends AbstractRexCallImplementor {
        ArrayConcatImplementor() {
            super("array_concat", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            BlockBuilder blockBuilder = translator.getBlockBuilder();
            Expression list = blockBuilder.append("list", (Expression)Expressions.new_(ArrayList.class), false);
            ConstantExpression nullValue = Expressions.constant(null);
            for (Expression expression : argValueList) {
                blockBuilder.add((Statement)Expressions.ifThenElse((Expression)Expressions.orElse((Expression)Expressions.equal((Expression)nullValue, (Expression)list), (Expression)Expressions.equal((Expression)nullValue, (Expression)expression)), (Node)Expressions.statement((Expression)Expressions.assign((Expression)list, (Expression)nullValue)), (Node)Expressions.statement((Expression)Expressions.call((Expression)list, (Method)BuiltInMethod.COLLECTION_ADDALL.method, (Expression[])new Expression[]{expression}))));
            }
            return list;
        }
    }

    private static class SortArrayImplementor
    extends AbstractRexCallImplementor {
        SortArrayImplementor() {
            super("sort_array", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            if (argValueList.size() == 2) {
                return Expressions.call((Method)BuiltInMethod.SORT_ARRAY.method, argValueList);
            }
            return Expressions.call((Method)BuiltInMethod.SORT_ARRAY.method, (Expression[])new Expression[]{argValueList.get(0), Expressions.constant((Object)true)});
        }
    }

    private static class ReinterpretImplementor
    extends AbstractRexCallImplementor {
        ReinterpretImplementor() {
            super("reinterpret", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            assert (call.getOperands().size() == 1);
            return argValueList.get(0);
        }
    }

    private static class CastImplementor
    extends AbstractRexCallImplementor {
        CastImplementor() {
            super("cast", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            ConstantExpression formatExpr;
            assert (call.operandCount() <= 2);
            RelDataType sourceType = ((RexNode)call.getOperands().get(0)).getType();
            RexNode arg = (RexNode)call.getOperands().get(0);
            if (call.operandCount() == 2) {
                RexLiteral format = (RexLiteral)translator.deref((RexNode)call.getOperands().get(1));
                formatExpr = (ConstantExpression)RexToLixTranslator.translateLiteral(format, format.getType(), translator.typeFactory, NullAs.NULL);
            } else {
                formatExpr = NULL_EXPR;
            }
            if (call.getType().equals(sourceType)) {
                return argValueList.get(0);
            }
            if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)translator.typeFactory, (RelDataType)call.getType(), (RelDataType)arg.getType()) && translator.deref(arg) instanceof RexLiteral) {
                return RexToLixTranslator.translateLiteral((RexLiteral)translator.deref(arg), call.getType(), translator.typeFactory, NullAs.NULL);
            }
            RelDataType targetType = CastImplementor.nullifyType(translator.typeFactory, call.getType(), false);
            boolean safe = call.getKind() == SqlKind.SAFE_CAST;
            return translator.translateCast(sourceType, targetType, argValueList.get(0), safe, formatExpr);
        }

        private static RelDataType nullifyType(JavaTypeFactory typeFactory, RelDataType type, boolean nullable) {
            Class javaClass;
            Class primitive;
            if (type instanceof RelDataTypeFactoryImpl.JavaType && (primitive = Primitive.unbox((Class)(javaClass = ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass()))) != javaClass) {
                return typeFactory.createJavaType(primitive);
            }
            return typeFactory.createTypeWithNullability(type, nullable);
        }
    }

    private static class CoalesceImplementor
    extends AbstractRexCallImplementor {
        CoalesceImplementor() {
            super("coalesce", NullPolicy.NONE, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return CoalesceImplementor.implementRecurse(translator, argValueList);
        }

        private static Expression implementRecurse(RexToLixTranslator translator, List<Expression> argValueList) {
            if (argValueList.size() == 1) {
                return argValueList.get(0);
            }
            return Expressions.condition((Expression)translator.checkNotNull(argValueList.get(0)), (Expression)argValueList.get(0), (Expression)CoalesceImplementor.implementRecurse(translator, Util.skip(argValueList)));
        }
    }

    private static class ExtractImplementor
    extends AbstractRexCallImplementor {
        ExtractImplementor() {
            super("extract", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Object timeUnitRangeObj = translator.getLiteralValue(argValueList.get(0));
            TimeUnitRange timeUnitRange = timeUnitRangeObj instanceof String ? TimeUnitRange.of((TimeUnit)SqlIntervalQualifier.stringToDatePartTimeUnit((String)((String)timeUnitRangeObj)), null) : (TimeUnitRange)timeUnitRangeObj;
            TimeUnit unit = Objects.requireNonNull(timeUnitRange, (String)"timeUnitRange").startUnit;
            Expression operand = argValueList.get(1);
            boolean isIntervalType = SqlTypeUtil.isInterval((RelDataType)((RexNode)call.operands.get(1)).getType());
            SqlTypeName sqlTypeName = ((RexNode)call.operands.get(1)).getType().getSqlTypeName();
            block0 : switch (unit) {
                case MILLENNIUM: 
                case CENTURY: 
                case YEAR: 
                case QUARTER: 
                case MONTH: 
                case DAY: 
                case DOW: 
                case DECADE: 
                case DOY: 
                case ISODOW: 
                case ISOYEAR: 
                case WEEK: {
                    switch (sqlTypeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            break block0;
                        }
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                        }
                        case TIMESTAMP: 
                        case TIMESTAMP_TZ: {
                            operand = Expressions.call((Method)BuiltInMethod.FLOOR_DIV.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)TimeUnit.DAY.multiplier.longValue())});
                        }
                        case DATE: {
                            return Expressions.call((Method)BuiltInMethod.UNIX_DATE_EXTRACT.method, (Expression[])new Expression[]{argValueList.get(0), operand});
                        }
                    }
                    throw new AssertionError((Object)("unexpected " + sqlTypeName));
                }
                case MILLISECOND: 
                case MICROSECOND: 
                case NANOSECOND: {
                    if (sqlTypeName == SqlTypeName.DATE || SqlTypeName.YEAR_INTERVAL_TYPES.contains(sqlTypeName)) {
                        return Expressions.constant((Object)0L);
                    }
                    operand = RexImpTable.mod(operand, TimeUnit.MINUTE.multiplier.longValue(), !isIntervalType);
                    return Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)((long)(1.0 / unit.multiplier.doubleValue()))));
                }
                case EPOCH: {
                    switch (sqlTypeName) {
                        case DATE: {
                            operand = Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.DAY.multiplier.longValue()));
                        }
                        case TIMESTAMP: 
                        case TIMESTAMP_TZ: {
                            return Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                            return Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            return Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: {
                            throw new AssertionError((Object)("unexpected " + sqlTypeName));
                        }
                    }
                    break;
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    switch (sqlTypeName) {
                        case DATE: {
                            return Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)0L));
                        }
                    }
                }
            }
            operand = RexImpTable.mod(operand, RexImpTable.getFactor(unit), unit == TimeUnit.QUARTER || !isIntervalType);
            if (unit == TimeUnit.QUARTER) {
                operand = Expressions.subtract((Expression)operand, (Expression)Expressions.constant((Object)1L));
            }
            operand = Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)unit.multiplier.longValue()));
            if (unit == TimeUnit.QUARTER) {
                operand = Expressions.add((Expression)operand, (Expression)Expressions.constant((Object)1L));
            }
            return operand;
        }
    }

    private static class UnaryImplementor
    extends AbstractRexCallImplementor {
        final ExpressionType expressionType;
        @Nullable
        final String backupMethodName;

        UnaryImplementor(ExpressionType expressionType, NullPolicy nullPolicy, @Nullable String backupMethodName) {
            super("unary_call", nullPolicy, false);
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression argValue = argValueList.get(0);
            Object e = this.expressionType == ExpressionType.Negate && argValue.type == BigDecimal.class && null != this.backupMethodName ? Expressions.call((Expression)argValue, (String)this.backupMethodName, (Expression[])new Expression[0]) : (this.expressionType == ExpressionType.NegateChecked && null != this.backupMethodName ? Expressions.call(SqlFunctions.class, (String)this.backupMethodName, argValueList) : IgniteExpressions.makeUnary(this.expressionType, argValue));
            if (e.type.equals(argValue.type)) {
                return e;
            }
            return Expressions.convert_((Expression)e, (Type)argValue.type);
        }
    }

    private static class BinaryImplementor
    extends AbstractRexCallImplementor {
        private static final List<Primitive> COMP_OP_TYPES = ImmutableList.of((Object)Primitive.BYTE, (Object)Primitive.CHAR, (Object)Primitive.SHORT, (Object)Primitive.INT, (Object)Primitive.LONG, (Object)Primitive.FLOAT, (Object)Primitive.DOUBLE);
        private static final List<SqlBinaryOperator> COMPARISON_OPERATORS = ImmutableList.of((Object)SqlStdOperatorTable.LESS_THAN, (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.GREATER_THAN, (Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        private static final List<SqlOperator> CHECKED_OPERATORS = ImmutableList.of((Object)SqlStdOperatorTable.CHECKED_DIVIDE, (Object)SqlStdOperatorTable.CHECKED_PLUS, (Object)SqlStdOperatorTable.CHECKED_MINUS, (Object)SqlStdOperatorTable.CHECKED_MULTIPLY, (Object)SqlStdOperatorTable.CHECKED_UNARY_MINUS);
        private static final List<SqlBinaryOperator> EQUALS_OPERATORS = ImmutableList.of((Object)SqlStdOperatorTable.EQUALS, (Object)SqlStdOperatorTable.NOT_EQUALS);
        public static final String METHOD_POSTFIX_FOR_ANY_TYPE = "Any";
        private final ExpressionType expressionType;
        private final String backupMethodName;

        BinaryImplementor(NullPolicy nullPolicy, boolean harmonize, ExpressionType expressionType, String backupMethodName) {
            super("binary_call", nullPolicy, harmonize);
            this.expressionType = expressionType;
            this.backupMethodName = Objects.requireNonNull(backupMethodName, "backupMethodName");
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            if (BinaryImplementor.anyAnyOperands(call)) {
                return this.callBackupMethodAnyType(argValueList);
            }
            Type type0 = argValueList.get(0).getType();
            Type type1 = argValueList.get(1).getType();
            SqlBinaryOperator op = (SqlBinaryOperator)call.getOperator();
            RelDataType relDataType0 = ((RexNode)call.getOperands().get(0)).getType();
            Expression fieldComparator = EnumUtils.generateCollatorExpression((SqlCollation)relDataType0.getCollation());
            if (fieldComparator != null) {
                argValueList = FlatLists.append(argValueList, (Object)fieldComparator);
            }
            if (type0 == BigDecimal.class && type1 == BigDecimal.class && op == IgniteSqlOperatorTable.DIVIDE) {
                int precision = call.getType().getPrecision();
                int scale = call.getType().getScale();
                assert (precision != -1 || scale != Integer.MIN_VALUE) : "No precision/scale for decimal division. Return type: " + call.getType() + " operands: " + call.getOperands().stream().map(RexNode::getType).collect(Collectors.toList());
                return IgniteExpressions.makeDecimalDivision((Expression)argValueList.get(0), (Expression)argValueList.get(1), precision, scale);
            }
            Primitive primitive = Primitive.ofBoxOr((Type)type0);
            if (primitive == null || type1 == BigDecimal.class || COMPARISON_OPERATORS.contains(op) && !COMP_OP_TYPES.contains(primitive)) {
                return Expressions.call(SqlFunctions.class, (String)this.backupMethodName, (Iterable)argValueList);
            }
            Primitive boxPrimitive0 = Primitive.ofBox((Type)type0);
            Primitive boxPrimitive1 = Primitive.ofBox((Type)type1);
            if (EQUALS_OPERATORS.contains(op) && boxPrimitive0 != null && boxPrimitive1 != null) {
                return Expressions.call(SqlFunctions.class, (String)this.backupMethodName, (Iterable)argValueList);
            }
            if (CHECKED_OPERATORS.contains(op)) {
                return Expressions.call(SqlFunctions.class, (String)this.backupMethodName, (Iterable)argValueList);
            }
            return IgniteExpressions.makeBinary(this.expressionType, (Expression)argValueList.get(0), (Expression)argValueList.get(1));
        }

        private static boolean anyAnyOperands(RexCall call) {
            for (RexNode operand : call.operands) {
                if (operand.getType().getSqlTypeName() != SqlTypeName.ANY && operand.getType().getSqlTypeName() != SqlTypeName.UUID) continue;
                return true;
            }
            return false;
        }

        private Expression callBackupMethodAnyType(List<Expression> expressions) {
            String backupMethodNameForAnyType = this.backupMethodName + METHOD_POSTFIX_FOR_ANY_TYPE;
            Expression expression0 = BinaryImplementor.maybeBox(expressions.get(0));
            Expression expression1 = BinaryImplementor.maybeBox(expressions.get(1));
            return Expressions.call(SqlFunctions.class, (String)backupMethodNameForAnyType, (Expression[])new Expression[]{expression0, expression1});
        }

        private static Expression maybeBox(Expression expression) {
            Primitive primitive = Primitive.of((Type)expression.getType());
            if (primitive != null) {
                expression = Expressions.box((Expression)expression, (Primitive)primitive);
            }
            return expression;
        }
    }

    private static class JsonQueryImplementor
    extends MethodImplementor {
        JsonQueryImplementor(Method method) {
            super(method, NullPolicy.ARG0, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            ArrayList<Expression> newOperands = new ArrayList<Expression>(argValueList);
            ConstantExpression jsonize = SqlTypeUtil.inCharFamily((RelDataType)call.getType()) ? TRUE_EXPR : FALSE_EXPR;
            newOperands.add((Expression)jsonize);
            List<Expression> argValueList0 = ConverterUtils.fromInternal(this.method.getParameterTypes(), newOperands);
            NewExpression target = Expressions.new_(this.method.getDeclaringClass());
            return Expressions.call((Expression)target, (Method)this.method, argValueList0);
        }
    }

    private static class JsonValueImplementor
    extends MethodImplementor {
        JsonValueImplementor(Method method) {
            super(method, NullPolicy.ARG0, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            ArrayList<Expression> newOperands = new ArrayList<Expression>();
            newOperands.add(argValueList.get(0));
            newOperands.add(argValueList.get(1));
            List leftExprs = Util.skip(argValueList, (int)2);
            ConstantExpression emptyBehavior = Expressions.constant((Object)SqlJsonValueEmptyOrErrorBehavior.NULL);
            ConstantExpression defaultValueOnEmpty = Expressions.constant(null);
            ConstantExpression errorBehavior = Expressions.constant((Object)SqlJsonValueEmptyOrErrorBehavior.NULL);
            ConstantExpression defaultValueOnError = Expressions.constant(null);
            if (!leftExprs.isEmpty()) {
                for (int i = 0; i < leftExprs.size(); ++i) {
                    Expression expr = (Expression)leftExprs.get(i);
                    Object exprVal = translator.getLiteralValue(expr);
                    if (exprVal == null) continue;
                    int defaultSymbolIdx = i - 2;
                    if (exprVal == SqlJsonEmptyOrError.EMPTY) {
                        if (defaultSymbolIdx >= 0 && translator.getLiteralValue((Expression)leftExprs.get(defaultSymbolIdx)) == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
                            defaultValueOnEmpty = (Expression)leftExprs.get(i - 1);
                            emptyBehavior = (Expression)leftExprs.get(defaultSymbolIdx);
                            continue;
                        }
                        emptyBehavior = (Expression)leftExprs.get(i - 1);
                        continue;
                    }
                    if (exprVal != SqlJsonEmptyOrError.ERROR) continue;
                    if (defaultSymbolIdx >= 0 && translator.getLiteralValue((Expression)leftExprs.get(defaultSymbolIdx)) == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
                        defaultValueOnError = (Expression)leftExprs.get(i - 1);
                        errorBehavior = (Expression)leftExprs.get(defaultSymbolIdx);
                        continue;
                    }
                    errorBehavior = (Expression)leftExprs.get(i - 1);
                }
            }
            newOperands.add((Expression)emptyBehavior);
            newOperands.add((Expression)defaultValueOnEmpty);
            newOperands.add((Expression)errorBehavior);
            newOperands.add((Expression)defaultValueOnError);
            List<Expression> argValueList0 = ConverterUtils.fromInternal(this.method.getParameterTypes(), newOperands);
            NewExpression target = Expressions.new_(this.method.getDeclaringClass());
            return Expressions.call((Expression)target, (Method)this.method, argValueList0);
        }
    }

    private static class MethodImplementor
    extends AbstractRexCallImplementor {
        protected final Method method;

        MethodImplementor(String variableName, Method method, NullPolicy nullPolicy, boolean harmonize) {
            super(variableName, nullPolicy, harmonize);
            this.method = method;
        }

        MethodImplementor(Method method, NullPolicy nullPolicy, boolean harmonize) {
            this("method_call", method, nullPolicy, harmonize);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            if (ReflectUtil.isStatic((Member)this.method)) {
                return MethodImplementor.call(this.method, null, argValueList);
            }
            return MethodImplementor.call(this.method, argValueList.get(0), Util.skip(argValueList, (int)1));
        }

        static Expression call(Method method, @Nullable Expression target, List<Expression> args) {
            if (method.isVarArgs()) {
                int last = method.getParameterCount() - 1;
                ImmutableList vargs = ImmutableList.builder().addAll(args.subList(0, last)).add((Object)Expressions.newArrayInit(method.getParameterTypes()[last], (Expression[])args.subList(last, args.size()).toArray(new Expression[0]))).build();
                return Expressions.call((Expression)target, (Method)method, (Iterable)vargs);
            }
            Class<?> clazz = method.getDeclaringClass();
            return EnumUtils.call((Expression)target, clazz, (String)method.getName(), args);
        }
    }

    private static class FormatDatetimeImplementor
    extends ReflectiveImplementor {
        FormatDatetimeImplementor() {
            super((List<? extends Method>)ImmutableList.of((Object)BuiltInMethod.FORMAT_DATE.method, (Object)BuiltInMethod.FORMAT_TIME.method, (Object)BuiltInMethod.FORMAT_TIMESTAMP.method));
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Method method;
            Expression operand0 = argValueList.get(0);
            Expression operand1 = argValueList.get(1);
            switch (((RexNode)call.operands.get(1)).getType().getSqlTypeName()) {
                case TIME: {
                    method = BuiltInMethod.FORMAT_TIME.method;
                    break;
                }
                case DATE: {
                    method = BuiltInMethod.FORMAT_DATE.method;
                    break;
                }
                default: {
                    method = BuiltInMethod.FORMAT_TIMESTAMP.method;
                }
            }
            return this.implementSafe(method, (List<Expression>)ImmutableList.of((Object)operand0, (Object)operand1));
        }
    }

    private static class TimestampDiffImplementor
    extends AbstractRexCallImplementor {
        final Method customTimestampMethod;
        final Method customDateMethod;

        TimestampDiffImplementor(Method customTimestampMethod, Method customDateMethod) {
            super("timestampDiff", NullPolicy.STRICT, false);
            this.customTimestampMethod = customTimestampMethod;
            this.customDateMethod = customDateMethod;
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.call((Method)this.getMethod(call), (Expression[])new Expression[]{translator.getRoot(), argValueList.get(0), argValueList.get(1), argValueList.get(2)});
        }

        private Method getMethod(RexCall call) {
            switch (((RexNode)call.operands.get(1)).getType().getSqlTypeName()) {
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case TIMESTAMP_TZ: {
                    return this.customTimestampMethod;
                }
            }
            return this.customDateMethod;
        }
    }

    private static class TimestampAddImplementor
    extends AbstractRexCallImplementor {
        final Method customTimestampMethod;
        final Method customDateMethod;

        TimestampAddImplementor(Method customTimestampMethod, Method customDateMethod) {
            super("timestampAdd", NullPolicy.STRICT, false);
            this.customTimestampMethod = customTimestampMethod;
            this.customDateMethod = customDateMethod;
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression operand0 = argValueList.get(0);
            Expression operand1 = argValueList.get(1);
            Expression operand2 = argValueList.get(2);
            switch (call.getType().getSqlTypeName()) {
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case TIMESTAMP_TZ: {
                    return Expressions.call((Method)this.customTimestampMethod, (Expression[])new Expression[]{translator.getRoot(), operand0, operand1, operand2});
                }
            }
            return Expressions.call((Method)this.customDateMethod, (Expression[])new Expression[]{translator.getRoot(), operand0, operand1, operand2});
        }
    }

    private static class FloorImplementor
    extends MethodImplementor {
        final Method timestampMethod;
        final Method dateMethod;
        final Method customTimestampMethod;
        final Method customDateMethod;

        FloorImplementor(Method method, Method timestampMethod, Method dateMethod, Method customTimestampMethod, Method customDateMethod) {
            super(method, NullPolicy.STRICT, false);
            this.timestampMethod = timestampMethod;
            this.dateMethod = dateMethod;
            this.customTimestampMethod = customTimestampMethod;
            this.customDateMethod = customDateMethod;
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            switch (call.getOperands().size()) {
                case 1: {
                    switch (call.getType().getSqlTypeName()) {
                        case BIGINT: 
                        case INTEGER: 
                        case SMALLINT: 
                        case TINYINT: {
                            return argValueList.get(0);
                        }
                    }
                    return super.implementSafe(translator, call, argValueList);
                }
                case 2: {
                    boolean preFloor;
                    Method floorMethod;
                    Class<Number> type;
                    Expression operand1 = argValueList.get(1);
                    boolean custom = operand1.getType() == String.class;
                    Expression operand0 = argValueList.get(0);
                    switch (call.getType().getSqlTypeName()) {
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand0 = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand0, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                        }
                        case TIMESTAMP: 
                        case TIMESTAMP_TZ: {
                            type = Long.TYPE;
                            floorMethod = custom ? this.customTimestampMethod : this.timestampMethod;
                            preFloor = true;
                            break;
                        }
                        default: {
                            type = Integer.TYPE;
                            floorMethod = custom ? this.customDateMethod : this.dateMethod;
                            preFloor = false;
                        }
                    }
                    if (custom) {
                        return Expressions.call((Method)floorMethod, (Expression[])new Expression[]{translator.getRoot(), operand1, operand0});
                    }
                    TimeUnitRange timeUnitRange = (TimeUnitRange)Objects.requireNonNull(translator.getLiteralValue(operand1), "timeUnitRange");
                    switch (timeUnitRange) {
                        case YEAR: 
                        case ISOYEAR: 
                        case QUARTER: 
                        case MONTH: 
                        case WEEK: 
                        case DAY: 
                        case DECADE: 
                        case CENTURY: 
                        case MILLENNIUM: {
                            Expression dayOperand0 = preFloor ? this.call(operand0, type, TimeUnit.DAY) : operand0;
                            return Expressions.call((Method)floorMethod, (Expression[])new Expression[]{translator.getLiteral(operand1), dayOperand0});
                        }
                    }
                    if (call.op.getKind() == SqlKind.DATE_TRUNC) {
                        throw new IllegalArgumentException("Time unit " + timeUnitRange + " not supported for " + call.op.getName());
                    }
                    return this.call(operand0, type, timeUnitRange.startUnit);
                }
            }
            throw new AssertionError((Object)(call.op.getName() + " only supported with 1 or 2 arguments"));
        }

        private Expression call(Expression operand, Type type, TimeUnit timeUnit) {
            if (timeUnit.multiplier.compareTo(BigDecimal.ONE) < 0) {
                return EnumUtils.convert((Expression)operand, (Type)type);
            }
            return Expressions.call(this.method.getDeclaringClass(), (String)this.method.getName(), (Expression[])new Expression[]{EnumUtils.convert((Expression)operand, (Type)type), EnumUtils.convert((Expression)Expressions.constant((Object)timeUnit.multiplier), (Type)type)});
        }
    }

    private static class SafeArithmeticImplementor
    extends MethodImplementor {
        SafeArithmeticImplementor(Method method) {
            super(method, NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            ArrayList<Expression> args = new ArrayList<Expression>();
            args.add(SafeArithmeticImplementor.convertType(argValueList.get(0), (RexNode)call.operands.get(0)));
            if (argValueList.size() == 1) {
                args.add((Expression)Expressions.constant((Object)-1L));
            } else {
                args.add(SafeArithmeticImplementor.convertType(argValueList.get(1), (RexNode)call.operands.get(1)));
            }
            return super.implementSafe(translator, call, args);
        }

        static Expression convertType(Expression arg, RexNode node) {
            if (SqlTypeName.INT_TYPES.contains(node.getType().getSqlTypeName())) {
                return Expressions.convert_((Expression)arg, Long.TYPE);
            }
            return arg;
        }
    }

    private static class LastDayImplementor
    extends AbstractRexCallImplementor {
        private final BuiltInMethod dateMethod;

        LastDayImplementor(String variableName, BuiltInMethod dateMethod) {
            super(variableName, NullPolicy.STRICT, false);
            this.dateMethod = dateMethod;
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression operand = argValueList.get(0);
            RelDataType type = ((RexNode)call.operands.get(0)).getType();
            switch (type.getSqlTypeName()) {
                case TIMESTAMP: {
                    operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_DATE.method, (Expression[])new Expression[]{operand});
                }
                case DATE: {
                    return Expressions.call(this.dateMethod.method.getDeclaringClass(), (String)this.dateMethod.method.getName(), (Expression[])new Expression[]{operand});
                }
            }
            throw new AssertionError((Object)("unknown type " + type));
        }
    }

    private static class PeriodNameImplementor
    extends AbstractRexCallImplementor {
        private final BuiltInMethod timestampMethod;
        private final BuiltInMethod dateMethod;

        PeriodNameImplementor(String variableName, BuiltInMethod timestampMethod, BuiltInMethod dateMethod) {
            super(variableName, NullPolicy.STRICT, false);
            this.timestampMethod = timestampMethod;
            this.dateMethod = dateMethod;
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression operand = argValueList.get(0);
            RelDataType type = ((RexNode)call.operands.get(0)).getType();
            switch (type.getSqlTypeName()) {
                case TIMESTAMP: {
                    return this.getExpression(translator, operand, this.timestampMethod);
                }
                case DATE: {
                    return this.getExpression(translator, operand, this.dateMethod);
                }
            }
            throw new AssertionError((Object)("unknown type " + type));
        }

        protected Expression getExpression(RexToLixTranslator translator, Expression operand, BuiltInMethod builtInMethod) {
            MethodCallExpression locale = Expressions.call((Method)BuiltInMethod.LOCALE.method, (Expression[])new Expression[]{translator.getRoot()});
            return Expressions.call(builtInMethod.method.getDeclaringClass(), (String)builtInMethod.method.getName(), (Expression[])new Expression[]{operand, locale});
        }
    }

    private static class BitCountMySQLImplementor
    extends AbstractRexCallImplementor {
        BitCountMySQLImplementor() {
            super("bitCount", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression expr = argValueList.get(0);
            RelDataType relDataType = ((RexNode)call.getOperands().get(0)).getType();
            if (SqlTypeUtil.isNull((RelDataType)relDataType)) {
                return argValueList.get(0);
            }
            SqlTypeName type = relDataType.getSqlTypeName();
            switch (type) {
                case VARBINARY: 
                case BINARY: {
                    return Expressions.call(SqlFunctions.class, (String)"bitCount", (Expression[])new Expression[]{expr});
                }
                case DATE: {
                    expr = Expressions.call((Method)BuiltInMethod.INTERNAL_TO_DATE.method, (Expression[])new Expression[]{expr});
                    break;
                }
                case TIME: {
                    expr = Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIME.method, (Expression[])new Expression[]{expr});
                    break;
                }
                case TIMESTAMP: {
                    expr = Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIMESTAMP.method, (Expression[])new Expression[]{expr});
                    break;
                }
            }
            return Expressions.call(SqlFunctions.class, (String)"bitCountMySQL", (Expression[])new Expression[]{Expressions.box((Expression)expr)});
        }
    }

    private static class ContainsSubstrImplementor
    extends AbstractRexCallImplementor {
        ContainsSubstrImplementor() {
            super("contains_substr", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            if (argValueList.size() == 3) {
                return Expressions.call(SqlFunctions.class, (String)"containsSubstr", argValueList);
            }
            Expression expr = argValueList.get(0);
            SqlTypeName type = ((RexNode)call.getOperands().get(0)).getType().getSqlTypeName();
            switch (type) {
                case DATE: {
                    expr = Expressions.call((Method)BuiltInMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{expr});
                    break;
                }
                case TIME: {
                    expr = Expressions.call((Method)BuiltInMethod.UNIX_TIME_TO_STRING.method, (Expression[])new Expression[]{expr});
                    break;
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case TIMESTAMP_TZ: {
                    expr = Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{expr});
                    break;
                }
            }
            return Expressions.call(SqlFunctions.class, (String)"containsSubstr", (Expression[])new Expression[]{expr, argValueList.get(1)});
        }
    }

    private static class TrimImplementor
    extends AbstractRexCallImplementor {
        TrimImplementor() {
            super("trim", NullPolicy.STRICT, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            boolean strict = !translator.conformance.allowExtendedTrim();
            Object value = translator.getLiteralValue(argValueList.get(0));
            SqlTrimFunction.Flag flag = (SqlTrimFunction.Flag)value;
            return Expressions.call((Method)BuiltInMethod.TRIM.method, (Expression[])new Expression[]{Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.LEADING ? 1 : 0)), Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.TRAILING ? 1 : 0)), argValueList.get(1), argValueList.get(2), Expressions.constant((Object)strict)});
        }
    }

    static class JsonArrayAggImplementor
    implements AggImplementor {
        private final Method m;

        JsonArrayAggImplementor(Method m) {
            this.m = m;
        }

        static Supplier<JsonArrayAggImplementor> supplierFor(Method m) {
            return () -> new JsonArrayAggImplementor(m);
        }

        public List<Type> getStateType(AggContext info) {
            return Collections.singletonList(List.class);
        }

        public void implementReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)Expressions.new_(ArrayList.class))));
        }

        public void implementAdd(AggContext info, AggAddContext add) {
            SqlJsonArrayAggAggFunction function = (SqlJsonArrayAggAggFunction)info.aggregation();
            add.currentBlock().add(Expressions.statement((Expression)Expressions.call((Method)this.m, (Iterable)Iterables.concat(Collections.singletonList((Expression)add.accumulator().get(0)), (Iterable)add.arguments(), Collections.singletonList(Expressions.constant((Object)function.getNullClause()))))));
        }

        public Expression implementResult(AggContext info, AggResultContext result) {
            return Expressions.call((Method)BuiltInMethod.JSONIZE.method, (Expression[])new Expression[]{(Expression)result.accumulator().get(0)});
        }
    }

    static class JsonObjectAggImplementor
    implements AggImplementor {
        private final Method m;

        JsonObjectAggImplementor(Method m) {
            this.m = m;
        }

        static Supplier<JsonObjectAggImplementor> supplierFor(Method m) {
            return () -> new JsonObjectAggImplementor(m);
        }

        public List<Type> getStateType(AggContext info) {
            return Collections.singletonList(Map.class);
        }

        public void implementReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)Expressions.new_(HashMap.class))));
        }

        public void implementAdd(AggContext info, AggAddContext add) {
            SqlJsonObjectAggAggFunction function = (SqlJsonObjectAggAggFunction)info.aggregation();
            add.currentBlock().add(Expressions.statement((Expression)Expressions.call((Method)this.m, (Iterable)Iterables.concat(Collections.singletonList((Expression)add.accumulator().get(0)), (Iterable)add.arguments(), Collections.singletonList(Expressions.constant((Object)function.getNullClause()))))));
        }

        public Expression implementResult(AggContext info, AggResultContext result) {
            return Expressions.call((Method)BuiltInMethod.JSONIZE.method, (Expression[])new Expression[]{(Expression)result.accumulator().get(0)});
        }
    }

    static class RowNumberImplementor
    extends StrictWinAggImplementor {
        RowNumberImplementor() {
        }

        public List<Type> getNotNullState(WinAggContext info) {
            return Collections.emptyList();
        }

        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
        }

        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add((Expression)Expressions.subtract((Expression)result.index(), (Expression)result.startIndex()), (Expression)Expressions.constant((Object)1));
        }
    }

    static class DenseRankImplementor
    extends RankImplementor {
        DenseRankImplementor() {
        }

        @Override
        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            return Expressions.add((Expression)acc, (Expression)Expressions.constant((Object)1));
        }
    }

    static class RankImplementor
    extends StrictWinAggImplementor {
        RankImplementor() {
        }

        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            Expression acc = (Expression)add.accumulator().get(0);
            BlockBuilder builder = add.nestBlock();
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)Expressions.lessThan((Expression)add.compareRows((Expression)Expressions.subtract((Expression)add.currentPosition(), (Expression)Expressions.constant((Object)1)), add.currentPosition()), (Expression)Expressions.constant((Object)0)), (Node)Expressions.statement((Expression)Expressions.assign((Expression)acc, (Expression)this.computeNewRank(acc, add)))));
            add.exitBlock();
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)Expressions.greaterThan((Expression)add.currentPosition(), (Expression)add.startIndex()), (Node)builder.toBlock()));
        }

        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            Expression pos = add.currentPosition();
            if (!add.startIndex().equals((Object)Expressions.constant((Object)0))) {
                pos = Expressions.subtract((Expression)pos, (Expression)add.startIndex());
            }
            return pos;
        }

        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add((Expression)super.implementNotNullResult(info, result), (Expression)Expressions.constant((Object)1));
        }
    }

    public static class UserDefinedAggReflectiveImplementor
    extends StrictAggImplementor {
        private final AggregateFunctionImpl afi;

        public UserDefinedAggReflectiveImplementor(AggregateFunctionImpl afi) {
            this.afi = afi;
        }

        public List<Type> getNotNullState(AggContext info) {
            if (this.afi.isStatic) {
                return Collections.singletonList(this.afi.accumulatorType);
            }
            return Arrays.asList(this.afi.accumulatorType, this.afi.declaringClass);
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            List acc = reset.accumulator();
            if (!this.afi.isStatic) {
                reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)acc.get(1)), (Expression)UserDefinedAggReflectiveImplementor.makeNew(this.afi))));
            }
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)acc.get(0)), (Expression)Expressions.call((Expression)(this.afi.isStatic ? null : (Expression)acc.get(1)), (Method)this.afi.initMethod, (Expression[])new Expression[0]))));
        }

        private static NewExpression makeNew(AggregateFunctionImpl afi) {
            try {
                Constructor constructor = afi.declaringClass.getConstructor(new Class[0]);
                Objects.requireNonNull(constructor, "constructor");
                return Expressions.new_((Type)afi.declaringClass);
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor constructor2 = afi.declaringClass.getConstructor(FunctionContext.class);
                    Objects.requireNonNull(constructor2, "constructor");
                    return Expressions.new_((Type)afi.declaringClass, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.FUNCTION_CONTEXTS_OF.method, (Expression[])new Expression[]{DataContext.ROOT, Expressions.newArrayBounds(Object.class, (int)1, (Expression)Expressions.constant((Object)afi.getParameters().size()))})});
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)("no valid constructor for " + afi));
                }
            }
        }

        protected void implementNotNullAdd(AggContext info, AggAddContext add) {
            List acc = add.accumulator();
            List aggArgs = add.arguments();
            ArrayList<Expression> args = new ArrayList<Expression>(aggArgs.size() + 1);
            args.add((Expression)acc.get(0));
            args.addAll(aggArgs);
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)acc.get(0)), (Expression)Expressions.call((Expression)(this.afi.isStatic ? null : (Expression)acc.get(1)), (Method)this.afi.addMethod, args))));
        }

        protected Expression implementNotNullResult(AggContext info, AggResultContext result) {
            List acc = result.accumulator();
            return Expressions.call((Expression)(this.afi.isStatic ? null : (Expression)acc.get(1)), (Method)Objects.requireNonNull(this.afi.resultMethod, () -> "resultMethod is null. Does " + this.afi.declaringClass + " declare result method?"), (Expression[])new Expression[]{(Expression)acc.get(0)});
        }
    }

    static class LiteralAggImplementor
    implements AggImplementor {
        LiteralAggImplementor() {
        }

        public List<Type> getStateType(AggContext info) {
            return ImmutableList.of();
        }

        public void implementReset(AggContext info, AggResetContext reset) {
        }

        public void implementAdd(AggContext info, AggAddContext add) {
        }

        public Expression implementResult(AggContext info, AggResultContext result) {
            throw new IllegalStateException("LiteralAggImplementor not implemented");
        }
    }

    static class GroupingImplementor
    implements AggImplementor {
        GroupingImplementor() {
        }

        public List<Type> getStateType(AggContext info) {
            return ImmutableList.of();
        }

        public void implementReset(AggContext info, AggResetContext reset) {
        }

        public void implementAdd(AggContext info, AggAddContext add) {
        }

        public Expression implementResult(AggContext info, AggResultContext result) {
            List keys;
            switch (info.aggregation().kind) {
                case GROUPING: {
                    keys = result.call().getArgList();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Object e = null;
            if (info.groupSets().size() > 1) {
                List keyOrdinals = info.keyOrdinals();
                long x = 1L << keys.size() - 1;
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    int k = (Integer)iterator.next();
                    int i = keyOrdinals.indexOf(k);
                    assert (i >= 0);
                    Expression e2 = Expressions.condition((Expression)result.keyField(keyOrdinals.size() + i), (Expression)Expressions.constant((Object)x), (Expression)Expressions.constant((Object)0L));
                    e = e == null ? e2 : Expressions.add((Expression)e, (Expression)e2);
                    x >>= 1;
                }
            }
            return e != null ? e : Expressions.constant((Object)0, (Type)info.returnType());
        }
    }

    static class BitOpImplementor
    extends StrictAggImplementor {
        BitOpImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            MemberExpression start;
            if (SqlTypeUtil.isBinary((RelDataType)info.returnRelType())) {
                start = Expressions.field(null, ByteString.class, (String)"EMPTY");
            } else {
                Long initValue = info.aggregation().kind == SqlKind.BIT_AND ? -1L : 0L;
                start = Expressions.constant((Object)initValue, (Type)info.returnType());
            }
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)start)));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            BuiltInMethod builtInMethod;
            Expression acc = (Expression)add.accumulator().get(0);
            Expression arg = (Expression)add.arguments().get(0);
            SqlAggFunction aggregation = info.aggregation();
            switch (aggregation.kind) {
                case BIT_AND: {
                    builtInMethod = BuiltInMethod.BIT_AND;
                    break;
                }
                case BIT_OR: {
                    builtInMethod = BuiltInMethod.BIT_OR;
                    break;
                }
                case BIT_XOR: {
                    builtInMethod = BuiltInMethod.BIT_XOR;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown " + aggregation.getName() + ". Only support bit_and, bit_or and bit_xor for bit aggregation function");
                }
            }
            Method method = builtInMethod.method;
            MethodCallExpression next = Expressions.call(method.getDeclaringClass(), (String)method.getName(), (Expression[])new Expression[]{acc, Expressions.unbox((Expression)arg)});
            BitOpImplementor.accAdvance((AggAddContext)add, (Expression)acc, (Expression)next);
        }
    }

    static class FusionImplementor
    extends StrictAggImplementor {
        FusionImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)Expressions.new_(ArrayList.class))));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement((Expression)Expressions.call((Expression)((Expression)add.accumulator().get(0)), (Method)BuiltInMethod.COLLECTION_ADDALL.method, (Expression[])new Expression[]{(Expression)add.arguments().get(0)})));
        }
    }

    static class ModeImplementor
    extends StrictAggImplementor {
        ModeImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)Expressions.constant(null))));
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(1)), (Expression)Expressions.new_(HashMap.class))));
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(2)), (Expression)Expressions.constant((Object)0, Long.class))));
        }

        protected void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression currentArg = (Expression)add.arguments().get(0);
            Expression currentResult = (Expression)add.accumulator().get(0);
            Expression accMap = (Expression)add.accumulator().get(1);
            Expression currentMaxNumber = (Expression)add.accumulator().get(2);
            MethodCallExpression getOrDefaultExpression = Expressions.call((Expression)accMap, (Method)BuiltInMethod.MAP_GET_OR_DEFAULT.method, (Expression[])new Expression[]{currentArg, Expressions.constant((Object)0, Long.class)});
            ParameterExpression currentNumber = Expressions.parameter(Long.class, (String)add.currentBlock().newName("currentNumber"));
            add.currentBlock().add((Statement)Expressions.declare((int)0, (ParameterExpression)currentNumber, null));
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)currentNumber, (Expression)Expressions.add((Expression)Expressions.convert_((Expression)getOrDefaultExpression, Long.class), (Expression)Expressions.constant((Object)1, Long.class)))));
            MethodCallExpression methodCallExpression2 = Expressions.call((Expression)accMap, (Method)BuiltInMethod.MAP_PUT.method, (Expression[])new Expression[]{currentArg, currentNumber});
            add.currentBlock().add(Expressions.statement((Expression)methodCallExpression2));
            BlockBuilder thenBlock = new BlockBuilder(true, add.currentBlock());
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)currentMaxNumber, (Expression)Expressions.convert_((Expression)currentNumber, Long.class))));
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)currentResult, (Expression)currentArg)));
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)Expressions.lessThan((Expression)currentMaxNumber, (Expression)currentNumber), (Node)thenBlock.toBlock()));
        }

        protected Expression implementNotNullResult(AggContext info, AggResultContext result) {
            return (Expression)result.accumulator().get(0);
        }

        public List<Type> getNotNullState(AggContext info) {
            ArrayList<Type> types = new ArrayList<Type>();
            types.add((Type)((Object)Object.class));
            types.add((Type)((Object)HashMap.class));
            types.add((Type)((Object)Long.class));
            return types;
        }
    }

    static class IntersectionImplementor
    extends StrictAggImplementor {
        IntersectionImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)Expressions.constant(null))));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            BlockBuilder accumulatorIsNull = new BlockBuilder();
            accumulatorIsNull.add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)add.accumulator().get(0)), (Expression)Expressions.new_(ArrayList.class))));
            accumulatorIsNull.add(Expressions.statement((Expression)Expressions.call((Expression)((Expression)add.accumulator().get(0)), (Method)BuiltInMethod.COLLECTION_ADDALL.method, (Expression[])new Expression[]{(Expression)add.arguments().get(0)})));
            BlockBuilder accumulatorNotNull = new BlockBuilder();
            accumulatorNotNull.add(Expressions.statement((Expression)Expressions.call((Expression)((Expression)add.accumulator().get(0)), (Method)BuiltInMethod.COLLECTION_RETAIN_ALL.method, (Expression[])new Expression[]{(Expression)add.arguments().get(0)})));
            add.currentBlock().add((Statement)Expressions.ifThenElse((Expression)Expressions.equal((Expression)((Expression)add.accumulator().get(0)), (Expression)Expressions.constant(null)), (Node)accumulatorIsNull.toBlock(), (Node)accumulatorNotNull.toBlock()));
        }
    }

    static class ListaggImplementor
    extends StrictAggImplementor {
        ListaggImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)NULL_EXPR)));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression accValue = (Expression)add.accumulator().get(0);
            Expression arg0 = (Expression)add.arguments().get(0);
            ConstantExpression arg1 = add.arguments().size() == 2 ? (Expression)add.arguments().get(1) : COMMA_EXPR;
            Expression result = Expressions.condition((Expression)Expressions.equal((Expression)NULL_EXPR, (Expression)accValue), (Expression)arg0, (Expression)Expressions.call((Method)BuiltInMethod.STRING_CONCAT.method, (Expression[])new Expression[]{accValue, Expressions.call((Method)BuiltInMethod.STRING_CONCAT.method, (Expression[])new Expression[]{arg1, arg0})}));
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)accValue, (Expression)result)));
        }
    }

    static class CollectImplementor
    extends StrictAggImplementor {
        CollectImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)Expressions.new_(ArrayList.class))));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement((Expression)Expressions.call((Expression)((Expression)add.accumulator().get(0)), (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{(Expression)add.arguments().get(0)})));
        }
    }

    static class SingleValueImplementor
    implements AggImplementor {
        SingleValueImplementor() {
        }

        public List<Type> getStateType(AggContext info) {
            return Arrays.asList(Boolean.TYPE, info.returnType());
        }

        public void implementReset(AggContext info, AggResetContext reset) {
            List acc = reset.accumulator();
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)acc.get(0)), (Expression)Expressions.constant((Object)false))));
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)acc.get(1)), (Expression)RexImpTable.getDefaultValue(((Expression)acc.get(1)).getType()))));
        }

        public void implementAdd(AggContext info, AggAddContext add) {
            List acc = add.accumulator();
            Expression flag = (Expression)acc.get(0);
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)flag, (Node)Expressions.throw_((Expression)Expressions.new_(IllegalStateException.class, (Expression[])new Expression[]{Expressions.constant((Object)("more than one value in agg " + info.aggregation()))}))));
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)flag, (Expression)Expressions.constant((Object)true))));
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)acc.get(1)), (Expression)((Expression)add.arguments().get(0)))));
        }

        public Expression implementResult(AggContext info, AggResultContext result) {
            return EnumUtils.convert((Expression)((Expression)result.accumulator().get(1)), (Type)info.returnType());
        }
    }

    static class ArgMinMaxImplementor
    extends StrictAggImplementor {
        ArgMinMaxImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            boolean isMin;
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)Expressions.constant(null))));
            Type compType = (Type)info.parameterTypes().get(1);
            Primitive p = Primitive.of((Type)compType);
            boolean bl = isMin = info.aggregation().kind == SqlKind.ARG_MIN;
            Object inf = p == null ? null : (isMin ? p.max : p.min);
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(1)), (Expression)Expressions.constant((Object)inf, (Type)compType))));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            boolean isMin;
            Expression accComp = (Expression)add.accumulator().get(1);
            Expression argValue = (Expression)add.arguments().get(0);
            Expression argComp = (Expression)add.arguments().get(1);
            Type compType = (Type)info.parameterTypes().get(1);
            Primitive p = Primitive.of((Type)compType);
            boolean bl = isMin = info.aggregation().kind == SqlKind.ARG_MIN;
            Method method = (isMin ? (p == null ? BuiltInMethod.LT_NULLABLE : BuiltInMethod.LT) : (p == null ? BuiltInMethod.GT_NULLABLE : BuiltInMethod.GT)).method;
            MethodCallExpression compareExpression = Expressions.call(method.getDeclaringClass(), (String)method.getName(), (Expression[])new Expression[]{argComp, accComp});
            BlockBuilder thenBlock = new BlockBuilder(true, add.currentBlock());
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)add.accumulator().get(0)), (Expression)argValue)));
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)add.accumulator().get(1)), (Expression)argComp)));
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)compareExpression, (Node)thenBlock.toBlock()));
        }

        public List<Type> getNotNullState(AggContext info) {
            return ImmutableList.of(Object.class, (Object)((Type)info.parameterTypes().get(1)));
        }
    }

    static class MinMaxImplementor
    extends StrictAggImplementor {
        MinMaxImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            boolean isMin;
            Expression acc = (Expression)reset.accumulator().get(0);
            Primitive p = Primitive.of((Type)acc.getType());
            boolean bl = isMin = info.aggregation().kind == SqlKind.MIN;
            Object inf = p == null ? null : (isMin ? p.max : p.min);
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc, (Expression)Expressions.constant((Object)inf, (Type)acc.getType()))));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression acc = (Expression)add.accumulator().get(0);
            Expression arg = (Expression)add.arguments().get(0);
            boolean isMin = info.aggregation().kind == SqlKind.MIN;
            Method method = (isMin ? BuiltInMethod.LESSER : BuiltInMethod.GREATER).method;
            MethodCallExpression next = Expressions.call(method.getDeclaringClass(), (String)method.getName(), (Expression[])new Expression[]{acc, Expressions.unbox((Expression)arg)});
            MinMaxImplementor.accAdvance((AggAddContext)add, (Expression)acc, (Expression)next);
        }
    }

    static class SumImplementor
    extends StrictAggImplementor {
        SumImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            ConstantExpression start = info.returnType() == BigDecimal.class ? Expressions.constant((Object)BigDecimal.ZERO) : Expressions.constant((Object)0);
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)((Expression)reset.accumulator().get(0)), (Expression)start)));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            BinaryExpression next;
            Expression acc = (Expression)add.accumulator().get(0);
            if (info.returnType() == BigDecimal.class) {
                next = Expressions.call((Expression)acc, (String)"add", (Expression[])new Expression[]{(Expression)add.arguments().get(0)});
            } else {
                Expression arg = EnumUtils.convert((Expression)((Expression)add.arguments().get(0)), (Type)acc.type);
                next = Expressions.add((Expression)acc, (Expression)arg);
            }
            SumImplementor.accAdvance((AggAddContext)add, (Expression)acc, (Expression)next);
        }

        public Expression implementNotNullResult(AggContext info, AggResultContext result) {
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountWinImplementor
    extends StrictWinAggImplementor {
        boolean justFrameRowCount;

        CountWinImplementor() {
        }

        public List<Type> getNotNullState(WinAggContext info) {
            boolean hasNullable = false;
            for (RelDataType type : info.parameterRelTypes()) {
                if (!type.isNullable()) continue;
                hasNullable = true;
                break;
            }
            if (!hasNullable && info.getExclude() == RexWindowExclusion.EXCLUDE_NO_OTHER) {
                this.justFrameRowCount = true;
                return Collections.emptyList();
            }
            return super.getNotNullState(info);
        }

        public void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            if (this.justFrameRowCount) {
                return;
            }
            add.currentBlock().add(Expressions.statement((Expression)Expressions.postIncrementAssign((Expression)((Expression)add.accumulator().get(0)))));
        }

        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            if (this.justFrameRowCount) {
                return result.getFrameRowCount();
            }
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountImplementor
    extends StrictAggImplementor {
        CountImplementor() {
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement((Expression)Expressions.postIncrementAssign((Expression)((Expression)add.accumulator().get(0)))));
        }
    }

    private static abstract class AbstractBuilder {
        private AbstractBuilder() {
        }

        abstract <I extends RexCallImplementor> I define(SqlOperator var1, I var2);

        abstract void defineAgg(SqlAggFunction var1, Supplier<? extends AggImplementor> var2);

        abstract void defineWinAgg(SqlAggFunction var1, Supplier<? extends WinAggImplementor> var2);

        abstract void defineMatch(SqlMatchFunction var1, Supplier<? extends MatchImplementor> var2);

        abstract void defineTvf(SqlFunction var1, Supplier<? extends TableFunctionCallImplementor> var2);

        private MethodImplementor defineMethod(SqlOperator operator, Method method, NullPolicy nullPolicy) {
            return this.define(operator, new MethodImplementor(method, nullPolicy, false));
        }

        private ReflectiveImplementor defineReflective(SqlOperator operator, Method ... methods) {
            ReflectiveImplementor implementor = new ReflectiveImplementor((List<? extends Method>)ImmutableList.copyOf((Object[])methods));
            return this.define(operator, implementor);
        }

        private UnaryImplementor defineUnary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, @Nullable String backupMethodName) {
            return this.define(operator, new UnaryImplementor(expressionType, nullPolicy, backupMethodName));
        }

        private BinaryImplementor defineBinary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
            return this.define(operator, new BinaryImplementor(nullPolicy, true, expressionType, backupMethodName));
        }

        private RexCallImplementor defineEquiv(SqlOperator operator, SqlOperator previousOperator) {
            return this.define(operator, this.get(previousOperator));
        }

        void defineAgg(SqlAggFunction operator, Class<? extends AggImplementor> klass) {
            this.defineAgg(operator, AbstractBuilder.constructorSupplier(klass));
        }

        void defineWinAgg(SqlAggFunction operator, Class<? extends WinAggImplementor> klass) {
            this.defineWinAgg(operator, AbstractBuilder.constructorSupplier(klass));
        }

        protected abstract RexCallImplementor get(SqlOperator var1);

        void populate1() {
            this.defineMethod((SqlOperator)SqlInternalOperators.THROW_UNLESS, BuiltInMethod.THROW_UNLESS.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ROW, BuiltInMethod.ARRAY.method, NullPolicy.ALL);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.UPPER, BuiltInMethod.UPPER.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.LOWER, BuiltInMethod.LOWER.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.INITCAP, BuiltInMethod.INITCAP.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TO_BASE64, BuiltInMethod.TO_BASE64.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.FROM_BASE64, BuiltInMethod.FROM_BASE64.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TO_BASE32, BuiltInMethod.TO_BASE32.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.FROM_BASE32, BuiltInMethod.FROM_BASE32.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TO_HEX, BuiltInMethod.TO_HEX.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.FROM_HEX, BuiltInMethod.FROM_HEX.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MD5, BuiltInMethod.MD5.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SHA1, BuiltInMethod.SHA1.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SHA256, BuiltInMethod.SHA256.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SHA512, BuiltInMethod.SHA512.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.SUBSTRING, BuiltInMethod.SUBSTRING.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.FORMAT_NUMBER, BuiltInMethod.FORMAT_NUMBER.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.LEFT, BuiltInMethod.LEFT.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.RIGHT, BuiltInMethod.RIGHT.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.LPAD, BuiltInMethod.LPAD.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.RPAD, BuiltInMethod.RPAD.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.STARTS_WITH, BuiltInMethod.STARTS_WITH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ENDS_WITH, BuiltInMethod.ENDS_WITH.method, NullPolicy.STRICT);
            this.define((SqlOperator)SqlStdOperatorTable.REPLACE, new ReplaceImplementor());
            this.defineMethod((SqlOperator)SqlLibraryOperators.TRANSLATE3, BuiltInMethod.TRANSLATE3.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CHR, BuiltInMethod.CHAR_FROM_UTF8.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.OCTET_LENGTH, BuiltInMethod.OCTET_LENGTH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.BIT_LENGTH, BuiltInMethod.BIT_LENGTH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.BIT_GET, BuiltInMethod.BIT_GET.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.GETBIT, BuiltInMethod.BIT_GET.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.BITAND, BuiltInMethod.BIT_AND.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.BITOR, BuiltInMethod.BIT_OR.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.BITXOR, BuiltInMethod.BIT_XOR.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.BITNOT, BuiltInMethod.BIT_NOT.method, NullPolicy.STRICT);
            this.define((SqlOperator)SqlStdOperatorTable.CONCAT, new ConcatImplementor());
            this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT_FUNCTION, BuiltInMethod.MULTI_STRING_CONCAT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT_FUNCTION_WITH_NULL, BuiltInMethod.MULTI_STRING_CONCAT_WITH_NULL.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT2, BuiltInMethod.STRING_CONCAT_WITH_NULL.method, NullPolicy.ALL);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT_WS, BuiltInMethod.MULTI_STRING_CONCAT_WITH_SEPARATOR.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT_WS_POSTGRESQL, BuiltInMethod.MULTI_TYPE_OBJECT_CONCAT_WITH_SEPARATOR.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT_WS_MSSQL, BuiltInMethod.MULTI_STRING_CONCAT_WITH_SEPARATOR.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT_WS_SPARK, BuiltInMethod.MULTI_TYPE_STRING_ARRAY_CONCAT_WITH_SEPARATOR.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.OVERLAY, BuiltInMethod.OVERLAY.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.POSITION, BuiltInMethod.POSITION.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ASCII, BuiltInMethod.ASCII.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CHAR, BuiltInMethod.CHAR_FROM_ASCII.method, NullPolicy.SEMI_STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CODE_POINTS_TO_BYTES, BuiltInMethod.CODE_POINTS_TO_BYTES.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CODE_POINTS_TO_STRING, BuiltInMethod.CODE_POINTS_TO_STRING.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TO_CODE_POINTS, BuiltInMethod.TO_CODE_POINTS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.REPEAT, BuiltInMethod.REPEAT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SPACE, BuiltInMethod.SPACE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.STRCMP, BuiltInMethod.STRCMP.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SOUNDEX, BuiltInMethod.SOUNDEX.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SOUNDEX_SPARK, BuiltInMethod.SOUNDEX_SPARK.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.DIFFERENCE, BuiltInMethod.DIFFERENCE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.REVERSE, BuiltInMethod.REVERSE.method, NullPolicy.STRICT);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REVERSE_SPARK, BuiltInMethod.REVERSE.method, BuiltInMethod.ARRAY_REVERSE.method);
            this.defineMethod((SqlOperator)SqlLibraryOperators.LEVENSHTEIN, BuiltInMethod.LEVENSHTEIN.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SPLIT, BuiltInMethod.SPLIT.method, NullPolicy.STRICT);
            this.defineReflective((SqlOperator)SqlLibraryOperators.PARSE_URL, BuiltInMethod.PARSE_URL2.method, BuiltInMethod.PARSE_URL3.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP, BuiltInMethod.RLIKE.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_LIKE, BuiltInMethod.RLIKE.method, BuiltInMethod.REGEXP_LIKE3.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_CONTAINS, BuiltInMethod.REGEXP_CONTAINS.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_EXTRACT, BuiltInMethod.REGEXP_EXTRACT2.method, BuiltInMethod.REGEXP_EXTRACT3.method, BuiltInMethod.REGEXP_EXTRACT4.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_EXTRACT_ALL, BuiltInMethod.REGEXP_EXTRACT_ALL.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_INSTR, BuiltInMethod.REGEXP_INSTR2.method, BuiltInMethod.REGEXP_INSTR3.method, BuiltInMethod.REGEXP_INSTR4.method, BuiltInMethod.REGEXP_INSTR5.method);
            this.defineMethod((SqlOperator)SqlLibraryOperators.FIND_IN_SET, BuiltInMethod.FIND_IN_SET.method, NullPolicy.ANY);
            this.define((SqlOperator)SqlStdOperatorTable.TRIM, new TrimImplementor());
            this.define((SqlOperator)SqlLibraryOperators.CONTAINS_SUBSTR, new ContainsSubstrImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.AND, new LogicalAndImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.OR, new LogicalOrImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.NOT, new LogicalNotImplementor());
            this.defineBinary((SqlOperator)SqlStdOperatorTable.LESS_THAN, ExpressionType.LessThan, NullPolicy.STRICT, "lt");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ExpressionType.LessThanOrEqual, NullPolicy.STRICT, "le");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.GREATER_THAN, ExpressionType.GreaterThan, NullPolicy.STRICT, "gt");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ExpressionType.GreaterThanOrEqual, NullPolicy.STRICT, "ge");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.EQUALS, ExpressionType.Equal, NullPolicy.STRICT, "eq");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, ExpressionType.NotEqual, NullPolicy.STRICT, "ne");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.PLUS, ExpressionType.Add, NullPolicy.STRICT, "plus");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.MINUS, ExpressionType.Subtract, NullPolicy.STRICT, "minus");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.MULTIPLY, ExpressionType.Multiply, NullPolicy.STRICT, "multiply");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.DIVIDE, ExpressionType.Divide, NullPolicy.STRICT, "divide");
            this.defineBinary((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, ExpressionType.Divide, NullPolicy.STRICT, "divide");
            this.defineUnary((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, ExpressionType.Negate, NullPolicy.STRICT, BuiltInMethod.BIG_DECIMAL_NEGATE.getMethodName());
            this.defineUnary((SqlOperator)SqlStdOperatorTable.UNARY_PLUS, ExpressionType.UnaryPlus, NullPolicy.STRICT, null);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.MOD, BuiltInMethod.MOD.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.EXP, BuiltInMethod.EXP.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.POWER, BuiltInMethod.POWER.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.POWER_PG, BuiltInMethod.POWER_PG.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ABS, BuiltInMethod.ABS.method, NullPolicy.STRICT);
            this.define((SqlOperator)SqlLibraryOperators.LOG_POSTGRES, new LogImplementor(null));
            this.define((SqlOperator)SqlLibraryOperators.LOG_MYSQL, new LogImplementor(null));
            this.define((SqlOperator)SqlLibraryOperators.LOG2, new LogImplementor(null));
            this.defineReflective((SqlOperator)SqlStdOperatorTable.RAND, BuiltInMethod.RAND.method, BuiltInMethod.RAND_SEED.method);
            this.defineReflective((SqlOperator)SqlStdOperatorTable.RAND_INTEGER, BuiltInMethod.RAND_INTEGER.method, BuiltInMethod.RAND_INTEGER_SEED.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.RANDOM, BuiltInMethod.RAND.method);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ACOS, BuiltInMethod.ACOS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ACOSD, BuiltInMethod.ACOSD.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ACOSH, BuiltInMethod.ACOSH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ASIN, BuiltInMethod.ASIN.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ASIND, BuiltInMethod.ASIND.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ASINH, BuiltInMethod.ASINH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ATAN, BuiltInMethod.ATAN.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ATAN2, BuiltInMethod.ATAN2.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ATAND, BuiltInMethod.ATAND.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ATANH, BuiltInMethod.ATANH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.CBRT, BuiltInMethod.CBRT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.COS, BuiltInMethod.COS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.COSD, BuiltInMethod.COSD.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.COSH, BuiltInMethod.COSH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.COT, BuiltInMethod.COT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.COTH, BuiltInMethod.COTH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CSC, BuiltInMethod.CSC.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.CSCH, BuiltInMethod.CSCH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.DEGREES, BuiltInMethod.DEGREES.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.FACTORIAL, BuiltInMethod.FACTORIAL.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.IS_INF, BuiltInMethod.IS_INF.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.IS_NAN, BuiltInMethod.IS_NAN.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.POW, BuiltInMethod.POWER.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.RADIANS, BuiltInMethod.RADIANS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SEC, BuiltInMethod.SEC.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SECH, BuiltInMethod.SECH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.SIGN, BuiltInMethod.SIGN.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.SIN, BuiltInMethod.SIN.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SIND, BuiltInMethod.SIND.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.SINH, BuiltInMethod.SINH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.TAN, BuiltInMethod.TAN.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TAND, BuiltInMethod.TAND.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TANH, BuiltInMethod.TANH.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TRUNC_BIG_QUERY, BuiltInMethod.STRUNCATE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.LOG1P, BuiltInMethod.LOG1P.method, NullPolicy.STRICT);
            this.define((SqlOperator)SqlLibraryOperators.SAFE_ADD, new SafeArithmeticImplementor(BuiltInMethod.SAFE_ADD.method));
            this.define((SqlOperator)SqlLibraryOperators.SAFE_DIVIDE, new SafeArithmeticImplementor(BuiltInMethod.SAFE_DIVIDE.method));
            this.define((SqlOperator)SqlLibraryOperators.SAFE_MULTIPLY, new SafeArithmeticImplementor(BuiltInMethod.SAFE_MULTIPLY.method));
            this.define((SqlOperator)SqlLibraryOperators.SAFE_NEGATE, new SafeArithmeticImplementor(BuiltInMethod.SAFE_MULTIPLY.method));
            this.define((SqlOperator)SqlLibraryOperators.SAFE_SUBTRACT, new SafeArithmeticImplementor(BuiltInMethod.SAFE_SUBTRACT.method));
            this.define((SqlOperator)SqlStdOperatorTable.PI, new PiImplementor());
        }

        void populate2() {
            this.defineMethod((SqlOperator)SqlStdOperatorTable.BITCOUNT, BuiltInMethod.BITCOUNT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.BIT_COUNT_BIG_QUERY, BuiltInMethod.BITCOUNT.method, NullPolicy.STRICT);
            this.define((SqlOperator)SqlLibraryOperators.BIT_COUNT_MYSQL, new BitCountMySQLImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, new DatetimeArithmeticImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.MINUS_DATE, new DatetimeArithmeticImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.EXTRACT, new ExtractImplementor());
            this.define((SqlOperator)SqlLibraryOperators.DATE_PART, new ExtractImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.FLOOR, new FloorImplementor(BuiltInMethod.FLOOR.method, BuiltInMethod.UNIX_TIMESTAMP_FLOOR.method, BuiltInMethod.UNIX_DATE_FLOOR.method, BuiltInMethod.CUSTOM_TIMESTAMP_FLOOR.method, BuiltInMethod.CUSTOM_DATE_FLOOR.method));
            this.define((SqlOperator)SqlStdOperatorTable.CEIL, new FloorImplementor(BuiltInMethod.CEIL.method, BuiltInMethod.UNIX_TIMESTAMP_CEIL.method, BuiltInMethod.UNIX_DATE_CEIL.method, BuiltInMethod.CUSTOM_TIMESTAMP_CEIL.method, BuiltInMethod.CUSTOM_DATE_CEIL.method));
            this.define((SqlOperator)SqlStdOperatorTable.TIMESTAMP_ADD, new TimestampAddImplementor(BuiltInMethod.CUSTOM_TIMESTAMP_ADD.method, BuiltInMethod.CUSTOM_DATE_ADD.method));
            this.defineEquiv((SqlOperator)SqlLibraryOperators.DATEADD, (SqlOperator)SqlStdOperatorTable.TIMESTAMP_ADD);
            this.define((SqlOperator)SqlStdOperatorTable.TIMESTAMP_DIFF, new TimestampDiffImplementor(BuiltInMethod.CUSTOM_TIMESTAMP_DIFF.method, BuiltInMethod.CUSTOM_DATE_DIFF.method));
            this.defineEquiv((SqlOperator)SqlLibraryOperators.DATE_TRUNC, (SqlOperator)SqlStdOperatorTable.FLOOR);
            this.defineEquiv((SqlOperator)SqlLibraryOperators.TIMESTAMP_TRUNC, (SqlOperator)SqlStdOperatorTable.FLOOR);
            this.defineEquiv((SqlOperator)SqlLibraryOperators.TIME_TRUNC, (SqlOperator)SqlStdOperatorTable.FLOOR);
            this.defineEquiv((SqlOperator)SqlLibraryOperators.DATETIME_TRUNC, (SqlOperator)SqlStdOperatorTable.FLOOR);
            this.defineEquiv((SqlOperator)SqlLibraryOperators.CEIL_BIG_QUERY, (SqlOperator)SqlStdOperatorTable.CEIL);
            this.defineEquiv((SqlOperator)SqlLibraryOperators.FLOOR_BIG_QUERY, (SqlOperator)SqlStdOperatorTable.FLOOR);
            this.define((SqlOperator)SqlStdOperatorTable.LAST_DAY, new LastDayImplementor("lastDay", BuiltInMethod.LAST_DAY));
            this.define((SqlOperator)SqlLibraryOperators.DAYNAME, new PeriodNameImplementor("dayName", BuiltInMethod.DAYNAME_WITH_TIMESTAMP, BuiltInMethod.DAYNAME_WITH_DATE));
            this.define((SqlOperator)SqlLibraryOperators.MONTHNAME, new PeriodNameImplementor("monthName", BuiltInMethod.MONTHNAME_WITH_TIMESTAMP, BuiltInMethod.MONTHNAME_WITH_DATE));
            this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_SECONDS, BuiltInMethod.TIMESTAMP_SECONDS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_MILLIS, BuiltInMethod.TIMESTAMP_MILLIS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_MICROS, BuiltInMethod.TIMESTAMP_MICROS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_SECONDS, BuiltInMethod.UNIX_SECONDS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_MILLIS, BuiltInMethod.UNIX_MILLIS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_MICROS, BuiltInMethod.UNIX_MICROS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_DATE, BuiltInMethod.UNIX_DATE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.DATE, BuiltInMethod.DATE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.DATETIME, BuiltInMethod.DATETIME.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TIME, BuiltInMethod.TIME.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP, BuiltInMethod.TIMESTAMP.method, NullPolicy.STRICT);
            this.defineReflective((SqlOperator)SqlLibraryOperators.PARSE_DATE, BuiltInMethod.PARSE_DATE.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.PARSE_DATETIME, BuiltInMethod.PARSE_DATETIME.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.PARSE_TIME, BuiltInMethod.PARSE_TIME.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.PARSE_TIMESTAMP, BuiltInMethod.PARSE_TIMESTAMP.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.TO_CHAR, BuiltInMethod.TO_CHAR.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.TO_DATE, BuiltInMethod.TO_DATE.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.TO_TIMESTAMP, BuiltInMethod.TO_TIMESTAMP.method);
            FormatDatetimeImplementor datetimeFormatImpl = new FormatDatetimeImplementor();
            this.define((SqlOperator)SqlLibraryOperators.FORMAT_DATE, datetimeFormatImpl);
            this.define((SqlOperator)SqlLibraryOperators.FORMAT_DATETIME, datetimeFormatImpl);
            this.define((SqlOperator)SqlLibraryOperators.FORMAT_TIME, datetimeFormatImpl);
            this.define((SqlOperator)SqlLibraryOperators.FORMAT_TIMESTAMP, datetimeFormatImpl);
            this.define((SqlOperator)SqlStdOperatorTable.IS_NULL, new IsNullImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new IsNotNullImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.IS_TRUE, new IsTrueImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, new IsNotTrueImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.IS_FALSE, new IsFalseImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, new IsNotFalseImplementor());
            this.defineReflective((SqlOperator)SqlStdOperatorTable.LIKE, BuiltInMethod.LIKE.method, BuiltInMethod.LIKE_ESCAPE.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.ILIKE, BuiltInMethod.ILIKE.method, BuiltInMethod.ILIKE_ESCAPE.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.RLIKE, BuiltInMethod.RLIKE.method);
            this.defineReflective((SqlOperator)SqlStdOperatorTable.SIMILAR_TO, BuiltInMethod.SIMILAR.method, BuiltInMethod.SIMILAR_ESCAPE.method);
            ReflectiveImplementor insensitiveImplementor = this.defineReflective((SqlOperator)SqlStdOperatorTable.POSIX_REGEX_CASE_INSENSITIVE, BuiltInMethod.POSIX_REGEX_INSENSITIVE.method);
            ReflectiveImplementor sensitiveImplementor = this.defineReflective((SqlOperator)SqlStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, BuiltInMethod.POSIX_REGEX_SENSITIVE.method);
            this.define((SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_INSENSITIVE, NotImplementor.of(insensitiveImplementor));
            this.define((SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE, NotImplementor.of(sensitiveImplementor));
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_2, BuiltInMethod.REGEXP_REPLACE2.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_3, BuiltInMethod.REGEXP_REPLACE3.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_4, BuiltInMethod.REGEXP_REPLACE4.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_5, BuiltInMethod.REGEXP_REPLACE5_OCCURRENCE.method, BuiltInMethod.REGEXP_REPLACE5_MATCHTYPE.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_5_ORACLE, BuiltInMethod.REGEXP_REPLACE5_OCCURRENCE.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_6, BuiltInMethod.REGEXP_REPLACE6.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_BIG_QUERY_3, BuiltInMethod.REGEXP_REPLACE_BIG_QUERY_3.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_PG_3, BuiltInMethod.REGEXP_REPLACE_PG_3.method);
            this.defineReflective((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_PG_4, BuiltInMethod.REGEXP_REPLACE_PG_4.method);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.CARDINALITY, BuiltInMethod.COLLECTION_SIZE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.SLICE, BuiltInMethod.SLICE.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ELEMENT, BuiltInMethod.ELEMENT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.STRUCT_ACCESS, BuiltInMethod.STRUCT_ACCESS.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.MEMBER_OF, BuiltInMethod.MEMBER_OF.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_APPEND, BuiltInMethod.ARRAY_APPEND.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_COMPACT, BuiltInMethod.ARRAY_COMPACT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_CONTAINS, BuiltInMethod.LIST_CONTAINS.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_DISTINCT, BuiltInMethod.ARRAY_DISTINCT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_EXCEPT, BuiltInMethod.ARRAY_EXCEPT.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_JOIN, BuiltInMethod.ARRAY_TO_STRING.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_INSERT, BuiltInMethod.ARRAY_INSERT.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_INTERSECT, BuiltInMethod.ARRAY_INTERSECT.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_LENGTH, BuiltInMethod.COLLECTION_SIZE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_MAX, BuiltInMethod.ARRAY_MAX.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_MIN, BuiltInMethod.ARRAY_MIN.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_PREPEND, BuiltInMethod.ARRAY_PREPEND.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_POSITION, BuiltInMethod.ARRAY_POSITION.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_REMOVE, BuiltInMethod.ARRAY_REMOVE.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_REPEAT, BuiltInMethod.ARRAY_REPEAT.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_REVERSE, BuiltInMethod.ARRAY_REVERSE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_SIZE, BuiltInMethod.COLLECTION_SIZE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_SLICE, BuiltInMethod.ARRAY_SLICE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_TO_STRING, BuiltInMethod.ARRAY_TO_STRING.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY_UNION, BuiltInMethod.ARRAY_UNION.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAYS_OVERLAP, BuiltInMethod.ARRAYS_OVERLAP.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAYS_ZIP, BuiltInMethod.ARRAYS_ZIP.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.EXISTS, BuiltInMethod.EXISTS.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MAP_CONCAT, BuiltInMethod.MAP_CONCAT.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MAP_CONTAINS_KEY, BuiltInMethod.MAP_CONTAINS_KEY.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MAP_ENTRIES, BuiltInMethod.MAP_ENTRIES.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MAP_KEYS, BuiltInMethod.MAP_KEYS.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MAP_VALUES, BuiltInMethod.MAP_VALUES.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MAP_FROM_ARRAYS, BuiltInMethod.MAP_FROM_ARRAYS.method, NullPolicy.ANY);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MAP_FROM_ENTRIES, BuiltInMethod.MAP_FROM_ENTRIES.method, NullPolicy.STRICT);
            this.define((SqlOperator)SqlLibraryOperators.STR_TO_MAP, new StringToMapImplementor());
            this.defineMethod((SqlOperator)SqlLibraryOperators.SUBSTRING_INDEX, BuiltInMethod.SUBSTRING_INDEX.method, NullPolicy.STRICT);
            this.define((SqlOperator)SqlLibraryOperators.ARRAY_CONCAT, new ArrayConcatImplementor());
            this.define((SqlOperator)SqlLibraryOperators.SORT_ARRAY, new SortArrayImplementor());
            MethodImplementor isEmptyImplementor = new MethodImplementor(BuiltInMethod.IS_EMPTY.method, NullPolicy.STRICT, false);
            this.define((SqlOperator)SqlStdOperatorTable.IS_EMPTY, isEmptyImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_EMPTY, NotImplementor.of(isEmptyImplementor));
            MethodImplementor isASetImplementor = new MethodImplementor(BuiltInMethod.IS_A_SET.method, NullPolicy.STRICT, false);
            this.define((SqlOperator)SqlStdOperatorTable.IS_A_SET, isASetImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_A_SET, NotImplementor.of(isASetImplementor));
            this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_INTERSECT_DISTINCT, BuiltInMethod.MULTISET_INTERSECT_DISTINCT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_INTERSECT, BuiltInMethod.MULTISET_INTERSECT_ALL.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_EXCEPT_DISTINCT, BuiltInMethod.MULTISET_EXCEPT_DISTINCT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_EXCEPT, BuiltInMethod.MULTISET_EXCEPT_ALL.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_UNION_DISTINCT, BuiltInMethod.MULTISET_UNION_DISTINCT.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_UNION, BuiltInMethod.MULTISET_UNION_ALL.method, NullPolicy.STRICT);
            MethodImplementor subMultisetImplementor = new MethodImplementor(BuiltInMethod.SUBMULTISET_OF.method, NullPolicy.STRICT, false);
            this.define((SqlOperator)SqlStdOperatorTable.SUBMULTISET_OF, subMultisetImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.NOT_SUBMULTISET_OF, NotImplementor.of(subMultisetImplementor));
            this.define((SqlOperator)SqlStdOperatorTable.COALESCE, new CoalesceImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.CAST, new CastImplementor());
            this.define((SqlOperator)SqlLibraryOperators.SAFE_CAST, new CastImplementor());
            this.define((SqlOperator)SqlLibraryOperators.TRY_CAST, new CastImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.REINTERPRET, new ReinterpretImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.CONVERT, new ConvertImplementor());
            this.define((SqlOperator)SqlStdOperatorTable.TRANSLATE, new TranslateImplementor());
            ValueConstructorImplementor value = new ValueConstructorImplementor();
            this.define((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, value);
            this.define((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, value);
            this.defineMethod((SqlOperator)SqlLibraryOperators.ARRAY, BuiltInMethod.ARRAYS_AS_LIST.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlLibraryOperators.MAP, BuiltInMethod.MAP.method, NullPolicy.NONE);
            this.define(SqlStdOperatorTable.ITEM, new ItemImplementor());
            ArrayItemImplementor arrayItemImplementor = new ArrayItemImplementor();
            this.define(SqlLibraryOperators.OFFSET, arrayItemImplementor);
            this.define(SqlLibraryOperators.ORDINAL, arrayItemImplementor);
            this.define(SqlLibraryOperators.SAFE_OFFSET, arrayItemImplementor);
            this.define(SqlLibraryOperators.SAFE_ORDINAL, arrayItemImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.DEFAULT, new DefaultImplementor());
            this.defineMethod(SqlStdOperatorTable.CURRENT_VALUE, BuiltInMethod.SEQUENCE_CURRENT_VALUE.method, NullPolicy.STRICT);
            this.defineMethod(SqlStdOperatorTable.NEXT_VALUE, BuiltInMethod.SEQUENCE_NEXT_VALUE.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlLibraryOperators.COMPRESS, BuiltInMethod.COMPRESS.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.URL_ENCODE, BuiltInMethod.URL_ENCODE.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.URL_DECODE, BuiltInMethod.URL_DECODE.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.EXTRACT_VALUE, BuiltInMethod.EXTRACT_VALUE.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.XML_TRANSFORM, BuiltInMethod.XML_TRANSFORM.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.EXTRACT_XML, BuiltInMethod.EXTRACT_XML.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.EXISTS_NODE, BuiltInMethod.EXISTS_NODE.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_VALUE_EXPRESSION, BuiltInMethod.JSON_VALUE_EXPRESSION.method, NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_TYPE_OPERATOR, BuiltInMethod.JSON_VALUE_EXPRESSION.method, NullPolicy.STRICT);
            this.defineReflective((SqlOperator)SqlStdOperatorTable.JSON_EXISTS, BuiltInMethod.JSON_EXISTS2.method, BuiltInMethod.JSON_EXISTS3.method);
            this.define((SqlOperator)SqlStdOperatorTable.JSON_VALUE, new JsonValueImplementor(BuiltInMethod.JSON_VALUE.method));
            this.define((SqlOperator)SqlStdOperatorTable.JSON_QUERY, new JsonQueryImplementor(BuiltInMethod.JSON_QUERY.method));
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_TYPE, BuiltInMethod.JSON_TYPE.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_DEPTH, BuiltInMethod.JSON_DEPTH.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_INSERT, BuiltInMethod.JSON_INSERT.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_KEYS, BuiltInMethod.JSON_KEYS.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_PRETTY, BuiltInMethod.JSON_PRETTY.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_LENGTH, BuiltInMethod.JSON_LENGTH.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_REMOVE, BuiltInMethod.JSON_REMOVE.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_STORAGE_SIZE, BuiltInMethod.JSON_STORAGE_SIZE.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_REPLACE, BuiltInMethod.JSON_REPLACE.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_SET, BuiltInMethod.JSON_SET.method, NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_OBJECT, BuiltInMethod.JSON_OBJECT.method, NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_ARRAY, BuiltInMethod.JSON_ARRAY.method, NullPolicy.NONE);
            this.defineAgg((SqlAggFunction)SqlStdOperatorTable.JSON_OBJECTAGG.with(SqlJsonConstructorNullClause.ABSENT_ON_NULL), JsonObjectAggImplementor.supplierFor(BuiltInMethod.JSON_OBJECTAGG_ADD.method));
            this.defineAgg((SqlAggFunction)SqlStdOperatorTable.JSON_OBJECTAGG.with(SqlJsonConstructorNullClause.NULL_ON_NULL), JsonObjectAggImplementor.supplierFor(BuiltInMethod.JSON_OBJECTAGG_ADD.method));
            this.defineAgg((SqlAggFunction)SqlStdOperatorTable.JSON_ARRAYAGG.with(SqlJsonConstructorNullClause.ABSENT_ON_NULL), JsonArrayAggImplementor.supplierFor(BuiltInMethod.JSON_ARRAYAGG_ADD.method));
            this.defineAgg((SqlAggFunction)SqlStdOperatorTable.JSON_ARRAYAGG.with(SqlJsonConstructorNullClause.NULL_ON_NULL), JsonArrayAggImplementor.supplierFor(BuiltInMethod.JSON_ARRAYAGG_ADD.method));
            this.define((SqlOperator)SqlStdOperatorTable.IS_JSON_VALUE, new MethodImplementor(BuiltInMethod.IS_JSON_VALUE.method, NullPolicy.NONE, false));
            this.define((SqlOperator)SqlStdOperatorTable.IS_JSON_OBJECT, new MethodImplementor(BuiltInMethod.IS_JSON_OBJECT.method, NullPolicy.NONE, false));
            this.define((SqlOperator)SqlStdOperatorTable.IS_JSON_ARRAY, new MethodImplementor(BuiltInMethod.IS_JSON_ARRAY.method, NullPolicy.NONE, false));
            this.define((SqlOperator)SqlStdOperatorTable.IS_JSON_SCALAR, new MethodImplementor(BuiltInMethod.IS_JSON_SCALAR.method, NullPolicy.NONE, false));
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_JSON_VALUE, NotJsonImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_VALUE.method, NullPolicy.NONE, false)));
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_JSON_OBJECT, NotJsonImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_OBJECT.method, NullPolicy.NONE, false)));
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_JSON_ARRAY, NotJsonImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_ARRAY.method, NullPolicy.NONE, false)));
            this.define((SqlOperator)SqlStdOperatorTable.IS_NOT_JSON_SCALAR, NotJsonImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_SCALAR.method, NullPolicy.NONE, false)));
        }

        void populate3() {
            SystemFunctionImplementor systemFunctionImplementor = new SystemFunctionImplementor();
            this.define((SqlOperator)SqlStdOperatorTable.USER, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.CURRENT_USER, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.SESSION_USER, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.SYSTEM_USER, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.CURRENT_PATH, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.CURRENT_ROLE, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.CURRENT_CATALOG, systemFunctionImplementor);
            this.define((SqlOperator)IgniteSqlOperatorTable.CURRENT_TIMESTAMP, systemFunctionImplementor);
            this.define((SqlOperator)SqlLibraryOperators.CURRENT_DATETIME, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.LOCALTIME, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, systemFunctionImplementor);
            this.defineAgg(SqlStdOperatorTable.COUNT, CountImplementor.class);
            this.defineAgg(SqlStdOperatorTable.REGR_COUNT, CountImplementor.class);
            this.defineAgg(SqlStdOperatorTable.SUM0, SumImplementor.class);
            this.defineAgg(SqlStdOperatorTable.SUM, SumImplementor.class);
            this.defineAgg(SqlStdOperatorTable.MIN, MinMaxImplementor.class);
            this.defineAgg(SqlStdOperatorTable.MAX, MinMaxImplementor.class);
            this.defineAgg((SqlAggFunction)SqlStdOperatorTable.ARG_MIN, ArgMinMaxImplementor.class);
            this.defineAgg((SqlAggFunction)SqlStdOperatorTable.ARG_MAX, ArgMinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.MIN_BY, ArgMinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.MAX_BY, ArgMinMaxImplementor.class);
            this.defineAgg(SqlStdOperatorTable.ANY_VALUE, MinMaxImplementor.class);
            this.defineAgg(SqlStdOperatorTable.SOME, MinMaxImplementor.class);
            this.defineAgg(SqlStdOperatorTable.EVERY, MinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.BOOL_AND, MinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.BOOL_OR, MinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.BOOLAND_AGG, MinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.BOOLOR_AGG, MinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.LOGICAL_AND, MinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.LOGICAL_OR, MinMaxImplementor.class);
            this.defineAgg(SqlLibraryOperators.BITAND_AGG, BitOpImplementor.class);
            this.defineAgg(SqlLibraryOperators.BITOR_AGG, BitOpImplementor.class);
            this.defineAgg(SqlStdOperatorTable.BIT_AND, BitOpImplementor.class);
            this.defineAgg(SqlStdOperatorTable.BIT_OR, BitOpImplementor.class);
            this.defineAgg(SqlStdOperatorTable.BIT_XOR, BitOpImplementor.class);
            this.defineAgg(SqlStdOperatorTable.SINGLE_VALUE, SingleValueImplementor.class);
            this.defineAgg(SqlStdOperatorTable.COLLECT, CollectImplementor.class);
            this.defineAgg(SqlLibraryOperators.ARRAY_AGG, CollectImplementor.class);
            this.defineAgg(SqlStdOperatorTable.LISTAGG, ListaggImplementor.class);
            this.defineAgg(SqlStdOperatorTable.FUSION, FusionImplementor.class);
            this.defineAgg(SqlStdOperatorTable.MODE, ModeImplementor.class);
            this.defineAgg(SqlLibraryOperators.ARRAY_CONCAT_AGG, FusionImplementor.class);
            this.defineAgg(SqlStdOperatorTable.INTERSECTION, IntersectionImplementor.class);
            this.defineAgg(SqlStdOperatorTable.GROUPING, GroupingImplementor.class);
            this.defineAgg(SqlStdOperatorTable.GROUPING_ID, GroupingImplementor.class);
            this.defineAgg(SqlInternalOperators.LITERAL_AGG, LiteralAggImplementor.class);
            this.defineMatch(SqlStdOperatorTable.CLASSIFIER, () -> new ClassifierImplementor());
        }

        void populateIgnite() {
            IgniteSystemFunctionImplementor systemFunctionImplementor = new IgniteSystemFunctionImplementor();
            this.defineMethod((SqlOperator)IgniteSqlOperatorTable.RAND_UUID, IgniteMethod.RAND_UUID.method(), NullPolicy.NONE);
            this.defineMethod((SqlOperator)IgniteSqlOperatorTable.GREATEST2, IgniteMethod.GREATEST2.method(), NullPolicy.NONE);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, IgniteMethod.IS_NOT_DISTINCT_FROM.method(), NullPolicy.NONE);
            this.defineMethod((SqlOperator)IgniteSqlOperatorTable.LEAST2, IgniteMethod.LEAST2.method(), NullPolicy.NONE);
            this.defineMethod((SqlOperator)IgniteSqlOperatorTable.LENGTH, IgniteMethod.LENGTH.method(), NullPolicy.STRICT);
            this.defineMethod((SqlOperator)IgniteSqlOperatorTable.OCTET_LENGTH, IgniteMethod.OCTET_LENGTH.method(), NullPolicy.STRICT);
            this.defineMethod((SqlOperator)IgniteSqlOperatorTable.SUBSTR, IgniteMethod.SUBSTR.method(), NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.ROUND, IgniteMethod.ROUND.method(), NullPolicy.STRICT);
            this.defineMethod((SqlOperator)SqlStdOperatorTable.TRUNCATE, IgniteMethod.TRUNCATE.method(), NullPolicy.STRICT);
            this.defineMethod((SqlOperator)IgniteSqlOperatorTable.DECIMAL_DIVIDE, IgniteMethod.DECIMAL_DIVIDE.method(), NullPolicy.ARG0);
            this.defineMethod((SqlOperator)SqlLibraryOperators.DATE_FROM_UNIX_DATE, IgniteMethod.TO_DATE_EXACT.method(), NullPolicy.STRICT);
            this.define((SqlOperator)SqlStdOperatorTable.LN, new LogImplementor(null));
            this.define((SqlOperator)SqlLibraryOperators.LOG, new LogImplementor(null));
            this.define((SqlOperator)SqlStdOperatorTable.LOG10, new LogImplementor(null));
            this.define((SqlOperator)IgniteSqlOperatorTable.TYPEOF, systemFunctionImplementor);
            this.define((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, systemFunctionImplementor);
            this.define((SqlOperator)GridgainSqlOperatorTable.CURRENT_TIMESTAMP_PLUS_INTERVAL, systemFunctionImplementor);
            this.define((SqlOperator)GridgainSqlOperatorTable.CURRENT_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PLUS_INTERVAL, systemFunctionImplementor);
            this.define((SqlOperator)GridgainSqlOperatorTable.NEXTVAL, systemFunctionImplementor);
            this.define((SqlOperator)GridgainSqlOperatorTable.CURRVAL, systemFunctionImplementor);
            this.define((SqlOperator)GridgainSqlOperatorTable.SETVAL, systemFunctionImplementor);
        }

        private static <T> Supplier<T> constructorSupplier(Class<T> klass) {
            Constructor constructor;
            try {
                constructor = klass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(klass + " should implement zero arguments constructor");
            }
            return () -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IllegalStateException("Error while creating aggregate implementor " + constructor, e);
                }
            };
        }

        private static class IgniteSystemFunctionImplementor
        extends AbstractRexCallImplementor {
            IgniteSystemFunctionImplementor() {
                super("ignite_system_func", NullPolicy.NONE, false);
            }

            @Override
            Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
                SqlOperator op = call.getOperator();
                if (op == IgniteSqlOperatorTable.TYPEOF) {
                    if (call.getOperands().size() == 1) {
                        CallImplementor implementor = IgniteSystemFunctionImplementor.createTypeOfImplementor();
                        return implementor.implement(translator, call, NullAs.NOT_POSSIBLE);
                    }
                } else {
                    if (op == SqlStdOperatorTable.CURRENT_DATE) {
                        return Expressions.call((Method)IgniteMethod.CURRENT_DATE.method(), (Expression[])new Expression[]{translator.getRoot()});
                    }
                    if (op == GridgainSqlOperatorTable.CURRENT_TIMESTAMP_PLUS_INTERVAL) {
                        Expression root = translator.getRoot();
                        return Expressions.call((Method)GridgainMethod.CURRENT_TIMESTAMP_PLUS_INTERVAL.method(), (Expression[])new Expression[]{root, argValueList.get(0)});
                    }
                    if (op == GridgainSqlOperatorTable.CURRENT_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PLUS_INTERVAL) {
                        Expression root = translator.getRoot();
                        return Expressions.call((Method)GridgainMethod.CURRENT_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PLUS_INTERVAL.method(), (Expression[])new Expression[]{root, argValueList.get(0)});
                    }
                    if (op == GridgainSqlOperatorTable.NEXTVAL) {
                        List args = Lists.asList((Object)translator.getRoot(), (Object[])((Expression[])argValueList.toArray(Expression[]::new)));
                        return Expressions.call((Method)GridgainMethod.NEXTVAL.method(), (Iterable)args);
                    }
                    if (op == GridgainSqlOperatorTable.CURRVAL) {
                        List args = Lists.asList((Object)translator.getRoot(), (Object[])((Expression[])argValueList.toArray(Expression[]::new)));
                        return Expressions.call((Method)GridgainMethod.CURRVAL.method(), (Iterable)args);
                    }
                    if (op == GridgainSqlOperatorTable.SETVAL) {
                        List args = Lists.asList((Object)translator.getRoot(), (Object[])((Expression[])argValueList.toArray(Expression[]::new)));
                        return Expressions.call((Method)GridgainMethod.SETVAL.method(), (Iterable)args);
                    }
                }
                throw new AssertionError((Object)("unknown function " + op));
            }

            private static CallImplementor createTypeOfImplementor() {
                return RexImpTable.createImplementor((translator, call, translatedOperands) -> {
                    Method method = IgniteMethod.CONSUME_FIRST_ARGUMENT.method();
                    RexNode operand = (RexNode)call.getOperands().get(0);
                    String operandType = operand.getType().toString();
                    ArrayList<Object> finalOperands = new ArrayList<Object>(2);
                    finalOperands.add((Expression)translatedOperands.get(0));
                    finalOperands.add(Expressions.constant((Object)operandType));
                    return Expressions.call((Method)method, finalOperands);
                }, NullPolicy.NONE, false);
            }

            private static CallImplementor createTableFunctionImplementor(Method method) {
                return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method){

                    @Override
                    public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
                        Expression expr = super.implement(translator, call, translatedOperands);
                        Class<?> returnType = this.method.getReturnType();
                        if (QueryableTable.class.isAssignableFrom(returnType)) {
                            MethodCallExpression queryable = Expressions.call((Expression)Expressions.convert_((Expression)expr, QueryableTable.class), (Method)BuiltInMethod.QUERYABLE_TABLE_AS_QUERYABLE.method, (Expression[])new Expression[]{Expressions.call((Expression)translator.getRoot(), (Method)BuiltInMethod.DATA_CONTEXT_GET_QUERY_PROVIDER.method, (Expression[])new Expression[0]), Expressions.constant(null, SchemaPlus.class), Expressions.constant((Object)call.getOperator().getName(), String.class)});
                            expr = Expressions.call((Expression)queryable, (Method)BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, (Expression[])new Expression[0]);
                        } else {
                            expr = Expressions.call((Expression)expr, (Method)BuiltInMethod.SCANNABLE_TABLE_SCAN.method, (Expression[])new Expression[]{translator.getRoot()});
                        }
                        return expr;
                    }
                }, NullPolicy.NONE, false);
            }
        }
    }
}

