/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.metrics;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.metric.Metric;
import org.apache.ignite3.internal.rest.api.metric.MetricSet;
import org.apache.ignite3.internal.rest.api.metric.MetricSource;
import org.apache.ignite3.internal.rest.api.metric.NodeMetricApi;
import org.apache.ignite3.internal.rest.metrics.exception.MetricNotFoundException;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/metric/node")
public class NodeMetricController
implements NodeMetricApi,
ResourceHolder,
SecurityContextAware {
    private MetricManager metricManager;
    private final SecurityService securityService;

    public NodeMetricController(MetricManager metricManager, SecurityService securityService) {
        this.metricManager = metricManager;
        this.securityService = securityService;
    }

    @Override
    public void enable(String srcName) {
        try {
            this.secured(() -> this.metricManager.enable(srcName));
        }
        catch (IllegalStateException e) {
            throw new MetricNotFoundException(e);
        }
    }

    @Override
    public void disable(String srcName) {
        try {
            this.secured(() -> this.metricManager.disable(srcName));
        }
        catch (IllegalStateException e) {
            throw new MetricNotFoundException(e);
        }
    }

    @Override
    public Collection<MetricSource> listMetricSources() {
        return this.secured(() -> this.metricManager.metricSources().stream().map(source -> new MetricSource(source.name(), source.enabled())).sorted(Comparator.comparing(MetricSource::name)).collect(Collectors.toList()));
    }

    @Override
    public Collection<MetricSet> listMetricSets() {
        return this.secured(() -> this.metricManager.metricSnapshot().metrics().values().stream().map(metricSet -> {
            List<Metric> metricDtos = StreamSupport.stream(metricSet.spliterator(), false).map(metric -> new Metric(metric.name(), metric.description())).sorted(Comparator.comparing(Metric::name)).collect(Collectors.toList());
            return new MetricSet(metricSet.name(), metricDtos);
        }).sorted(Comparator.comparing(MetricSet::name)).collect(Collectors.toList()));
    }

    @Override
    public void cleanResources() {
        this.metricManager = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

