/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.dcr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.apache.ignite3.internal.rest.api.dcr.ReplicationStatus;
import org.apache.ignite3.internal.tostring.S;

@Schema(description="Contains detailed information about a specific table replication process.")
public class TableStatus {
    @Schema(description="Current status of the table replication.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final ReplicationStatus status;
    @Schema(description="Table name", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String table;

    @JsonCreator
    public TableStatus(@JsonProperty(value="table") String table, @JsonProperty(value="status") ReplicationStatus status) {
        this.table = table;
        this.status = status;
    }

    @JsonGetter
    public String table() {
        return this.table;
    }

    @JsonGetter
    public ReplicationStatus status() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableStatus that = (TableStatus)o;
        return this.status == that.status && Objects.equals(this.table, that.table);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.table});
    }

    public String toString() {
        return S.toString(this);
    }
}

