/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partitiondistribution;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.partitiondistribution.DistributionAlgorithm;
import org.apache.ignite3.internal.partitiondistribution.FairPartitionDistributionAlgorithm;

public class PartitionDistributionUtils {
    private static final DistributionAlgorithm DISTRIBUTION_ALGORITHM = new FairPartitionDistributionAlgorithm();

    public static List<Set<Assignment>> calculateAssignments(Collection<String> dataNodes, List<Set<Assignment>> currentDistribution, int partitions, int replicas, int consensusGroupSize) {
        return DISTRIBUTION_ALGORITHM.assignPartitions(dataNodes, currentDistribution, partitions, replicas, consensusGroupSize);
    }

    public static Set<Assignment> calculateAssignmentForPartition(Collection<String> dataNodes, List<Set<Assignment>> currentDistribution, int partitionId, int partitions, int replicas, int consensusGroupSize) {
        List<Set<Assignment>> assignments = PartitionDistributionUtils.calculateAssignments(dataNodes, currentDistribution, partitions, replicas, consensusGroupSize);
        return assignments.get(partitionId);
    }
}

