/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyStorageOperationReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyStorageOperationReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyStorageOperationReplicaRequestSerializer;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.storage.operation.StorageOptimizedOperation;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ReadOnlyStorageOperationReplicaRequestImpl
implements ReadOnlyStorageOperationReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16382;
    @IgniteToStringInclude
    private final int batchSize;
    @IgniteToStringInclude
    private final UUID coordinatorId;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final HybridTimestamp readTimestamp;
    @IgniteToStringInclude
    private final long scanId;
    @IgniteToStringInclude
    private StorageOptimizedOperation storageOperation;
    private byte[] storageOperationByteArray;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID transactionId;
    @IgniteToStringInclude
    private final boolean usePrimary;

    private ReadOnlyStorageOperationReplicaRequestImpl(int batchSize, UUID coordinatorId, ReplicationGroupIdMessage groupId, HybridTimestamp readTimestamp, long scanId, StorageOptimizedOperation storageOperation, byte[] storageOperationByteArray, int tableId, HybridTimestamp timestamp, UUID transactionId, boolean usePrimary) {
        this.batchSize = batchSize;
        this.coordinatorId = coordinatorId;
        this.groupId = groupId;
        this.readTimestamp = readTimestamp;
        this.scanId = scanId;
        if (storageOperation == null && storageOperationByteArray == null) {
            throw new NullPointerException("storageOperation is not marked @Nullable");
        }
        this.storageOperation = storageOperation;
        this.storageOperationByteArray = storageOperationByteArray;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
        this.usePrimary = usePrimary;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public long scanId() {
        return this.scanId;
    }

    byte[] storageOperationByteArray() {
        return this.storageOperationByteArray;
    }

    @Override
    public StorageOptimizedOperation storageOperation() {
        return this.storageOperation;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    @Override
    public boolean usePrimary() {
        return this.usePrimary;
    }

    public MessageSerializer serializer() {
        return ReadOnlyStorageOperationReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadOnlyStorageOperationReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 16382;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadOnlyStorageOperationReplicaRequestImpl otherMessage = (ReadOnlyStorageOperationReplicaRequestImpl)other;
        return Objects.equals(this.coordinatorId, otherMessage.coordinatorId) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.readTimestamp, otherMessage.readTimestamp) && Objects.equals(this.storageOperation, otherMessage.storageOperation) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && this.batchSize == otherMessage.batchSize && this.scanId == otherMessage.scanId && this.tableId == otherMessage.tableId && this.usePrimary == otherMessage.usePrimary;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchSize, this.scanId, this.tableId, this.usePrimary, this.coordinatorId, this.groupId, this.readTimestamp, this.storageOperation, this.timestamp, this.transactionId);
        return result;
    }

    @Override
    public ReadOnlyStorageOperationReplicaRequestImpl clone() {
        try {
            return (ReadOnlyStorageOperationReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadOnlyStorageOperationReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
        MarshalledObject storageOperationByteArraymo = marshaller.marshal(this.storageOperation);
        usedDescriptors.addAll((IntCollection)storageOperationByteArraymo.usedDescriptorIds());
        this.storageOperationByteArray = storageOperationByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
        this.storageOperation = (StorageOptimizedOperation)marshaller.unmarshal(this.storageOperationByteArray, descriptorsObj);
        this.storageOperationByteArray = null;
    }

    private static class Builder
    implements ReadOnlyStorageOperationReplicaRequestBuilder {
        private int batchSize;
        private UUID coordinatorId;
        private ReplicationGroupIdMessage groupId;
        private HybridTimestamp readTimestamp;
        private long scanId;
        private StorageOptimizedOperation storageOperation;
        private byte[] storageOperationByteArray;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID transactionId;
        private boolean usePrimary;

        private Builder() {
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder coordinatorId(UUID coordinatorId) {
            this.coordinatorId = coordinatorId;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder readTimestamp(HybridTimestamp readTimestamp) {
            Objects.requireNonNull(readTimestamp, "readTimestamp is not marked @Nullable");
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder scanId(long scanId) {
            this.scanId = scanId;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder storageOperation(StorageOptimizedOperation storageOperation) {
            Objects.requireNonNull(storageOperation, "storageOperation is not marked @Nullable");
            this.storageOperation = storageOperation;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder storageOperationByteArray(byte[] storageOperationByteArray) {
            this.storageOperationByteArray = storageOperationByteArray;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder transactionId(UUID transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequestBuilder usePrimary(boolean usePrimary) {
            this.usePrimary = usePrimary;
            return this;
        }

        @Override
        public int batchSize() {
            return this.batchSize;
        }

        @Override
        public UUID coordinatorId() {
            return this.coordinatorId;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        @Override
        public long scanId() {
            return this.scanId;
        }

        @Override
        public StorageOptimizedOperation storageOperation() {
            return this.storageOperation;
        }

        @Override
        public byte[] storageOperationByteArray() {
            return this.storageOperationByteArray;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public boolean usePrimary() {
            return this.usePrimary;
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequest build() {
            return new ReadOnlyStorageOperationReplicaRequestImpl(this.batchSize, this.coordinatorId, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.readTimestamp, "readTimestamp is not marked @Nullable"), this.scanId, this.storageOperation, this.storageOperationByteArray, this.tableId, this.timestamp, this.transactionId, this.usePrimary);
        }

        @Override
        public ReadOnlyStorageOperationReplicaRequest buildDeserialized() {
            return new ReadOnlyStorageOperationReplicaRequestImpl(this.batchSize, this.coordinatorId, this.groupId, this.readTimestamp, this.scanId, this.storageOperation, this.storageOperationByteArray, this.tableId, this.timestamp, this.transactionId, this.usePrimary);
        }
    }
}

