/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessageBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class BinaryRowWithTombstoneMessageImpl
implements BinaryRowWithTombstoneMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 103;
    @IgniteToStringInclude
    private final ByteBuffer binaryTuple;
    @IgniteToStringInclude
    private final long commitTimestamp;
    @IgniteToStringInclude
    private final UUID rowId;
    @IgniteToStringInclude
    private final int schemaVersion;
    @IgniteToStringInclude
    private final boolean tombstone;

    private BinaryRowWithTombstoneMessageImpl(ByteBuffer binaryTuple, long commitTimestamp, UUID rowId, int schemaVersion, boolean tombstone) {
        this.binaryTuple = binaryTuple;
        this.commitTimestamp = commitTimestamp;
        this.rowId = rowId;
        this.schemaVersion = schemaVersion;
        this.tombstone = tombstone;
    }

    @Override
    public ByteBuffer binaryTuple() {
        return this.binaryTuple;
    }

    @Override
    public long commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public UUID rowId() {
        return this.rowId;
    }

    @Override
    public int schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public boolean tombstone() {
        return this.tombstone;
    }

    public MessageSerializer serializer() {
        return BinaryRowWithTombstoneMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(BinaryRowWithTombstoneMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 103;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BinaryRowWithTombstoneMessageImpl otherMessage = (BinaryRowWithTombstoneMessageImpl)other;
        return Objects.equals(this.binaryTuple, otherMessage.binaryTuple) && Objects.equals(this.rowId, otherMessage.rowId) && this.commitTimestamp == otherMessage.commitTimestamp && this.schemaVersion == otherMessage.schemaVersion && this.tombstone == otherMessage.tombstone;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commitTimestamp, this.schemaVersion, this.tombstone, this.binaryTuple, this.rowId);
        return result;
    }

    @Override
    public BinaryRowWithTombstoneMessageImpl clone() {
        try {
            return (BinaryRowWithTombstoneMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BinaryRowWithTombstoneMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements BinaryRowWithTombstoneMessageBuilder {
        private ByteBuffer binaryTuple;
        private long commitTimestamp;
        private UUID rowId;
        private int schemaVersion;
        private boolean tombstone;

        private Builder() {
        }

        @Override
        public BinaryRowWithTombstoneMessageBuilder binaryTuple(ByteBuffer binaryTuple) {
            Objects.requireNonNull(binaryTuple, "binaryTuple is not marked @Nullable");
            this.binaryTuple = binaryTuple;
            return this;
        }

        @Override
        public BinaryRowWithTombstoneMessageBuilder commitTimestamp(long commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public BinaryRowWithTombstoneMessageBuilder rowId(UUID rowId) {
            Objects.requireNonNull(rowId, "rowId is not marked @Nullable");
            this.rowId = rowId;
            return this;
        }

        @Override
        public BinaryRowWithTombstoneMessageBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public BinaryRowWithTombstoneMessageBuilder tombstone(boolean tombstone) {
            this.tombstone = tombstone;
            return this;
        }

        @Override
        public ByteBuffer binaryTuple() {
            return this.binaryTuple;
        }

        @Override
        public long commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public UUID rowId() {
            return this.rowId;
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public boolean tombstone() {
            return this.tombstone;
        }

        @Override
        public BinaryRowWithTombstoneMessage build() {
            return new BinaryRowWithTombstoneMessageImpl(Objects.requireNonNull(this.binaryTuple, "binaryTuple is not marked @Nullable"), this.commitTimestamp, Objects.requireNonNull(this.rowId, "rowId is not marked @Nullable"), this.schemaVersion, this.tombstone);
        }

        @Override
        public BinaryRowWithTombstoneMessage buildDeserialized() {
            return new BinaryRowWithTombstoneMessageImpl(this.binaryTuple, this.commitTimestamp, this.rowId, this.schemaVersion, this.tombstone);
        }
    }
}

