/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics.exporters.otlp;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.List;
import org.apache.ignite3.internal.metrics.DoubleMetric;
import org.apache.ignite3.internal.metrics.exporters.otlp.IgniteGaugeData;
import org.apache.ignite3.internal.metrics.exporters.otlp.IgniteMetricData;
import org.apache.ignite3.internal.metrics.exporters.otlp.IgnitePointData;
import org.apache.ignite3.internal.util.Lazy;

class IgniteDoubleMetricData
extends IgniteMetricData<DoubleMetric> {
    private final Data<IgniteDoublePointData> data;

    IgniteDoubleMetricData(Lazy<Resource> resource, InstrumentationScopeInfo scope, DoubleMetric metric) {
        super(resource, scope, metric);
        this.data = new IgniteGaugeData<IgniteDoublePointData>(new IgniteDoublePointData(metric));
    }

    public MetricDataType getType() {
        return MetricDataType.DOUBLE_GAUGE;
    }

    public Data<?> getData() {
        return this.data;
    }

    private static class IgniteDoublePointData
    extends IgnitePointData
    implements DoublePointData {
        private final DoubleMetric metric;

        IgniteDoublePointData(DoubleMetric metric) {
            this.metric = metric;
        }

        public double getValue() {
            return this.metric.value();
        }

        public List<DoubleExemplarData> getExemplars() {
            return Collections.emptyList();
        }
    }
}

