/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.command.CompactionCommand;
import org.apache.ignite3.internal.metastorage.command.EvictIdempotentCommandsCacheCommand;
import org.apache.ignite3.internal.metastorage.command.GetAllCommand;
import org.apache.ignite3.internal.metastorage.command.GetChecksumCommand;
import org.apache.ignite3.internal.metastorage.command.GetCommand;
import org.apache.ignite3.internal.metastorage.command.GetCurrentRevisionsCommand;
import org.apache.ignite3.internal.metastorage.command.InvokeCommand;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.MultiInvokeCommand;
import org.apache.ignite3.internal.metastorage.command.PutAllCommand;
import org.apache.ignite3.internal.metastorage.command.PutCommand;
import org.apache.ignite3.internal.metastorage.command.RemoveAllCommand;
import org.apache.ignite3.internal.metastorage.command.RemoveByPrefixCommand;
import org.apache.ignite3.internal.metastorage.command.RemoveCommand;
import org.apache.ignite3.internal.metastorage.command.SyncTimeCommand;
import org.apache.ignite3.internal.metastorage.command.response.ChecksumInfo;
import org.apache.ignite3.internal.metastorage.command.response.RevisionsInfo;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Iif;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.StatementResult;
import org.apache.ignite3.internal.metastorage.impl.CommandIdGenerator;
import org.apache.ignite3.internal.metastorage.impl.CursorPublisher;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageService;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageServiceContext;
import org.apache.ignite3.internal.raft.ReadCommand;
import org.apache.ignite3.internal.raft.service.RaftGroupService;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class MetaStorageServiceImpl
implements MetaStorageService {
    private static final IgniteLogger LOG = Loggers.forClass(MetaStorageService.class);
    public static final int BATCH_SIZE = 1000;
    private static final int TIMEOUT_MILLIS = 30000;
    private final MetaStorageServiceContext context;
    private final HybridClock clock;
    private final CommandIdGenerator commandIdGenerator;

    public MetaStorageServiceImpl(String nodeName, RaftGroupService metaStorageRaftGrpSvc, IgniteSpinBusyLock busyLock, HybridClock clock, UUID localNodeId) {
        this.context = new MetaStorageServiceContext(metaStorageRaftGrpSvc, new MetaStorageCommandsFactory(), Executors.newFixedThreadPool(5, IgniteThreadFactory.create(nodeName, "metastorage-publisher", LOG, new ThreadOperation[0])), busyLock);
        this.clock = clock;
        this.commandIdGenerator = new CommandIdGenerator(localNodeId);
    }

    public RaftGroupService raftGroupService() {
        return this.context.raftService();
    }

    @Override
    public CompletableFuture<Entry> get(ByteArray key) {
        return this.get(key, -1L);
    }

    @Override
    public CompletableFuture<Entry> get(ByteArray key, long revUpperBound) {
        GetCommand getCommand = this.context.commandsFactory().getCommand().key(ByteBuffer.wrap(key.bytes())).revision(revUpperBound).build();
        return this.context.raftService().run(getCommand, 30000L);
    }

    @Override
    public CompletableFuture<Map<ByteArray, Entry>> getAll(Set<ByteArray> keys) {
        return this.getAll(keys, -1L);
    }

    @Override
    public CompletableFuture<Map<ByteArray, Entry>> getAll(Set<ByteArray> keys, long revUpperBound) {
        GetAllCommand getAllCommand = GetAllCommand.getAllCommand(this.context.commandsFactory(), keys, revUpperBound);
        return this.context.raftService().run(getAllCommand).thenApply(MetaStorageServiceImpl::multipleEntryResult);
    }

    @Override
    public CompletableFuture<Void> put(ByteArray key, byte[] value) {
        PutCommand putCommand = this.context.commandsFactory().putCommand().key(ByteBuffer.wrap(key.bytes())).value(ByteBuffer.wrap(value)).initiatorTime(this.clock.now()).build();
        return this.context.raftService().run(putCommand, 30000L);
    }

    @Override
    public CompletableFuture<Void> putAll(Map<ByteArray, byte[]> vals) {
        PutAllCommand putAllCommand = this.putAllCommand(this.context.commandsFactory(), vals, this.clock.now());
        return this.context.raftService().run(putAllCommand, 30000L);
    }

    @Override
    public CompletableFuture<Void> remove(ByteArray key) {
        RemoveCommand removeCommand = this.context.commandsFactory().removeCommand().key(ByteBuffer.wrap(key.bytes())).initiatorTime(this.clock.now()).build();
        return this.context.raftService().run(removeCommand, 30000L);
    }

    @Override
    public CompletableFuture<Void> removeAll(Set<ByteArray> keys) {
        RemoveAllCommand removeAllCommand = this.removeAllCommand(this.context.commandsFactory(), keys, this.clock.now());
        return this.context.raftService().run(removeAllCommand, 30000L);
    }

    @Override
    public CompletableFuture<Void> removeByPrefix(ByteArray prefix) {
        RemoveByPrefixCommand removeByPrefix = this.context.commandsFactory().removeByPrefixCommand().prefix(ByteBuffer.wrap(prefix.bytes())).initiatorTime(this.clock.now()).build();
        return this.context.raftService().run(removeByPrefix, 30000L);
    }

    @Override
    public CompletableFuture<Boolean> invoke(Condition condition, Operation success, Operation failure) {
        return this.invoke(condition, List.of(success), List.of(failure));
    }

    @Override
    public CompletableFuture<Boolean> invoke(Condition condition, List<Operation> success, List<Operation> failure) {
        InvokeCommand invokeCommand = this.context.commandsFactory().invokeCommand().condition(condition).success(success).failure(failure).initiatorTime(this.clock.now()).id(this.commandIdGenerator.newId()).build();
        return this.context.raftService().run(invokeCommand, 30000L);
    }

    @Override
    public CompletableFuture<StatementResult> invoke(Iif iif) {
        MultiInvokeCommand multiInvokeCommand = this.context.commandsFactory().multiInvokeCommand().iif(iif).initiatorTime(this.clock.now()).id(this.commandIdGenerator.newId()).build();
        return this.context.raftService().run(multiInvokeCommand, 30000L);
    }

    @Override
    public Flow.Publisher<Entry> range(ByteArray keyFrom, @Nullable ByteArray keyTo, long revUpperBound) {
        return this.range(keyFrom, keyTo, revUpperBound, false);
    }

    @Override
    public Flow.Publisher<Entry> range(ByteArray keyFrom, @Nullable ByteArray keyTo) {
        return this.range(keyFrom, keyTo, false);
    }

    @Override
    public Flow.Publisher<Entry> range(ByteArray keyFrom, @Nullable ByteArray keyTo, boolean includeTombstones) {
        return this.range(keyFrom, keyTo, -1L, includeTombstones);
    }

    @Override
    public Flow.Publisher<Entry> range(ByteArray keyFrom, @Nullable ByteArray keyTo, long revUpperBound, boolean includeTombstones) {
        Function<byte[], ReadCommand> getRangeCommand = prevKey -> this.context.commandsFactory().getRangeCommand().keyFrom(ByteBuffer.wrap(keyFrom.bytes())).keyTo(keyTo == null ? null : ByteBuffer.wrap(keyTo.bytes())).revUpperBound(revUpperBound).includeTombstones(includeTombstones).previousKey((byte[])prevKey).batchSize(1000).build();
        return new CursorPublisher(this.context, getRangeCommand);
    }

    @Override
    public Flow.Publisher<Entry> prefix(ByteArray prefix, long revUpperBound) {
        Function<byte[], ReadCommand> getPrefixCommand = prevKey -> this.context.commandsFactory().getPrefixCommand().prefix(ByteBuffer.wrap(prefix.bytes())).revUpperBound(revUpperBound).includeTombstones(false).previousKey((byte[])prevKey).batchSize(1000).build();
        return new CursorPublisher(this.context, getPrefixCommand);
    }

    CompletableFuture<Void> syncTime(HybridTimestamp safeTime, long term) {
        SyncTimeCommand syncTimeCommand = this.context.commandsFactory().syncTimeCommand().initiatorTime(safeTime).initiatorTerm(term).build();
        return this.context.raftService().run(syncTimeCommand, 30000L);
    }

    @Override
    public CompletableFuture<RevisionsInfo> currentRevisions() {
        GetCurrentRevisionsCommand cmd = this.context.commandsFactory().getCurrentRevisionsCommand().build();
        return this.context.raftService().run(cmd, -1L);
    }

    @Override
    public CompletableFuture<ChecksumInfo> checksum(long revision) {
        GetChecksumCommand cmd = this.context.commandsFactory().getChecksumCommand().revision(revision).build();
        return this.context.raftService().run(cmd);
    }

    CompletableFuture<Void> evictIdempotentCommandsCache(HybridTimestamp evictionTimestamp) {
        EvictIdempotentCommandsCacheCommand evictIdempotentCommandsCacheCommand = this.evictIdempotentCommandsCacheCommand(this.context.commandsFactory(), evictionTimestamp, this.clock.now());
        return this.context.raftService().run(evictIdempotentCommandsCacheCommand, 30000L);
    }

    @Override
    public void close() {
        this.context.close();
    }

    private static Map<ByteArray, Entry> multipleEntryResult(List<Entry> entries) {
        HashMap<ByteArray, Entry> res = IgniteUtils.newHashMap(entries.size());
        for (Entry e : entries) {
            res.put(new ByteArray(e.key()), e);
        }
        return res;
    }

    private PutAllCommand putAllCommand(MetaStorageCommandsFactory commandsFactory, Map<ByteArray, byte[]> vals, HybridTimestamp ts) {
        assert (!vals.isEmpty());
        int size = vals.size();
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(size);
        ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>(size);
        for (Map.Entry<ByteArray, byte[]> e : vals.entrySet()) {
            byte[] key = e.getKey().bytes();
            byte[] val = e.getValue();
            assert (key != null) : "Key could not be null.";
            assert (val != null) : "Value could not be null.";
            keys.add(ByteBuffer.wrap(key));
            values.add(ByteBuffer.wrap(val));
        }
        return commandsFactory.putAllCommand().keys(keys).values(values).initiatorTime(ts).build();
    }

    private RemoveAllCommand removeAllCommand(MetaStorageCommandsFactory commandsFactory, Set<ByteArray> keys, HybridTimestamp ts) {
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(keys.size());
        for (ByteArray key : keys) {
            list.add(ByteBuffer.wrap(key.bytes()));
        }
        return commandsFactory.removeAllCommand().keys(list).initiatorTime(ts).build();
    }

    private EvictIdempotentCommandsCacheCommand evictIdempotentCommandsCacheCommand(MetaStorageCommandsFactory commandsFactory, HybridTimestamp evictionTimestamp, HybridTimestamp ts) {
        return commandsFactory.evictIdempotentCommandsCacheCommand().evictionTimestamp(evictionTimestamp).initiatorTime(ts).build();
    }

    CompletableFuture<Void> sendCompactionCommand(long compactionRevision) {
        CompactionCommand command = this.context.commandsFactory().compactionCommand().compactionRevision(compactionRevision).initiatorTime(this.clock.now()).build();
        return this.context.raftService().run(command, 30000L);
    }
}

