/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.disaster.system.message;

import org.apache.ignite3.internal.disaster.system.message.ResetClusterMessage;
import org.apache.ignite3.internal.disaster.system.message.ResetClusterMessageImpl;
import org.apache.ignite3.internal.disaster.system.message.SystemDisasterRecoveryMessagesTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class ResetClusterMessageSerializer
implements MessageSerializer<ResetClusterMessage> {
    public static final ResetClusterMessageSerializer INSTANCE = new ResetClusterMessageSerializer();

    private ResetClusterMessageSerializer() {
    }

    @Override
    public boolean writeMessage(ResetClusterMessage msg, MessageWriter writer) throws MessageMappingException {
        ResetClusterMessageImpl message = (ResetClusterMessageImpl)msg;
        writer.setMessageTypeInfo(SystemDisasterRecoveryMessagesTypeInfos.resetClusterMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)9)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeUuid("clusterId", message.clusterId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("clusterName", message.clusterName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("conductor", message.conductor());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeSet("currentMetaStorageNodes", message.currentMetaStorageNodes(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeList("formerClusterIds", message.formerClusterIds(), MessageCollectionItemType.UUID);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeString("initialClusterConfiguration", message.initialClusterConfiguration());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeBoxedInt("metastorageReplicationFactor", message.metastorageReplicationFactor());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeSet("newCmgNodes", message.newCmgNodes(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeSet("participatingNodes", message.participatingNodes(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

