/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import org.apache.ignite3.internal.compute.ComputeMessagesTypeInfos;
import org.apache.ignite3.internal.compute.message.JobStateRequest;
import org.apache.ignite3.internal.compute.message.JobStateRequestImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class JobStateRequestSerializer
implements MessageSerializer<JobStateRequest> {
    public static final JobStateRequestSerializer INSTANCE = new JobStateRequestSerializer();

    private JobStateRequestSerializer() {
    }

    @Override
    public boolean writeMessage(JobStateRequest msg, MessageWriter writer) throws MessageMappingException {
        JobStateRequestImpl message = (JobStateRequestImpl)msg;
        writer.setMessageTypeInfo(ComputeMessagesTypeInfos.jobStateRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)1)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeUuid("jobId", message.jobId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

